/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.geoserver.util.ReaderUtils;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.dto.DataDTO;
import org.vfny.geoserver.global.dto.DataTransferObject;
import org.vfny.geoserver.global.dto.GeoServerDTO;
import org.vfny.geoserver.global.dto.WCSDTO;
import org.vfny.geoserver.global.dto.WFSDTO;
import org.vfny.geoserver.global.dto.WMSDTO;
import org.vfny.geoserver.global.xml.XMLConfigReader;

public class Config
implements ApplicationContextAware {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.global");
    WebApplicationContext context;
    XMLConfigReader reader;
    org.geoserver.config.GeoServer configuration;

    public File dataDirectory() {
        return GeoserverDataDirectory.getGeoserverDataDirectory();
    }

    public void setConfiguration(org.geoserver.config.GeoServer configuration) {
        this.configuration = configuration;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = (WebApplicationContext)context;
        ServletContext sc = this.context.getServletContext();
        GeoserverDataDirectory.init(this.context);
        try {
            this.doConfigSanityCheck();
        }
        catch (ConfigurationException ce) {
            LOGGER.severe(ce.getMessage());
            throw new BeanInitializationException(ce.getMessage(), (Throwable)ce);
        }
    }

    private void doConfigSanityCheck() throws ConfigurationException {
        File dataDirectory = this.dataDirectory();
        try {
            ReaderUtils.checkFile((File)dataDirectory, (boolean)true);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Can't access the configuration directory. Reason: " + e.getMessage(), e);
        }
    }

    public WebApplicationContext getApplictionContext() {
        return this.context;
    }

    public DataDTO getData() {
        return new Data(this.configuration).toDTO();
    }

    public GeoServerDTO getGeoServer() {
        return new GeoServer(this.configuration).toDTO();
    }

    public WMSDTO getWms() {
        return (WMSDTO)this.dto("org.vfny.geoserver.global.WMS");
    }

    public WFSDTO getWfs() {
        return (WFSDTO)this.dto("org.geoserver.wfs.WFS");
    }

    public WCSDTO getWcs() {
        return (WCSDTO)this.dto("org.vfny.geoserver.global.WCS");
    }

    DataTransferObject dto(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> c = clazz.getConstructor(org.geoserver.config.GeoServer.class);
            Service s = (Service)c.newInstance(this.configuration);
            return (DataTransferObject)s.toDTO();
        }
        catch (Exception e) {
            LOGGER.warning("Error loading service: " + className);
            return null;
        }
    }
}

