/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.measure.unit.Unit;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.impl.CoverageDimensionImpl;
import org.geoserver.catalog.impl.MetadataLinkInfoImpl;
import org.geoserver.data.util.CoverageStoreUtils;
import org.geoserver.data.util.CoverageUtils;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.GridRange2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.resources.XArray;
import org.geotools.util.SimpleInternationalString;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;
import org.vfny.geoserver.config.CoverageStoreConfig;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.CoverageDimension;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.dto.CoverageInfoDTO;

public class CoverageConfig {
    private static final InternationalString[] DIMENSION_NAMES = new InternationalString[]{new SimpleInternationalString("x"), new SimpleInternationalString("y"), new SimpleInternationalString("z"), new SimpleInternationalString("t")};
    private String formatId;
    private String name;
    private String wmsPath;
    private String label;
    private String description;
    private MetaDataLink metadataLink;
    private String dirName;
    private List keywords;
    private GeneralEnvelope envelope;
    private GeneralEnvelope lonLatWGS84Envelope;
    private GridGeometry grid;
    private CoverageDimension[] dimensions;
    private InternationalString[] dimentionNames;
    private List requestCRSs;
    private List responseCRSs;
    private String nativeFormat;
    private List supportedFormats;
    private String defaultInterpolationMethod;
    private List interpolationMethods;
    private String userDefinedCrsIdentifier;
    private CoordinateReferenceSystem nativeCrs;
    private String defaultStyle;
    private ArrayList styles;
    private Map parameters;

    public CoverageConfig(String formatId, Format format, AbstractGridCoverage2DReader reader, DataConfig dataConfig) throws ConfigurationException {
        StringBuilder key;
        GridCoverage2D gc;
        if (formatId == null || formatId.length() == 0) {
            throw new ConfigurationException("formatId is required for CoverageConfig");
        }
        if (format == null) {
            throw new ConfigurationException("Cannot handle format: " + formatId);
        }
        if (reader == null) {
            throw new ConfigurationException("Cannot handle null reader for format: " + formatId);
        }
        this.formatId = formatId;
        CoverageStoreConfig cvConfig = dataConfig.getDataFormat(formatId);
        if (cvConfig == null) {
            throw new ConfigurationException("selectedCoverageSetId required in Session");
        }
        this.nativeCrs = reader.getCrs();
        this.userDefinedCrsIdentifier = this.nativeCrs != null && !this.nativeCrs.getIdentifiers().isEmpty() ? this.nativeCrs.getIdentifiers().toArray()[0].toString() : "UNKNOWN";
        this.envelope = reader.getOriginalEnvelope();
        GeneralGridRange originalRange = reader.getOriginalGridRange();
        MathTransform gridToWorldCorner = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        this.grid = new GridGeometry2D((GridEnvelope)originalRange, reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), this.nativeCrs);
        try {
            this.lonLatWGS84Envelope = CoverageStoreUtils.getWGS84LonLatEnvelope((GeneralEnvelope)this.envelope);
        }
        catch (IndexOutOfBoundsException e) {
            ConfigurationException newEx = new ConfigurationException(new StringBuffer("Converting Envelope to Lat-Lon WGS84: ").append(e.getLocalizedMessage()).toString());
            newEx.initCause(e);
            throw newEx;
        }
        catch (FactoryException e) {
            ConfigurationException newEx = new ConfigurationException(new StringBuffer("Converting Envelope to Lat-Lon WGS84: ").append(e.getLocalizedMessage()).toString());
            newEx.initCause(e);
            throw newEx;
        }
        catch (TransformException e) {
            ConfigurationException newEx = new ConfigurationException(new StringBuffer("Converting Envelope to Lat-Lon WGS84: ").append(e.getLocalizedMessage()).toString());
            newEx.initCause(e);
            throw newEx;
        }
        try {
            ParameterValueGroup readParams = format.getReadParameters();
            Map parameters = CoverageUtils.getParametersKVP((ParameterValueGroup)readParams);
            int minX = originalRange.getLower(0);
            int minY = originalRange.getLower(1);
            int width = originalRange.getLength(0);
            int height = originalRange.getLength(1);
            int maxX = minX + (width <= 5 ? width : 5);
            int maxY = minY + (height <= 5 ? height : 5);
            GridRange2D testRange = new GridRange2D(minX, minY, maxX, maxY);
            GeneralEnvelope testEnvelope = CRS.transform((MathTransform)gridToWorldCorner, (Envelope)new GeneralEnvelope((Rectangle2D)testRange.getBounds()));
            testEnvelope.setCoordinateReferenceSystem(this.nativeCrs);
            parameters.put(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), new GridGeometry2D((GridEnvelope)testRange, (Envelope)testEnvelope));
            gc = (GridCoverage2D)reader.read(CoverageUtils.getParameters((ParameterValueGroup)readParams, (Map)parameters, (boolean)true));
            if (gc == null) {
                throw new ConfigurationException("Unable to acquire test coverage for format:" + formatId);
            }
            this.dimensions = this.parseCoverageDimesions(gc.getSampleDimensions());
        }
        catch (UnsupportedEncodingException e) {
            ConfigurationException newEx = new ConfigurationException(new StringBuffer("Coverage dimensions: ").append(e.getLocalizedMessage()).toString());
            newEx.initCause(e);
            throw newEx;
        }
        catch (IllegalArgumentException e) {
            ConfigurationException newEx = new ConfigurationException(new StringBuffer("Coverage dimensions: ").append(e.getLocalizedMessage()).toString());
            newEx.initCause(e);
            throw newEx;
        }
        catch (IOException e) {
            ConfigurationException newEx = new ConfigurationException(new StringBuffer("Coverage dimensions: ").append(e.getLocalizedMessage()).toString());
            newEx.initCause(e);
            throw newEx;
        }
        catch (TransformException e) {
            ConfigurationException newEx = new ConfigurationException(new StringBuffer("Coverage dimensions: ").append(e.getLocalizedMessage()).toString());
            newEx.initCause(e);
            throw newEx;
        }
        this.dimentionNames = this.getDimensionNames(gc);
        StringBuilder cvName = null;
        int count = 0;
        while (true) {
            key = new StringBuilder(gc.getName().toString());
            if (count > 0) {
                key.append("_").append(count);
            }
            Map coverages = dataConfig.getCoverages();
            Set cvKeySet = coverages.keySet();
            boolean key_exists = false;
            Iterator it = cvKeySet.iterator();
            while (it.hasNext()) {
                String cvKey = ((String)it.next()).toLowerCase();
                if (!cvKey.endsWith(key.toString().toLowerCase())) continue;
                key_exists = true;
            }
            if (!key_exists) break;
            ++count;
        }
        cvName = key;
        this.name = cvName.toString();
        this.wmsPath = "/";
        this.label = new StringBuffer(this.name).append(" is a ").append(format.getDescription()).toString();
        this.description = new StringBuffer("Generated from ").append(formatId).toString();
        MetadataLinkInfoImpl ml = new MetadataLinkInfoImpl();
        ml.setAbout(format.getDocURL());
        ml.setMetadataType("other");
        this.metadataLink = new MetaDataLink(ml);
        this.keywords = new ArrayList(10);
        this.keywords.add("WCS");
        this.keywords.add(formatId);
        this.keywords.add(this.name);
        this.nativeFormat = format.getName();
        this.dirName = new StringBuffer(formatId).append("_").append(this.name).toString();
        this.requestCRSs = new ArrayList();
        if (gc.getCoordinateReferenceSystem2D().getIdentifiers() != null && !gc.getCoordinateReferenceSystem2D().getIdentifiers().isEmpty()) {
            this.requestCRSs.add(((Identifier)gc.getCoordinateReferenceSystem2D().getIdentifiers().toArray()[0]).toString());
        }
        this.responseCRSs = new ArrayList();
        if (gc.getCoordinateReferenceSystem2D().getIdentifiers() != null && !gc.getCoordinateReferenceSystem2D().getIdentifiers().isEmpty()) {
            this.responseCRSs.add(((Identifier)gc.getCoordinateReferenceSystem2D().getIdentifiers().toArray()[0]).toString());
        }
        this.supportedFormats = new ArrayList();
        List formats = CoverageStoreUtils.listDataFormats();
        for (Format fTmp : formats) {
            String fName = fTmp.getName();
            if (fName.equalsIgnoreCase("WorldImage")) {
                this.supportedFormats.add("GIF");
                this.supportedFormats.add("PNG");
                this.supportedFormats.add("JPEG");
                this.supportedFormats.add("TIFF");
                continue;
            }
            if (fName.toLowerCase().startsWith("geotiff")) {
                this.supportedFormats.add("GeoTIFF");
                continue;
            }
            this.supportedFormats.add(fName);
        }
        this.defaultInterpolationMethod = "nearest neighbor";
        this.interpolationMethods = new ArrayList(10);
        this.interpolationMethods.add("nearest neighbor");
        this.interpolationMethods.add("bilinear");
        this.interpolationMethods.add("bicubic");
        this.defaultStyle = "raster";
        this.styles = new ArrayList();
        this.parameters = CoverageUtils.getParametersKVP((ParameterValueGroup)format.getReadParameters());
    }

    private InternationalString[] getDimensionNames(GridCoverage2D gc) {
        InternationalString[] names;
        if (gc.getCoordinateReferenceSystem() != null) {
            CoordinateSystem cs = gc.getCoordinateReferenceSystem().getCoordinateSystem();
            names = new InternationalString[cs.getDimension()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = new SimpleInternationalString(cs.getAxis(i).getName().getCode());
            }
        } else {
            names = (InternationalString[])XArray.resize((Object[])DIMENSION_NAMES, (int)gc.getDimension());
            for (int i = DIMENSION_NAMES.length; i < names.length; ++i) {
                names[i] = new SimpleInternationalString("dim" + (i + 1));
            }
        }
        return names;
    }

    private CoverageDimension[] parseCoverageDimesions(GridSampleDimension[] sampleDimensions) throws UnsupportedEncodingException {
        int length = sampleDimensions.length;
        CoverageDimension[] dims = new CoverageDimension[length];
        for (int i = 0; i < length; ++i) {
            dims[i] = new CoverageDimension(new CoverageDimensionImpl());
            dims[i].setName(sampleDimensions[i].getDescription().toString(Locale.getDefault()));
            StringBuffer label = new StringBuffer("GridSampleDimension".intern());
            Unit uom = sampleDimensions[i].getUnits();
            if (uom != null) {
                label.append("(".intern());
                this.parseUom(label, uom);
                label.append(")".intern());
            }
            label.append("[".intern());
            label.append(sampleDimensions[i].getMinimumValue());
            label.append(",".intern());
            label.append(sampleDimensions[i].getMaximumValue());
            label.append("]".intern());
            dims[i].setDescription(label.toString());
            dims[i].setRange(sampleDimensions[i].getRange());
            List categories = sampleDimensions[i].getCategories();
            if (categories == null) continue;
            for (Category cat : categories) {
                Double[] doubleArray;
                if (cat == null || !cat.getName().toString().equalsIgnoreCase("no data")) continue;
                double min = cat.getRange().getMinimum();
                double max = cat.getRange().getMaximum();
                CoverageDimension coverageDimension = dims[i];
                if (min == max) {
                    Double[] doubleArray2 = new Double[1];
                    doubleArray = doubleArray2;
                    doubleArray2[0] = new Double(min);
                } else {
                    Double[] doubleArray3 = new Double[2];
                    doubleArray3[0] = new Double(min);
                    doubleArray = doubleArray3;
                    doubleArray3[1] = new Double(max);
                }
                coverageDimension.setNullValues(doubleArray);
            }
        }
        return dims;
    }

    private void parseUom(StringBuffer label2, Unit uom) {
        String uomString = uom.toString();
        uomString = uomString.replaceAll("\ufffd", "^2");
        uomString = uomString.replaceAll("\ufffd", "^3");
        uomString = uomString.replaceAll("\ufffd", "A");
        uomString = uomString.replaceAll("\ufffd", "");
        label2.append(uomString);
    }

    public CoverageConfig(CoverageInfoDTO dto) {
        if (dto == null) {
            throw new NullPointerException("Non null CoverageInfoDTO required");
        }
        this.formatId = dto.getFormatId();
        this.name = dto.getName();
        this.wmsPath = dto.getWmsPath();
        this.label = dto.getLabel();
        this.description = dto.getDescription();
        this.metadataLink = dto.getMetadataLink();
        this.keywords = dto.getKeywords();
        this.userDefinedCrsIdentifier = dto.getUserDefinedCrsIdentifier();
        String nativeCrsWKT = dto.getNativeCrsWKT();
        try {
            this.nativeCrs = CRS.parseWKT((String)nativeCrsWKT);
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
        this.envelope = dto.getEnvelope();
        this.lonLatWGS84Envelope = dto.getLonLatWGS84Envelope();
        this.grid = dto.getGrid();
        this.dimensions = dto.getDimensions();
        this.dimentionNames = dto.getDimensionNames();
        this.nativeFormat = dto.getNativeFormat();
        this.dirName = dto.getDirName();
        this.requestCRSs = dto.getRequestCRSs();
        this.responseCRSs = dto.getResponseCRSs();
        this.supportedFormats = dto.getSupportedFormats();
        this.defaultInterpolationMethod = dto.getDefaultInterpolationMethod();
        this.interpolationMethods = dto.getInterpolationMethods();
        this.defaultStyle = dto.getDefaultStyle();
        this.styles = dto.getStyles();
        this.parameters = dto.getParameters();
    }

    public CoverageInfoDTO toDTO() {
        CoverageInfoDTO c = new CoverageInfoDTO();
        c.setFormatId(this.formatId);
        c.setName(this.name);
        c.setWmsPath(this.wmsPath);
        c.setLabel(this.label);
        c.setDescription(this.description);
        c.setMetadataLink(this.metadataLink);
        c.setKeywords(this.keywords);
        c.setUserDefinedCrsIdentifier(this.userDefinedCrsIdentifier);
        c.setNativeCrsWKT(this.nativeCrs.toWKT());
        c.setEnvelope(this.envelope);
        c.setLonLatWGS84Envelope(this.lonLatWGS84Envelope);
        c.setGrid(this.grid);
        c.setDimensions(this.dimensions);
        c.setDimensionNames(this.dimentionNames);
        c.setNativeFormat(this.nativeFormat);
        c.setDirName(this.dirName);
        c.setRequestCRSs(this.requestCRSs);
        c.setResponseCRSs(this.responseCRSs);
        c.setSupportedFormats(this.supportedFormats);
        c.setDefaultInterpolationMethod(this.defaultInterpolationMethod);
        c.setInterpolationMethods(this.interpolationMethods);
        c.setDefaultStyle(this.defaultStyle);
        c.setStyles(this.styles);
        c.setParameters(this.parameters);
        return c;
    }

    protected DataConfig getDataConfig(HttpServletRequest request) {
        return (DataConfig)request.getSession().getServletContext().getAttribute("Config.Data");
    }

    public String getKey() {
        return this.getFormatId() + ":::" + this.getName();
    }

    public String toString() {
        return "CoverageConfig[name: " + this.name + " dewcription: " + this.description + " srsName: " + this.userDefinedCrsIdentifier + "]";
    }

    public String getDefaultInterpolationMethod() {
        return this.defaultInterpolationMethod;
    }

    public void setDefaultInterpolationMethod(String defaultInterpolationMethod) {
        this.defaultInterpolationMethod = defaultInterpolationMethod;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public GeneralEnvelope getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(GeneralEnvelope envelope) {
        this.envelope = envelope;
    }

    public String getFormatId() {
        return this.formatId;
    }

    public void setFormatId(String formatId) {
        this.formatId = formatId;
    }

    public List getInterpolationMethods() {
        return this.interpolationMethods;
    }

    public void setInterpolationMethods(List interpolationMethods) {
        this.interpolationMethods = interpolationMethods;
    }

    public List getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List keywords) {
        this.keywords = keywords;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public MetaDataLink getMetadataLink() {
        return this.metadataLink;
    }

    public void setMetadataLink(MetaDataLink metadataLink) {
        this.metadataLink = metadataLink;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNativeFormat() {
        return this.nativeFormat;
    }

    public void setNativeFormat(String nativeFormat) {
        this.nativeFormat = nativeFormat;
    }

    public List getRequestCRSs() {
        return this.requestCRSs;
    }

    public void setRequestCRSs(List requestCRSs) {
        this.requestCRSs = requestCRSs;
    }

    public List getResponseCRSs() {
        return this.responseCRSs;
    }

    public void setResponseCRSs(List responseCRSs) {
        this.responseCRSs = responseCRSs;
    }

    public String getUserDefinedCrsIdentifier() {
        return this.userDefinedCrsIdentifier;
    }

    public void setUserDefinedCrsIdentifier(String srsName) {
        this.userDefinedCrsIdentifier = srsName;
    }

    public List getSupportedFormats() {
        return this.supportedFormats;
    }

    public void setSupportedFormats(List supportedFormats) {
        this.supportedFormats = supportedFormats;
    }

    public CoordinateReferenceSystem getNativeCrs() {
        return this.nativeCrs;
    }

    public void setNativeCrs(CoordinateReferenceSystem crs) {
        this.nativeCrs = crs;
    }

    public GridGeometry getGrid() {
        return this.grid;
    }

    public void setGrid(GridGeometry grid) {
        this.grid = grid;
    }

    public InternationalString[] getDimentionNames() {
        return this.dimentionNames;
    }

    public void setDimentionNames(InternationalString[] dimentionNames) {
        this.dimentionNames = dimentionNames;
    }

    public CoverageDimension[] getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(CoverageDimension[] dimensions) {
        this.dimensions = dimensions;
    }

    public String getDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(String defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public ArrayList getStyles() {
        return this.styles;
    }

    public void setStyles(ArrayList styles) {
        this.styles = styles;
    }

    public void addStyle(String style) {
        if (!this.styles.contains(style)) {
            this.styles.add(style);
        }
    }

    public GeneralEnvelope getLonLatWGS84Envelope() {
        return this.lonLatWGS84Envelope;
    }

    public String getWmsPath() {
        return this.wmsPath;
    }

    public void setWmsPath(String wmsPath) {
        this.wmsPath = wmsPath;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public synchronized void setParameters(Map parameters) {
        this.parameters = parameters;
    }
}

