/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class GeoServerTemplateLoader
implements TemplateLoader {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.template");
    FileTemplateLoader fileTemplateLoader = new FileTemplateLoader(GeoserverDataDirectory.getGeoserverDataDirectory());
    ClassTemplateLoader classTemplateLoader;
    SimpleFeatureType featureType;
    private String coverageName;

    public GeoServerTemplateLoader(Class caller) throws IOException {
        if (caller != null) {
            this.classTemplateLoader = new ClassTemplateLoader(caller, "");
        }
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public void setCoverageName(String coverageName) {
        this.coverageName = coverageName;
    }

    public Object findTemplateSource(String path) throws IOException {
        Object source;
        File template = null;
        try {
            String dirName;
            String baseDirName;
            if (this.featureType != null) {
                baseDirName = "featureTypes";
                dirName = GeoserverDataDirectory.findFeatureTypeDirName(this.featureType);
            } else if (this.coverageName != null) {
                baseDirName = "coverages";
                dirName = GeoserverDataDirectory.findCoverageDirName(this.coverageName);
            } else {
                baseDirName = "featureTypes";
                dirName = "";
            }
            template = (File)this.fileTemplateLoader.findTemplateSource(baseDirName + File.separator + dirName + File.separator + path);
            if (template != null) {
                return template;
            }
            template = (File)this.fileTemplateLoader.findTemplateSource(baseDirName + File.separator + path);
            if (template != null) {
                return template;
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        template = (File)this.fileTemplateLoader.findTemplateSource("templates" + File.separator + path);
        if (template != null) {
            return template;
        }
        if (this.classTemplateLoader != null && (source = this.classTemplateLoader.findTemplateSource(path)) != null) {
            return new ClassTemplateSource(path, source);
        }
        return null;
    }

    public long getLastModified(Object source) {
        if (source instanceof File) {
            return this.fileTemplateLoader.getLastModified(source);
        }
        ClassTemplateSource wrapper = (ClassTemplateSource)source;
        return this.classTemplateLoader.getLastModified(wrapper.source);
    }

    public Reader getReader(Object source, String encoding) throws IOException {
        if (source instanceof File) {
            return this.fileTemplateLoader.getReader(source, encoding);
        }
        ClassTemplateSource wrapper = (ClassTemplateSource)source;
        return this.classTemplateLoader.getReader(wrapper.source, encoding);
    }

    public void closeTemplateSource(Object source) throws IOException {
        if (source instanceof File) {
            this.fileTemplateLoader.closeTemplateSource(source);
        } else {
            ClassTemplateSource wrapper = (ClassTemplateSource)source;
            this.classTemplateLoader.closeTemplateSource(wrapper.source);
            wrapper.path = null;
            wrapper.source = null;
        }
    }

    static class ClassTemplateSource {
        String path;
        Object source;

        public ClassTemplateSource(String path, Object source) {
            this.path = path;
            this.source = source;
        }
    }
}

