/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.decorators.DecoratingFeatureTypeInfo;
import org.geoserver.security.decorators.ReadOnlyFeatureLocking;
import org.geoserver.security.decorators.ReadOnlyFeatureSource;
import org.geoserver.security.decorators.ReadOnlyFeatureStore;
import org.geoserver.security.decorators.SecuredDataStoreInfo;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.factory.Hints;
import org.opengis.util.ProgressListener;

public class SecuredFeatureTypeInfo
extends DecoratingFeatureTypeInfo {
    SecureCatalogImpl.WrapperPolicy policy;

    public SecuredFeatureTypeInfo(FeatureTypeInfo info, SecureCatalogImpl.WrapperPolicy policy) {
        super(info);
        this.policy = policy;
    }

    public FeatureSource getFeatureSource(ProgressListener listener, Hints hints) throws IOException {
        boolean challenge;
        FeatureSource fs = ((FeatureTypeInfo)this.delegate).getFeatureSource(listener, hints);
        if (fs == null) {
            return null;
        }
        boolean bl = challenge = this.policy.response == SecureCatalogImpl.Response.CHALLENGE;
        if (this.policy == SecureCatalogImpl.WrapperPolicy.METADATA) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        if (!challenge) {
            return new ReadOnlyFeatureSource(fs, false);
        }
        if (fs instanceof FeatureLocking) {
            return new ReadOnlyFeatureLocking((FeatureLocking)fs, true);
        }
        if (fs instanceof FeatureStore) {
            return new ReadOnlyFeatureStore((FeatureStore)fs, true);
        }
        return new ReadOnlyFeatureSource(fs, true);
    }

    public DataStoreInfo getStore() {
        DataStoreInfo store = ((FeatureTypeInfo)this.delegate).getStore();
        if (store == null) {
            return null;
        }
        return new SecuredDataStoreInfo(store, this.policy);
    }
}

