/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.decorators.DecoratingDataStoreInfo;
import org.geoserver.security.decorators.ReadOnlyDataStore;
import org.geotools.data.DataStore;
import org.opengis.util.ProgressListener;

public class SecuredDataStoreInfo
extends DecoratingDataStoreInfo {
    SecureCatalogImpl.WrapperPolicy policy;

    public SecuredDataStoreInfo(DataStoreInfo delegate, SecureCatalogImpl.WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    public DataStore getDataStore(ProgressListener listener) throws IOException {
        DataStore ds = super.getDataStore(listener);
        if (ds == null) {
            return null;
        }
        if (this.policy == SecureCatalogImpl.WrapperPolicy.METADATA) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        return new ReadOnlyDataStore(ds, this.policy.response == SecureCatalogImpl.Response.CHALLENGE);
    }
}

