/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.AccessMode;
import org.geoserver.security.DataAccessManager;
import org.geoserver.security.PropertyFileWatcher;
import org.geoserver.security.SecureTreeNode;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.GeoserverDataDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDataAccessManager
implements DataAccessManager {
    static final Logger LOGGER = Logging.getLogger(DataAccessManager.class);
    SecureTreeNode root;
    Catalog catalog;
    PropertyFileWatcher watcher;
    File layers;
    DataAccessManager.CatalogMode mode = DataAccessManager.CatalogMode.HIDE;

    DefaultDataAccessManager(Catalog catalog, Properties layers) {
        this.catalog = catalog;
        this.root = this.buildAuthorizationTree(layers);
    }

    DefaultDataAccessManager(Catalog catalog) throws Exception {
        this.catalog = catalog;
        File security = GeoserverDataDirectory.findConfigDir(GeoserverDataDirectory.getGeoserverDataDirectory(), "security");
        if (security == null || !security.exists()) {
            this.root = new SecureTreeNode();
        } else {
            this.layers = new File(security, "layers.properties");
            if (!this.layers.exists()) {
                this.root = new SecureTreeNode();
            } else {
                this.watcher = new PropertyFileWatcher(this.layers);
                this.root = this.buildAuthorizationTree(this.watcher.getProperties());
            }
        }
    }

    void checkPropertyFile() {
        try {
            if (this.watcher != null && this.watcher.isStale()) {
                this.root = this.buildAuthorizationTree(this.watcher.getProperties());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to reload data access rules from " + this.layers + ", keeping old rules", e);
        }
    }

    @Override
    public DataAccessManager.CatalogMode getMode() {
        return this.mode;
    }

    @Override
    public boolean canAccess(Authentication user, WorkspaceInfo workspace, AccessMode mode) {
        this.checkPropertyFile();
        SecureTreeNode node = this.root.getDeepestNode(new String[]{workspace.getName()});
        return node.canAccess(user, mode);
    }

    @Override
    public boolean canAccess(Authentication user, LayerInfo layer, AccessMode mode) {
        this.checkPropertyFile();
        if (layer.getResource() == null) {
            LOGGER.log(Level.FINE, "Layer " + layer + " has no attached resource, " + "assuming it's possible to access it");
            return true;
        }
        return this.canAccess(user, layer.getResource(), mode);
    }

    @Override
    public boolean canAccess(Authentication user, ResourceInfo resource, AccessMode mode) {
        String workspace;
        this.checkPropertyFile();
        try {
            workspace = resource.getStore().getWorkspace().getName();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Errors occurred trying to gather workspace of resource " + resource.getName());
            return true;
        }
        SecureTreeNode node = this.root.getDeepestNode(new String[]{workspace, resource.getName()});
        return node.canAccess(user, mode);
    }

    private SecureTreeNode buildAuthorizationTree(File layers) throws IOException, FileNotFoundException {
        Properties props = new Properties();
        props.load(new FileInputStream(layers));
        return this.buildAuthorizationTree(props);
    }

    SecureTreeNode buildAuthorizationTree(Properties props) {
        SecureTreeNode root = new SecureTreeNode();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            SecureTreeNode node;
            AccessMode mode;
            String ruleKey = (String)entry.getKey();
            String ruleValue = (String)entry.getValue();
            String rule = ruleKey + "=" + ruleValue;
            if ("mode".equalsIgnoreCase(ruleKey)) {
                try {
                    this.mode = DataAccessManager.CatalogMode.valueOf(ruleValue.toUpperCase());
                }
                catch (Exception e) {
                    LOGGER.warning("Invalid security mode " + ruleValue + " acceptable values are " + Arrays.asList(DataAccessManager.CatalogMode.values()));
                }
                continue;
            }
            String[] elements = this.parseElements(ruleKey);
            String workspace = elements[0];
            String layerName = elements[1];
            String modeAlias = elements[2];
            Set<String> roles = this.parseRoles(ruleValue);
            if (elements.length != 3) {
                LOGGER.warning("Invalid rule '" + rule + "', the standard form is [namespace].[layer].[mode]=[role]+ " + "Rule has been ignored");
            }
            if (!"*".equals(workspace) && this.catalog.getWorkspace(workspace) == null) {
                LOGGER.warning("Namespace/Workspace " + workspace + " is unknown in rule " + rule);
            }
            if (!"*".equals(layerName) && this.catalog.getLayer(layerName) == null) {
                LOGGER.warning("Layer " + workspace + " is unknown in rule + " + rule);
            }
            if ((mode = AccessMode.getByAlias(modeAlias)) == null) {
                LOGGER.warning("Unknown access mode " + modeAlias + " in " + entry.getKey() + ", skipping rule " + rule);
                continue;
            }
            if ("*".equals(workspace)) {
                if (!"*".equals(layerName)) {
                    LOGGER.warning("Invalid rule " + entry.getKey() + " when namespace " + "is * then also layer must be *. Skipping rule " + rule);
                    continue;
                }
                node = root;
            } else {
                SecureTreeNode ws = root.getChild(workspace);
                if (ws == null) {
                    ws = root.addChild(workspace);
                }
                if ("*".equals(layerName)) {
                    node = ws;
                } else {
                    SecureTreeNode layer = ws.getChild(layerName);
                    if (layer == null) {
                        layer = ws.addChild(layerName);
                    }
                    node = layer;
                }
            }
            if (node.getAuthorizedRoles(mode) != null && node.getAuthorizedRoles(mode).size() > 0) {
                LOGGER.warning("Rule " + rule + " is overriding another rule targetting the same resource");
            }
            node.setAuthorizedRoles(mode, roles);
        }
        return root;
    }

    Set<String> parseRoles(String roleCsv) {
        String[] rolesArray = roleCsv.split("[\\s,]+");
        HashSet<String> roles = new HashSet<String>(rolesArray.length);
        roles.addAll(Arrays.asList(rolesArray));
        for (String role : roles) {
            if (!"*".equals(role)) continue;
            return Collections.singleton("*");
        }
        return roles;
    }

    private String[] parseElements(String path) {
        return path.split("\\s*\\.\\s*");
    }
}

