/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.awt.Color;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GeneralGridGeometry;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.BufferedCoordinateOperationFactory;
import org.geotools.util.logging.Logging;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;

public class CoverageUtils {
    private static final BufferedCoordinateOperationFactory operationFactory = new BufferedCoordinateOperationFactory(new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
    private static final Logger LOGGER = Logging.getLogger((String)(class$org$vfny$geoserver$util$CoverageUtils == null ? (class$org$vfny$geoserver$util$CoverageUtils = CoverageUtils.class$("org.vfny.geoserver.util.CoverageUtils")) : class$org$vfny$geoserver$util$CoverageUtils).toString());
    public static final int TRANSPARENT = 0;
    public static final int OPAQUE = 1;
    static /* synthetic */ Class class$org$vfny$geoserver$util$CoverageUtils;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$lang$String;

    public static GeneralParameterValue[] getParameters(ParameterValueGroup params) {
        ArrayList<GeneralParameterValue> parameters = new ArrayList<GeneralParameterValue>();
        String readGeometryKey = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
        if (params != null && params.values().size() > 0) {
            List list = params.values();
            Iterator it = list.iterator();
            ParameterDescriptor descr = null;
            ParameterValue val = null;
            while (it.hasNext()) {
                String _key;
                val = (ParameterValue)it.next();
                if (val == null || "namespace".equals(_key = (descr = (ParameterDescriptor)val.getDescriptor()).getName().toString()) || _key.equalsIgnoreCase(readGeometryKey)) continue;
                Object value = val.getValue();
                parameters.add(new DefaultParameterDescriptor(_key, value.getClass(), null, value).createValue());
            }
            return !parameters.isEmpty() ? parameters.toArray(new GeneralParameterValue[parameters.size()]) : null;
        }
        return null;
    }

    public static GeneralParameterValue[] getParameters(ParameterValueGroup params, Map values) {
        return CoverageUtils.getParameters(params, values, false);
    }

    public static GeneralParameterValue[] getParameters(ParameterValueGroup params, Map values, boolean readGeom) {
        ArrayList<GeneralParameterValue> parameters = new ArrayList<GeneralParameterValue>();
        String readGeometryKey = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
        if (params != null && params.values().size() > 0) {
            List list = params.values();
            Iterator it = list.iterator();
            ParameterDescriptor descr = null;
            ParameterValue val = null;
            while (it.hasNext()) {
                String _key;
                val = (ParameterValue)it.next();
                if (val == null || "namespace".equals(_key = (descr = (ParameterDescriptor)val.getDescriptor()).getName().toString()) || _key.equalsIgnoreCase(readGeometryKey) && !readGeom) continue;
                Object value = CoverageUtils.getCvParamValue(_key, val, values);
                if (value == null && (_key.equalsIgnoreCase("InputTransparentColor") || _key.equalsIgnoreCase("OutputTransparentColor"))) {
                    parameters.add(new DefaultParameterDescriptor(_key, class$java$awt$Color == null ? CoverageUtils.class$("java.awt.Color") : class$java$awt$Color, null, value).createValue());
                    continue;
                }
                parameters.add(new DefaultParameterDescriptor(_key, value.getClass(), null, value).createValue());
            }
            return !parameters.isEmpty() ? parameters.toArray(new GeneralParameterValue[parameters.size()]) : null;
        }
        return null;
    }

    public static Map getParametersKVP(ParameterValueGroup params) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String readGeometryKey = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
        if (params != null && params.values().size() > 0) {
            List list = params.values();
            Iterator it = list.iterator();
            ParameterDescriptor descr = null;
            ParameterValue val = null;
            while (it.hasNext()) {
                String _key;
                val = (ParameterValue)it.next();
                if (val == null || "namespace".equals(_key = (descr = (ParameterDescriptor)val.getDescriptor()).getName().toString()) || _key.equalsIgnoreCase(readGeometryKey)) continue;
                Object value = val.getValue();
                String text = "";
                text = value == null ? null : (value instanceof String ? (String)value : value.toString());
                parameters.put(_key, text != null ? text : "");
            }
            return parameters;
        }
        return parameters;
    }

    public static Object getCvParamValue(String key, ParameterValue param, List paramValues, int index) {
        GeneralEnvelope value = null;
        try {
            if (key.equalsIgnoreCase("crs")) {
                if (CoverageUtils.getParamValue(paramValues, index) != null && CoverageUtils.getParamValue(paramValues, index).length() > 0) {
                    if (paramValues.get(index) != null && ((String)paramValues.get(index)).length() > 0) {
                        value = CRS.parseWKT((String)((String)paramValues.get(index)));
                    }
                } else {
                    LOGGER.info("Unable to find a crs for the coverage param, using EPSG:4326");
                    value = CRS.decode((String)"EPSG:4326");
                }
            } else if (key.equalsIgnoreCase("envelope")) {
                String tmp;
                if (CoverageUtils.getParamValue(paramValues, index) != null && CoverageUtils.getParamValue(paramValues, index).length() > 0 && (tmp = CoverageUtils.getParamValue(paramValues, index)).indexOf("[") > 0 && tmp.indexOf("]") > tmp.indexOf("[")) {
                    tmp = tmp.substring(tmp.indexOf("[") + 1, tmp.indexOf("]")).trim();
                    tmp = tmp.replaceAll(",", "");
                    String[] strCoords = tmp.split(" ");
                    double[] coords = new double[strCoords.length];
                    if (strCoords.length == 4) {
                        for (int iT = 0; iT < 4; ++iT) {
                            coords[iT] = Double.parseDouble(strCoords[iT].trim());
                        }
                        value = new GeneralEnvelope(new double[]{coords[0], coords[1]}, new double[]{coords[2], coords[3]});
                    }
                }
            } else if (key.equalsIgnoreCase("values_palette")) {
                if (CoverageUtils.getParamValue(paramValues, index) != null && CoverageUtils.getParamValue(paramValues, index).length() > 0) {
                    String tmp = CoverageUtils.getParamValue(paramValues, index);
                    String[] strColors = tmp.split(";");
                    Vector<Color> colors = new Vector<Color>();
                    for (int col = 0; col < strColors.length; ++col) {
                        if (Color.decode(strColors[col]) == null) continue;
                        colors.add(Color.decode(strColors[col]));
                    }
                    value = colors.toArray(new Color[colors.size()]);
                } else {
                    value = "#000000;#3C3C3C;#FFFFFF";
                }
            } else {
                Class[] clArray = new Class[]{CoverageUtils.getParamValue(paramValues, index).getClass()};
                Object[] inArray = new Object[]{CoverageUtils.getParamValue(paramValues, index)};
                value = param.getValue().getClass().getConstructor(clArray).newInstance(inArray);
            }
        }
        catch (Exception e) {
            value = null;
        }
        return value;
    }

    private static String getParamValue(List paramValues, int index) {
        return (String)paramValues.get(index);
    }

    public static Object getCvParamValue(String key, ParameterValue param, Map params) {
        Object value = null;
        try {
            if (key.equalsIgnoreCase("crs")) {
                if (params.get(key) != null && ((String)params.get(key)).length() > 0) {
                    value = CRS.parseWKT((String)((String)params.get(key)));
                } else {
                    LOGGER.info("Unable to find a crs for the coverage param, using EPSG:4326");
                    value = CRS.decode((String)"EPSG:4326");
                }
            } else if (key.equalsIgnoreCase("envelope")) {
                String tmp;
                if (params.get(key) != null && ((String)params.get(key)).length() > 0 && (tmp = (String)params.get(key)).indexOf("[") > 0 && tmp.indexOf("]") > tmp.indexOf("[")) {
                    tmp = tmp.substring(tmp.indexOf("[") + 1, tmp.indexOf("]")).trim();
                    tmp = tmp.replaceAll(",", "");
                    String[] strCoords = tmp.split(" ");
                    double[] coords = new double[strCoords.length];
                    if (strCoords.length == 4) {
                        for (int iT = 0; iT < 4; ++iT) {
                            coords[iT] = Double.parseDouble(strCoords[iT].trim());
                        }
                        value = new GeneralEnvelope(new double[]{coords[0], coords[1]}, new double[]{coords[2], coords[3]});
                    }
                }
            } else if (key.equalsIgnoreCase(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) {
                if (params.get(key) != null && params.get(key) instanceof String && ((String)params.get(key)).length() > 0) {
                    String tmp = (String)params.get(key);
                    if (tmp.indexOf("[") > 0 && tmp.indexOf("]") > tmp.indexOf("[")) {
                        tmp = tmp.substring(tmp.indexOf("[") + 1, tmp.indexOf("]")).trim();
                        tmp = tmp.replaceAll(",", "");
                        String[] strCoords = tmp.split(" ");
                        double[] coords = new double[strCoords.length];
                        if (strCoords.length == 4) {
                            for (int iT = 0; iT < 4; ++iT) {
                                coords[iT] = Double.parseDouble(strCoords[iT].trim());
                            }
                            value = new GeneralEnvelope(new double[]{coords[0], coords[1]}, new double[]{coords[2], coords[3]});
                        }
                    }
                } else if (params.get(key) != null && params.get(key) instanceof GeneralGridGeometry) {
                    value = params.get(key);
                }
            } else if (key.equalsIgnoreCase("InputTransparentColor") || key.equalsIgnoreCase("OutputTransparentColor")) {
                if (params.get(key) != null) {
                    value = Color.decode((String)params.get(key));
                } else {
                    Class[] clArray = new Class[]{class$java$awt$Color == null ? (class$java$awt$Color = CoverageUtils.class$("java.awt.Color")) : class$java$awt$Color};
                    Object[] inArray = new Object[]{params.get(key)};
                    value = param.getValue().getClass().getConstructor(clArray).newInstance(inArray);
                }
            } else {
                Class[] clArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CoverageUtils.class$("java.lang.String")) : class$java$lang$String};
                Object[] inArray = new Object[]{params.get(key)};
                value = param.getValue().getClass().getConstructor(clArray).newInstance(inArray);
            }
        }
        catch (Exception e) {
            value = param.getValue();
        }
        return value;
    }

    public static MathTransform getMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem destCRS) {
        try {
            CoordinateOperation op = operationFactory.createOperation(sourceCRS, destCRS);
            if (op != null) {
                return op.getMathTransform();
            }
        }
        catch (OperationNotFoundException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (FactoryException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

