/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.servlets;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.DispatcherOutputStream;
import org.geoserver.ows.ServiceStrategy;
import org.geoserver.ows.util.XmlCharsetDetector;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.vfny.geoserver.ExceptionHandler;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.servlets.PartialBufferStrategy2;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;

public abstract class AbstractService
extends HttpServlet
implements ApplicationContextAware {
    protected static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.servlets");
    String service;
    String request;
    WebApplicationContext context;
    GeoServer geoServer;
    Data catalog;
    String serviceStrategy;
    int partialBufferSize;
    Service serviceRef;
    private String kvpString;
    static /* synthetic */ Class class$org$vfny$geoserver$global$Service;
    static /* synthetic */ Class class$org$geoserver$ows$ServiceStrategy;

    public AbstractService(String service, String request, Service serviceRef) {
        this.service = service;
        this.request = request;
        this.serviceRef = serviceRef;
    }

    public String getService() {
        return this.service;
    }

    public String getRequest() {
        return this.request;
    }

    public void setServiceRef(Service serviceRef) {
        this.serviceRef = serviceRef;
    }

    public Service getServiceRef() {
        return this.serviceRef;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = (WebApplicationContext)context;
    }

    public WebApplicationContext getApplicationContext() {
        return this.context;
    }

    public void setGeoServer(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public GeoServer getGeoServer() {
        return this.geoServer;
    }

    public Data getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Data catalog) {
        this.catalog = catalog;
    }

    public String getServiceStrategy() {
        return this.serviceStrategy;
    }

    public void setServiceStrategy(String serviceStrategy) {
        this.serviceStrategy = serviceStrategy;
    }

    protected boolean isServiceEnabled(HttpServletRequest req) {
        return true;
    }

    public ServletContext getServletContext() {
        return this.context.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Request serviceRequest = null;
        if (!this.isServiceEnabled(request)) {
            this.sendDisabledServiceError(response);
            return;
        }
        try {
            Map<String, String> requestParams = new HashMap();
            String qString = this.kvpString != null ? this.kvpString : request.getQueryString();
            LOGGER.fine("reading request: " + qString);
            if (this.kvpString != null) {
                requestParams = KvpRequestReader.parseKvpSet(qString);
            } else {
                Enumeration pnames = request.getParameterNames();
                while (pnames.hasMoreElements()) {
                    String paramName = (String)pnames.nextElement();
                    String paramValue = request.getParameter(paramName);
                    requestParams.put(paramName.toUpperCase(), paramValue);
                }
            }
            KvpRequestReader requestReader = this.getKvpReader(requestParams);
            serviceRequest = requestReader.getRequest(request);
            LOGGER.finer("serviceRequest provided with HttpServletRequest: " + request);
        }
        catch (ServiceException se) {
            this.sendError(request, response, se);
            return;
        }
        catch (Throwable e) {
            this.sendError(request, response, e);
            return;
        }
        finally {
            this.kvpString = null;
        }
        this.doService(request, response, serviceRequest);
    }

    protected void sendDisabledServiceError(HttpServletResponse response) throws IOException {
        response.sendError(503, this.getService() + " service is not enabled. " + "You can enable it in the web admin tool.");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response, null);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response, Reader requestXml) throws ServletException, IOException {
        Request serviceRequest = null;
        if (!this.isServiceEnabled(request)) {
            this.sendDisabledServiceError(response);
            return;
        }
        try {
            XmlRequestReader requestReader = this.getXmlRequestReader();
            Reader xml = null != requestXml ? requestXml : new BufferedReader(XmlCharsetDetector.getCharsetAwareReader((InputStream)request.getInputStream()));
            if (LOGGER.isLoggable(Level.FINE)) {
                if (xml.markSupported()) {
                    int maxChars = 16000;
                    if (LOGGER.isLoggable(Level.FINER)) {
                        maxChars = 64000;
                    }
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        maxChars = 640000;
                    }
                    xml.mark(maxChars + 1);
                    char[] buffer = new char[maxChars];
                    int actualRead = xml.read(buffer);
                    xml.reset();
                    LOGGER.fine("------------XML POST START-----------\n" + new String(buffer, 0, actualRead) + "\n------------XML POST END-----------");
                    if (actualRead == maxChars) {
                        LOGGER.fine("------------XML POST REPORT WAS TRUNCATED AT " + maxChars + " CHARACTERS.  RUN WITH HIGHER LOGGING LEVEL TO SEE MORE");
                    }
                } else {
                    LOGGER.fine("ATTEMPTED TO LOG POST XML, BUT WAS PREVENTED BECAUSE markSupported() IS FALSE");
                }
            }
            serviceRequest = requestReader.read(xml, request);
            serviceRequest.setHttpServletRequest(request);
        }
        catch (ServiceException se) {
            this.sendError(request, response, se);
            return;
        }
        catch (Throwable e) {
            this.sendError(request, response, e);
            return;
        }
        this.doService(request, response, serviceRequest);
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response, Request serviceRequest) throws ServletException {
        LOGGER.info("handling request: " + serviceRequest);
        if (!this.isServiceEnabled(request)) {
            try {
                this.sendDisabledServiceError(response);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error writing service unavailable response", e);
            }
            return;
        }
        ServiceStrategy strategy = null;
        Response serviceResponse = null;
        try {
            strategy = this.createServiceStrategy();
            LOGGER.fine("strategy is: " + strategy.getId());
            serviceResponse = this.getResponseHandler();
        }
        catch (Throwable t) {
            this.sendError(request, response, t);
            return;
        }
        Map services = this.context.getBeansOfType(class$org$vfny$geoserver$global$Service == null ? (class$org$vfny$geoserver$global$Service = AbstractService.class$("org.vfny.geoserver.global.Service")) : class$org$vfny$geoserver$global$Service);
        Service s = null;
        Iterator itr = services.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String id = (String)entry.getKey();
            Service service = (Service)((Object)entry.getValue());
            if (!id.toLowerCase().startsWith(serviceRequest.getService().toLowerCase().trim())) continue;
            s = service;
            break;
        }
        if (s == null) {
            String msg = "No service found matching: " + serviceRequest.getService();
            this.sendError(request, response, new ServiceException(msg));
            return;
        }
        try {
            LOGGER.finer("executing request");
            serviceResponse.execute(serviceRequest);
            LOGGER.finer("execution succeed");
        }
        catch (ServiceException serviceException) {
            LOGGER.warning("service exception while executing request: " + serviceRequest + "\ncause: " + ((Throwable)((Object)serviceException)).getMessage());
            serviceResponse.abort(s);
            this.sendError(request, response, serviceException);
            return;
        }
        catch (Throwable t) {
            serviceResponse.abort(s);
            this.sendError(request, response, t);
            return;
        }
        DispatcherOutputStream strategyOuput = null;
        try {
            String disposition;
            LOGGER.finest("getting strategy output");
            strategyOuput = strategy.getDestination(response);
            LOGGER.finer("strategy output is: " + strategyOuput.getClass().getName());
            String mimeType = serviceResponse.getContentType(s.getGeoServer());
            LOGGER.fine("mime type is: " + mimeType);
            response.setContentType(mimeType);
            String encoding = serviceResponse.getContentEncoding();
            if (encoding != null) {
                LOGGER.fine("content encoding is: " + encoding);
                response.setHeader("Content-Encoding", encoding);
            }
            if ((disposition = serviceResponse.getContentDisposition()) != null) {
                LOGGER.fine("content encoding is: " + encoding);
                response.setHeader("Content-Disposition", disposition);
            }
        }
        catch (SocketException socketException) {
            LOGGER.fine("it seems that the user has closed the request stream: " + socketException.getMessage());
            serviceResponse.abort(s);
            strategy.abort();
            return;
        }
        catch (IOException ex) {
            serviceResponse.abort(s);
            strategy.abort();
            this.sendError(request, response, ex);
            return;
        }
        try {
            serviceResponse.writeTo((OutputStream)strategyOuput);
            strategyOuput.flush();
            strategy.flush(response);
        }
        catch (SocketException sockEx) {
            LOGGER.info("Stream abruptly closed by client, response aborted");
            serviceResponse.abort(s);
            strategy.abort();
            return;
        }
        catch (IOException ioException) {
            response.setHeader("Content-Disposition", "");
            LOGGER.info("Stream abruptly closed by client, response aborted");
            LOGGER.log(Level.FINE, "Error writing out " + ioException.getMessage(), ioException);
            serviceResponse.abort(s);
            strategy.abort();
            return;
        }
        catch (ServiceException writeToFailure) {
            response.setHeader("Content-Disposition", "");
            serviceResponse.abort(s);
            strategy.abort();
            this.sendError(request, response, writeToFailure);
            return;
        }
        catch (Throwable help) {
            response.setHeader("Content-Disposition", "");
            help.printStackTrace();
            serviceResponse.abort(s);
            strategy.abort();
            this.sendError(request, response, help);
            return;
        }
        try {
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
        catch (SocketException sockEx) {
            LOGGER.warning("Could not send completed response to user:" + sockEx);
            return;
        }
        catch (IOException ioException) {
            LOGGER.warning("Could not send completed response to user:" + ioException);
            return;
        }
        LOGGER.info("Service handled");
    }

    protected Response getResponseHandler() {
        return null;
    }

    public final Response getResponse() {
        return this.getResponseHandler();
    }

    protected KvpRequestReader getKvpReader(Map params) {
        return null;
    }

    protected XmlRequestReader getXmlRequestReader() {
        return null;
    }

    protected abstract ExceptionHandler getExceptionHandler();

    protected ServiceStrategy createServiceStrategy() throws ServiceException {
        ServiceStrategy theStrategy = null;
        if (this.geoServer.isVerboseExceptions()) {
            theStrategy = (ServiceStrategy)this.context.getBean("fileServiceStrategy");
        } else {
            if (this.serviceStrategy == null) {
                this.serviceStrategy = this.getServletContext().getInitParameter("serviceStrategy");
            }
            if (this.serviceStrategy != null) {
                Map strategies = this.context.getBeansOfType(class$org$geoserver$ows$ServiceStrategy == null ? (class$org$geoserver$ows$ServiceStrategy = AbstractService.class$("org.geoserver.ows.ServiceStrategy")) : class$org$geoserver$ows$ServiceStrategy);
                Iterator itr = strategies.values().iterator();
                while (itr.hasNext()) {
                    ServiceStrategy bean = (ServiceStrategy)itr.next();
                    if (!bean.getId().equals(this.serviceStrategy)) continue;
                    theStrategy = bean;
                    break;
                }
            }
        }
        if (theStrategy == null) {
            theStrategy = (ServiceStrategy)this.context.getBean("bufferServiceStrategy");
        }
        try {
            theStrategy = (ServiceStrategy)theStrategy.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.log(Level.SEVERE, "Programming error found, service strategies should be cloneable, " + e, e);
            throw new RuntimeException("Found a strategy that does not support cloning...", e);
        }
        if (theStrategy instanceof PartialBufferStrategy2) {
            String size;
            if (this.partialBufferSize == 0 && (size = this.getServletContext().getInitParameter("PARTIAL_BUFFER_STRATEGY_SIZE")) != null) {
                try {
                    this.partialBufferSize = Integer.valueOf(size);
                    if (this.partialBufferSize <= 0) {
                        LOGGER.warning("Invalid partial buffer size, defaulting to 50 (was " + this.partialBufferSize + ")");
                        this.partialBufferSize = 0;
                    }
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warning("Invalid partial buffer size, defaulting to 50 (was " + this.partialBufferSize + ")");
                    this.partialBufferSize = 0;
                }
            }
            ((PartialBufferStrategy2)theStrategy).setBufferSize(this.partialBufferSize);
        }
        return theStrategy;
    }

    protected String getMimeType() {
        ServletContext servContext = this.getServletContext();
        try {
            return ((GeoServer)servContext.getAttribute("GeoServer")).getMimeType();
        }
        catch (NullPointerException e) {
            return "text/xml; charset=" + Charset.forName("UTF-8").name();
        }
    }

    protected void send(HttpServletResponse response, CharSequence content) {
        this.send(response, content, this.getMimeType());
    }

    protected void send(HttpServletResponse response, CharSequence content, String mimeType) {
        try {
            response.setContentType(mimeType);
            response.getWriter().write(((Object)content).toString());
        }
        catch (IOException ex) {
            LOGGER.info("Stream abruptly closed by client, response aborted");
            LOGGER.fine(ex.getMessage());
        }
        catch (IllegalStateException ex) {
            LOGGER.info("Stream abruptly closed by client, response aborted");
            LOGGER.fine(ex.getMessage());
        }
    }

    protected void sendError(HttpServletRequest request, HttpServletResponse response, Throwable t) {
        if (t instanceof ServiceException) {
            this.sendError(request, response, (ServiceException)((Object)t));
            return;
        }
        LOGGER.info("Had an undefined error: " + t.getMessage());
        ExceptionHandler exHandler = this.getExceptionHandler();
        ServiceException se = exHandler.newServiceException(t);
        this.sendError(request, response, se);
    }

    protected void sendError(HttpServletRequest request, HttpServletResponse response, ServiceException se) {
        LOGGER.log(Level.SEVERE, "Service exception occurred", (Throwable)((Object)se));
        String mimeType = se.getMimeType(this.geoServer);
        this.send(response, se.getXmlResponse(this.geoServer.isVerboseExceptions(), request, this.geoServer), mimeType);
    }

    protected void send(HttpServletRequest httpRequest, HttpServletResponse response, Response result) {
        ServletOutputStream responseOut = null;
        try {
            responseOut = response.getOutputStream();
        }
        catch (IOException ex) {
            LOGGER.info("apparently client has closed stream: " + ex.getMessage());
        }
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)responseOut);
        ServletContext servContext = this.getServletContext();
        response.setContentType(result.getContentType((GeoServer)servContext.getAttribute("GeoServer")));
        try {
            result.writeTo(out);
            ((OutputStream)out).flush();
            responseOut.flush();
        }
        catch (IOException ioe) {
            LOGGER.fine("connection closed by user: " + ioe.getMessage());
        }
        catch (ServiceException ex) {
            this.sendError(httpRequest, response, ex);
        }
    }

    protected boolean requestSupportsGzip(HttpServletRequest request) {
        boolean supportsGzip = false;
        String header = request.getHeader("accept-encoding");
        if (header != null && header.indexOf("gzip") > -1) {
            supportsGzip = true;
        }
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config("user-agent=" + request.getHeader("user-agent"));
            LOGGER.config("accept=" + request.getHeader("accept"));
            LOGGER.config("accept-encoding=" + request.getHeader("accept-encoding"));
        }
        return supportsGzip;
    }

    public String getKvpString() {
        return this.kvpString;
    }

    public void setKvpString(String kvpString) {
        this.kvpString = kvpString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

