/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import org.geoserver.ows.OWS;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.dto.ServiceDTO;

public abstract class Service
extends OWS {
    private String strategy;
    private MetaDataLink metadataLink;
    private int partialBufferSize;
    private GeoServer gs;
    private Data dt;

    public Service(ServiceDTO dto) {
        if (dto == null) {
            throw new NullPointerException();
        }
        this.setEnabled(dto.isEnabled());
        this.setName(dto.getName());
        this.setTitle(dto.getTitle());
        this.setAbtract(dto.getAbstract());
        this.setKeywords(dto.getKeywords());
        this.setFees(dto.getFees());
        this.setAccessConstraints(dto.getAccessConstraints());
        this.setMaintainer(dto.getMaintainer());
        this.setOnlineResource(dto.getOnlineResource());
        this.metadataLink = dto.getMetadataLink();
        this.strategy = dto.getStrategy();
        this.partialBufferSize = dto.getPartialBufferSize();
    }

    public void load(ServiceDTO dto) {
        if (dto == null) {
            throw new NullPointerException();
        }
        this.setEnabled(dto.isEnabled());
        this.setName(dto.getName());
        this.setTitle(dto.getTitle());
        this.setAbtract(dto.getAbstract());
        this.setKeywords(dto.getKeywords());
        this.setFees(dto.getFees());
        this.setAccessConstraints(dto.getAccessConstraints());
        this.setMaintainer(dto.getMaintainer());
        this.setOnlineResource(dto.getOnlineResource());
        this.metadataLink = dto.getMetadataLink();
        this.strategy = dto.getStrategy();
        this.partialBufferSize = dto.getPartialBufferSize();
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public int getPartialBufferSize() {
        return this.partialBufferSize;
    }

    public void setPartialBufferSize(int partialBufferSize) {
        this.partialBufferSize = partialBufferSize;
    }

    protected Object toDTO() {
        ServiceDTO dto = new ServiceDTO();
        dto.setAccessConstraints(this.getAccessConstraints());
        dto.setEnabled(this.isEnabled());
        dto.setFees(this.getFees());
        dto.setKeywords(this.getKeywords());
        dto.setMaintainer(this.getMaintainer());
        dto.setName(this.getName());
        dto.setOnlineResource(this.getOnlineResource());
        dto.setAbstract(this.getAbstract());
        dto.setTitle(this.getTitle());
        dto.setMetadataLink(this.metadataLink);
        dto.setStrategy(this.strategy);
        dto.setPartialBufferSize(this.partialBufferSize);
        return dto;
    }

    public Data getData() {
        return this.dt;
    }

    public void setData(Data dt) {
        this.dt = dt;
    }

    public GeoServer getGeoServer() {
        return this.gs;
    }

    public void setGeoServer(GeoServer gs) {
        this.gs = gs;
    }

    public MetaDataLink getMetadataLink() {
        return this.metadataLink;
    }
}

