/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

abstract class GlobalLayerSupertype {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.global");

    GlobalLayerSupertype() {
    }

    abstract Object toDTO();

    protected String notNull(String s) {
        return s == null ? "" : s;
    }

    public static String get(Map map, String key) {
        if (map.containsKey(key)) {
            return (String)map.get(key);
        }
        return null;
    }

    public static File get(Map map, String key, File defaultFile) {
        if (map.containsKey(key)) {
            return (File)map.get(key);
        }
        return defaultFile;
    }

    public static String get(Map map, String key, String defaultValue) {
        if (map.containsKey(key)) {
            return (String)map.get(key);
        }
        return defaultValue;
    }

    public static List get(Map map, String key, List defaultList) {
        if (map.containsKey(key)) {
            return (List)map.get(key);
        }
        return defaultList;
    }

    public static Map get(Map map, String key, Map defaultMap) {
        if (map.containsKey(key)) {
            return (Map)map.get(key);
        }
        return defaultMap;
    }

    public static int get(Map map, String key, int defaultValue) {
        if (map.containsKey(key)) {
            return Integer.parseInt((String)map.get(key));
        }
        return defaultValue;
    }

    public static boolean get(Map map, String key, boolean defaultValue) {
        if (map.containsKey(key)) {
            return Boolean.getBoolean((String)map.get(key));
        }
        return defaultValue;
    }

    public static Charset get(Map map, String key, Charset defaultCharSet) {
        if (map.containsKey(key)) {
            return (Charset)map.get(key);
        }
        return defaultCharSet;
    }

    public static Level get(Map map, String key, Level defaultLevel) {
        if (map.containsKey(key)) {
            return (Level)map.get(key);
        }
        return defaultLevel;
    }

    public static URL get(Map map, String key, URL defaultUrl) {
        if (map.containsKey(key)) {
            return (URL)map.get(key);
        }
        return defaultUrl;
    }

    public static Class get(Map map, String key, Class defaultType) {
        if (!map.containsKey(key)) {
            return defaultType;
        }
        Object value = map.get(key);
        if (value instanceof Class) {
            return (Class)value;
        }
        if (value instanceof String) {
            try {
                return Class.forName((String)value);
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.FINEST, e.getMessage(), e);
            }
        }
        return defaultType;
    }
}

