/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.IOException;
import java.util.Set;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.GeoServerFeatureSource;

public class GeoServerFeatureStore
extends GeoServerFeatureSource
implements FeatureStore {
    GeoServerFeatureStore(FeatureStore store, FeatureType schema, Filter definitionQuery, CoordinateReferenceSystem declaredCRS, int srsHandling) {
        super((FeatureSource)store, schema, definitionQuery, declaredCRS, srsHandling);
    }

    FeatureStore store() {
        return (FeatureStore)this.source;
    }

    public Set addFeatures(FeatureCollection fc) throws IOException {
        FeatureStore store = this.store();
        if (!store.getSchema().equals(fc.getSchema())) {
            fc = new RetypingFeatureCollection(fc, store.getSchema());
        }
        return this.store().addFeatures(fc);
    }

    public void removeFeatures(Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        this.store().removeFeatures(filter);
    }

    public void modifyFeatures(AttributeType[] type, Object[] value, Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        this.store().modifyFeatures(type, value, filter);
    }

    public void modifyFeatures(AttributeType type, Object value, Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        this.store().modifyFeatures(type, value, filter);
    }

    public void setFeatures(FeatureReader reader) throws IOException {
        FeatureStore store = this.store();
        if (!store.getSchema().equals(reader.getFeatureType())) {
            reader = new RetypingFeatureCollection.RetypingFeatureReader(reader, store.getSchema());
        }
        this.store().setFeatures(reader);
    }

    public void setTransaction(Transaction transaction) {
        this.store().setTransaction(transaction);
    }

    public Transaction getTransaction() {
        return this.store().getTransaction();
    }
}

