/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;
import org.geoserver.feature.DefaultCRSFilterVisitor;
import org.geoserver.feature.ReprojectingFilterVisitor;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.crs.ReprojectFeatureResults;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.SchemaException;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoServerFeatureLocking;
import org.vfny.geoserver.global.GeoServerFeatureStore;

public class GeoServerFeatureSource
implements FeatureSource {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.global");
    protected FeatureSource source;
    protected FeatureType schema;
    private Filter definitionQuery = Filter.INCLUDE;
    private CoordinateReferenceSystem declaredCRS;
    private int srsHandling;

    GeoServerFeatureSource(FeatureSource source, FeatureType schema, Filter definitionQuery, CoordinateReferenceSystem declaredCRS, int srsHandling) {
        this.source = source;
        this.schema = schema;
        this.definitionQuery = definitionQuery;
        this.declaredCRS = declaredCRS;
        this.srsHandling = srsHandling;
        if (this.definitionQuery == null) {
            this.definitionQuery = Filter.INCLUDE;
        }
    }

    public static GeoServerFeatureSource create(FeatureSource featureSource, FeatureType schema, Filter definitionQuery, CoordinateReferenceSystem declaredCRS, int srsHandling) {
        if (featureSource instanceof FeatureLocking) {
            return new GeoServerFeatureLocking((FeatureLocking)featureSource, schema, definitionQuery, declaredCRS, srsHandling);
        }
        if (featureSource instanceof FeatureStore) {
            return new GeoServerFeatureStore((FeatureStore)featureSource, schema, definitionQuery, declaredCRS, srsHandling);
        }
        return new GeoServerFeatureSource(featureSource, schema, definitionQuery, declaredCRS, srsHandling);
    }

    protected Query makeDefinitionQuery(Query query, FeatureType schema) throws IOException {
        if (query == Query.ALL || query.equals(Query.ALL)) {
            return query;
        }
        try {
            String[] propNames = this.extractAllowedAttributes(query, schema);
            Filter filter = query.getFilter();
            filter = this.makeDefinitionFilter(filter);
            DefaultQuery defQuery = new DefaultQuery(query);
            defQuery.setFilter(filter);
            defQuery.setPropertyNames(propNames);
            if (query.getSortBy() != null) {
                defQuery.setSortBy(query.getSortBy());
            }
            return defQuery;
        }
        catch (Exception ex) {
            throw new DataSourceException("Could not restrict the query to the definition criteria: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private String[] extractAllowedAttributes(Query query, FeatureType schema) {
        String[] propNames = null;
        if (query.retrieveAllProperties()) {
            propNames = new String[schema.getAttributeCount()];
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                propNames[i] = schema.getAttributeType(i).getName();
            }
        } else {
            String[] queriedAtts = query.getPropertyNames();
            int queriedAttCount = queriedAtts.length;
            LinkedList<String> allowedAtts = new LinkedList<String>();
            for (int i = 0; i < queriedAttCount; ++i) {
                if (schema.getAttributeType(queriedAtts[i]) != null) {
                    allowedAtts.add(queriedAtts[i]);
                    continue;
                }
                LOGGER.info("queried a not allowed property: " + queriedAtts[i] + ". Ommitting it from query");
            }
            propNames = allowedAtts.toArray(new String[allowedAtts.size()]);
        }
        return propNames;
    }

    protected Filter makeDefinitionFilter(Filter filter) throws DataSourceException {
        Filter newFilter = filter;
        try {
            if (this.definitionQuery != Filter.INCLUDE) {
                FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
                newFilter = ff.and(this.definitionQuery, filter);
            }
        }
        catch (Exception ex) {
            throw new DataSourceException("Can't create the definition filter", (Throwable)ex);
        }
        return newFilter;
    }

    public DataStore getDataStore() {
        return this.source.getDataStore();
    }

    public void addFeatureListener(FeatureListener listener) {
        this.source.addFeatureListener(listener);
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.source.removeFeatureListener(listener);
    }

    public FeatureCollection getFeatures(Query query) throws IOException {
        Query reprojected = this.reprojectFilter(query);
        Query newQuery = this.adaptQuery(reprojected, this.schema);
        CoordinateReferenceSystem targetCRS = query.getCoordinateSystemReproject();
        try {
            FeatureCollection fc = this.source.getFeatures(newQuery);
            return this.reprojectFeatureCollection(targetCRS, fc);
        }
        catch (Exception e) {
            throw new DataSourceException((Throwable)e);
        }
    }

    private Query reprojectFilter(Query query) throws IOException {
        FeatureType nativeFeatureType = this.source.getSchema();
        GeometryAttributeType geom = nativeFeatureType.getDefaultGeometry();
        if (geom == null) {
            return query;
        }
        try {
            CoordinateReferenceSystem defaultCRS = null;
            CoordinateReferenceSystem targetCRS = null;
            CoordinateReferenceSystem nativeCRS = geom.getCoordinateSystem();
            if (this.srsHandling == FeatureTypeInfo.FORCE) {
                defaultCRS = this.declaredCRS;
                targetCRS = this.declaredCRS;
                nativeFeatureType = FeatureTypes.transform((FeatureType)nativeFeatureType, (CoordinateReferenceSystem)this.declaredCRS);
            } else if (this.srsHandling == FeatureTypeInfo.REPROJECT) {
                defaultCRS = this.declaredCRS;
                targetCRS = nativeCRS;
            } else {
                defaultCRS = nativeCRS;
                targetCRS = nativeCRS;
            }
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            DefaultCRSFilterVisitor defaultCRSVisitor = new DefaultCRSFilterVisitor(ff, defaultCRS);
            Filter defaultedFilter = (Filter)query.getFilter().accept((FilterVisitor)defaultCRSVisitor, null);
            ReprojectingFilterVisitor reprojectingVisitor = new ReprojectingFilterVisitor(ff, nativeFeatureType);
            Filter reprojectedFilter = (Filter)defaultedFilter.accept((FilterVisitor)reprojectingVisitor, null);
            DefaultQuery reprojectedQuery = new DefaultQuery(query);
            reprojectedQuery.setFilter(reprojectedFilter);
            return reprojectedQuery;
        }
        catch (Exception e) {
            throw new DataSourceException("Had troubles handling filter reprojection...", (Throwable)e);
        }
    }

    protected FeatureCollection reprojectFeatureCollection(CoordinateReferenceSystem targetCRS, FeatureCollection fc) throws IOException, SchemaException, TransformException, OperationNotFoundException, FactoryException {
        if (fc.getSchema().getDefaultGeometry() == null) {
            return fc;
        }
        CoordinateReferenceSystem nativeCRS = fc.getSchema().getDefaultGeometry().getCoordinateSystem();
        if (nativeCRS == null) {
            fc = new ForceCoordinateSystemFeatureResults(fc, this.declaredCRS);
            nativeCRS = this.declaredCRS;
        } else if (this.srsHandling == FeatureTypeInfo.FORCE && !nativeCRS.equals(this.declaredCRS)) {
            fc = new ForceCoordinateSystemFeatureResults(fc, this.declaredCRS);
            nativeCRS = this.declaredCRS;
        } else if (this.srsHandling == FeatureTypeInfo.REPROJECT && targetCRS == null && !nativeCRS.equals(this.declaredCRS)) {
            fc = new ReprojectFeatureResults(fc, this.declaredCRS);
        }
        if (targetCRS != null) {
            if (nativeCRS == null) {
                fc = new ReprojectFeatureResults(fc, targetCRS);
            } else if (!CRS.equalsIgnoreMetadata((Object)nativeCRS, (Object)targetCRS)) {
                fc = new ReprojectFeatureResults(fc, targetCRS);
            }
        }
        return fc;
    }

    protected Query adaptQuery(Query query, FeatureType schema) throws IOException {
        boolean requireXferCRS;
        Query newQuery = this.makeDefinitionQuery(query, schema);
        boolean bl = requireXferCRS = newQuery.getCoordinateSystem() == null && query.getCoordinateSystem() != null;
        if (newQuery.getCoordinateSystem() != null && query.getCoordinateSystem() != null) {
            boolean bl2 = requireXferCRS = !newQuery.getCoordinateSystem().equals(query.getCoordinateSystem());
        }
        if (requireXferCRS) {
            if (!(newQuery instanceof DefaultQuery)) {
                newQuery = new DefaultQuery(newQuery);
            }
            ((DefaultQuery)newQuery).setCoordinateSystem(query.getCoordinateSystem());
        }
        if (newQuery.getCoordinateSystemReproject() != null) {
            ((DefaultQuery)newQuery).setCoordinateSystemReproject(null);
        }
        return newQuery;
    }

    public FeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures((Query)new DefaultQuery(this.schema.getTypeName(), filter));
    }

    public FeatureCollection getFeatures() throws IOException {
        return this.getFeatures(Query.ALL);
    }

    public FeatureType getSchema() {
        return this.schema;
    }

    public Envelope getBounds() throws IOException {
        if (this.definitionQuery == Filter.INCLUDE) {
            return this.source.getBounds();
        }
        DefaultQuery query = new DefaultQuery(this.getSchema().getTypeName(), this.definitionQuery);
        return this.source.getBounds((Query)query);
    }

    public Envelope getBounds(Query query) throws IOException {
        try {
            query = this.makeDefinitionQuery(query, this.schema);
        }
        catch (IOException ex) {
            return null;
        }
        return this.source.getBounds(query);
    }

    public int getCount(Query query) {
        try {
            query = this.makeDefinitionQuery(query, this.schema);
        }
        catch (IOException ex) {
            return -1;
        }
        try {
            return this.source.getCount(query);
        }
        catch (IOException e) {
            return 0;
        }
    }

    public Set getSupportedHints() {
        return this.source.getSupportedHints();
    }
}

