/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import com.sun.media.jai.util.SunTileCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.RecyclingTileFactory;
import javax.servlet.ServletContext;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.springframework.beans.factory.DisposableBean;
import org.vfny.geoserver.global.Config;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.DataStoreInfo;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.dto.ContactDTO;
import org.vfny.geoserver.global.dto.GeoServerDTO;

public class GeoServer
extends GlobalLayerSupertype
implements DisposableBean {
    public static final String WEB_CONTAINER_KEY = "GeoServer";
    private String title;
    private int maxFeatures = Integer.MAX_VALUE;
    private boolean verbose = true;
    private int numDecimals = 4;
    private Charset charSet = Charset.forName("UTF-8");
    private final JAI jaiDef = JAI.getDefaultInstance();
    private SunTileCache jaiCache;
    private String adminUserName = "admin";
    private String adminPassword;
    private String schemaBaseUrl;
    private String proxyBaseUrl;
    private String contactPerson;
    private String contactOrganization;
    private String contactPosition;
    private String addressType;
    private String address;
    private String addressCity;
    private String addressState;
    private String addressPostalCode;
    private String addressCountry;
    private String contactVoice;
    private String contactFacsimile;
    private String contactEmail;
    private String onlineResource;
    private double memoryCapacity;
    private double memoryThreshold;
    private int tileThreads;
    private int tilePriority;
    private String tileCache;
    private Boolean recycling;
    private Boolean imageIOCache;
    private Boolean JPEGnativeAcc;
    private Boolean PNGnativeAcc;
    private boolean verboseExceptions = false;
    private String log4jConfigFile;
    private boolean suppressStdOutLogging = false;
    private String logLocation = null;
    private List listeners;
    private Config config;
    private int updateSequence;
    private static boolean suppressLoggingConfiguration;

    public GeoServer() {
    }

    public GeoServer(Config config) throws ConfigurationException {
        GlobalLayerSupertype.LOGGER.fine("Creating GeoServer");
        this.load(config.getGeoServer());
        this.config = config;
        this.listeners = new ArrayList();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void fireChange() {
        Iterator l = this.listeners.iterator();
        while (l.hasNext()) {
            Listener listener = (Listener)l.next();
            try {
                listener.changed();
            }
            catch (Throwable t) {
                GlobalLayerSupertype.LOGGER.warning("listener threw exception, turn logging to FINE to view stack trace");
                GlobalLayerSupertype.LOGGER.log(Level.FINE, t.getLocalizedMessage(), t);
            }
        }
    }

    public String getAddress() {
        return this.notNull(this.address);
    }

    public String getAddressCity() {
        return this.notNull(this.addressCity);
    }

    public String getAddressCountry() {
        return this.notNull(this.addressCountry);
    }

    public String getAddressPostalCode() {
        return this.notNull(this.addressPostalCode);
    }

    public String getAddressState() {
        return this.notNull(this.addressState);
    }

    public String getAddressType() {
        return this.notNull(this.addressType);
    }

    public Charset getCharSet() {
        if (this.charSet != null) {
            return this.charSet;
        }
        return Charset.forName("UTF-8");
    }

    public String getContactEmail() {
        return this.notNull(this.contactEmail);
    }

    public String getContactFacsimile() {
        return this.notNull(this.contactFacsimile);
    }

    public String getContactOrganization() {
        return this.notNull(this.contactOrganization);
    }

    public String getContactPerson() {
        return this.notNull(this.contactPerson);
    }

    public String getContactPosition() {
        return this.notNull(this.contactPosition);
    }

    public String getContactVoice() {
        return this.notNull(this.contactVoice);
    }

    public String getOnlineResource() {
        return this.notNull(this.onlineResource);
    }

    public String getLog4jConfigFile() {
        return this.log4jConfigFile;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public String getMimeType() {
        return "text/xml; charset=" + this.getCharSet().name();
    }

    public int getNumDecimals() {
        return this.numDecimals;
    }

    public String getSchemaBaseUrl() {
        return this.schemaBaseUrl;
    }

    public String getProxyBaseUrl() {
        return this.proxyBaseUrl;
    }

    public int getUpdateSequence() {
        return this.updateSequence;
    }

    public void setUpdateSequence(int updateSequence) {
        this.updateSequence = updateSequence;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(GeoServerDTO dto) throws ConfigurationException {
        if (dto == null) throw new ConfigurationException("load(GeoServerDTO) expected a non-null value");
        this.address = dto.getContact().getAddress();
        this.addressCity = dto.getContact().getAddressCity();
        this.addressCountry = dto.getContact().getAddressCountry();
        this.addressPostalCode = dto.getContact().getAddressPostalCode();
        this.addressState = dto.getContact().getAddressState();
        this.addressType = dto.getContact().getAddressType();
        this.charSet = dto.getCharSet();
        this.contactEmail = dto.getContact().getContactEmail();
        this.contactFacsimile = dto.getContact().getContactFacsimile();
        this.contactOrganization = dto.getContact().getContactOrganization();
        this.contactPerson = dto.getContact().getContactPerson();
        this.contactPosition = dto.getContact().getContactPosition();
        this.contactVoice = dto.getContact().getContactVoice();
        this.log4jConfigFile = dto.getLog4jConfigFile();
        this.suppressStdOutLogging = dto.getSuppressStdOutLogging();
        this.logLocation = dto.getLogLocation();
        try {
            if (!suppressLoggingConfiguration) {
                GeoServer.configureGeoServerLogging(this.log4jConfigFile, this.suppressStdOutLogging, this.logLocation);
            }
        }
        catch (IOException ioe) {
            if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.FINE)) throw new ConfigurationException("", ioe);
            GlobalLayerSupertype.LOGGER.log(Level.FINE, "", ioe);
            throw new ConfigurationException("", ioe);
        }
        this.memoryCapacity = dto.getJaiMemoryCapacity();
        this.memoryThreshold = dto.getJaiMemoryThreshold();
        this.tileThreads = dto.getJaiTileThreads();
        this.tilePriority = dto.getJaiTilePriority();
        this.tileCache = dto.getTileCache();
        this.recycling = dto.getJaiRecycling();
        this.imageIOCache = dto.getImageIOCache();
        this.JPEGnativeAcc = dto.getJaiJPEGNative();
        this.PNGnativeAcc = dto.getJaiPNGNative();
        this.initJAI(this.memoryCapacity, this.memoryThreshold, this.recycling, this.imageIOCache);
        this.maxFeatures = dto.getMaxFeatures();
        this.numDecimals = dto.getNumDecimals();
        this.onlineResource = dto.getContact().getOnlineResource();
        this.schemaBaseUrl = dto.getSchemaBaseUrl();
        this.proxyBaseUrl = dto.getProxyBaseUrl();
        this.verbose = dto.isVerbose();
        this.adminUserName = dto.getAdminUserName();
        this.adminPassword = dto.getAdminPassword();
        this.verboseExceptions = dto.isVerboseExceptions();
        this.updateSequence = dto.getUpdateSequence();
    }

    public final void load(GeoServerDTO dto, ServletContext context) throws ConfigurationException {
        this.load(dto);
    }

    public static File getLogLocation(String logLocation) throws IOException {
        File f = new File(logLocation);
        if (f.exists()) {
            if (f.isDirectory()) {
                if (!logLocation.endsWith(File.separator)) {
                    logLocation = logLocation + File.separator;
                }
                logLocation = logLocation + "geoserver.log";
            }
        } else {
            if (!f.isAbsolute()) {
                File data = GeoserverDataDirectory.getGeoserverDataDirectory();
                f = new File(data, f.getPath());
            }
            if (f.getParentFile() != null && !f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            f.createNewFile();
        }
        return f;
    }

    public static void configureGeoServerLogging(String log4jConfigFileStr, boolean suppressStdOutLogging, String logFileName) throws IOException, ConfigurationException {
        File log4jConfigFile;
        GlobalLayerSupertype.LOGGER.fine("CONFIGURING GEOSERVER LOGGING -------------------------");
        if (log4jConfigFileStr == null) {
            log4jConfigFileStr = "DEFAULT_LOGGING.properties";
            GlobalLayerSupertype.LOGGER.warning("No log4jConfigFile defined in services.xml:  using 'DEFAULT_LOGGING.properties'");
        }
        if ((log4jConfigFile = GeoserverDataDirectory.findConfigFile("logs" + File.separator + log4jConfigFileStr)) == null) {
            GlobalLayerSupertype.LOGGER.warning("log4jConfigFile '" + log4jConfigFileStr + "' couldn't be found in the data dir, so GeoServer will " + "install the various logging config file into the data dir, and then try to find it again.");
            File lcdir = GeoserverDataDirectory.findCreateConfigDir("logs");
            String[] lcfiles = new String[]{"DEFAULT_LOGGING.properties", "VERBOSE_LOGGING.properties", "PRODUCTION_LOGGING.properties", "GEOTOOLS_DEVELOPER_LOGGING.properties", "GEOSERVER_DEVELOPER_LOGGING.properties"};
            for (int i = 0; i < lcfiles.length; ++i) {
                File target = new File(lcdir.getAbsolutePath(), lcfiles[i]);
                if (target.exists()) continue;
                GeoServer.copyResourceToFile(lcfiles[i], target);
            }
            log4jConfigFile = GeoserverDataDirectory.findConfigFile("logs" + File.separator + log4jConfigFileStr);
            if (log4jConfigFile == null) {
                GlobalLayerSupertype.LOGGER.warning("Still couldn't find log4jConfigFile '" + log4jConfigFileStr + "'.  Using DEFAULT_LOGGING.properties instead.");
            }
            log4jConfigFile = GeoserverDataDirectory.findConfigFile("logs" + File.separator + "DEFAULT_LOGGING.properties");
        }
        if (log4jConfigFile == null || !log4jConfigFile.exists()) {
            throw new ConfigurationException("Unable to load logging configuration '" + log4jConfigFileStr + "'.  In addition, an attempt " + "was made to create the 'logs' directory in your data dir, and to use the DEFAULT_LOGGING configuration, but" + "this failed as well.  Is your data dir writeable?");
        }
        FileInputStream loggingConfigStream = new FileInputStream(log4jConfigFile);
        if (loggingConfigStream == null) {
            GlobalLayerSupertype.LOGGER.warning("Couldn't open Log4J configuration file '" + log4jConfigFile.getAbsolutePath());
            return;
        }
        GlobalLayerSupertype.LOGGER.fine("GeoServer logging profile '" + log4jConfigFile.getName() + "' enabled.");
        GeoServer.configureGeoServerLogging(loggingConfigStream, suppressStdOutLogging, false, logFileName);
    }

    public static void configureGeoServerLogging(InputStream loggingConfigStream, boolean suppressStdOutLogging, boolean suppressFileLogging, String logFileName) throws FileNotFoundException, IOException, ConfigurationException {
        Properties lprops = new Properties();
        lprops.load(loggingConfigStream);
        LogManager.resetConfiguration();
        PropertyConfigurator.configure((Properties)lprops);
        if (!suppressFileLogging) {
            Appender gslf = Logger.getRootLogger().getAppender("geoserverlogfile");
            if (gslf instanceof RollingFileAppender) {
                if (logFileName == null) {
                    logFileName = new File(GeoserverDataDirectory.findCreateConfigDir("logs"), "geoserver.log").getAbsolutePath();
                } else if (!new File(logFileName).isAbsolute()) {
                    logFileName = new File(GeoserverDataDirectory.getGeoserverDataDirectory(), logFileName).getAbsolutePath();
                    GlobalLayerSupertype.LOGGER.fine("Non-absolute pathname detected for logfile.  Setting logfile relative to data dir.");
                }
                lprops.setProperty("log4j.appender.geoserverlogfile.File", logFileName);
                PropertyConfigurator.configure((Properties)lprops);
                GlobalLayerSupertype.LOGGER.fine("Logging output to file '" + logFileName + "'");
            } else if (gslf != null) {
                GlobalLayerSupertype.LOGGER.warning("'log4j.appender.geoserverlogfile' appender is defined, but isn't a RollingFileAppender.  GeoServer won't control the file-based logging.");
            } else {
                GlobalLayerSupertype.LOGGER.warning("'log4j.appender.geoserverlogfile' appender isn't defined.  GeoServer won't control the file-based logging.");
            }
        }
        if (suppressStdOutLogging) {
            GlobalLayerSupertype.LOGGER.warning("Suppressing StdOut logging.  If you want to see GeoServer logs, be sure to look in '" + logFileName + "'");
            Enumeration allAppenders = Logger.getRootLogger().getAllAppenders();
            while (allAppenders.hasMoreElements()) {
                Appender curApp = (Appender)allAppenders.nextElement();
                if (!(curApp instanceof ConsoleAppender)) continue;
                Logger.getRootLogger().removeAppender(curApp);
            }
        }
        GlobalLayerSupertype.LOGGER.fine("FINISHED CONFIGURING GEOSERVER LOGGING -------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void copyResourceToFile(String resource, File target) throws ConfigurationException {
        block16: {
            int read;
            InputStream is = null;
            FileOutputStream os = null;
            byte[] buffer = new byte[4096];
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            os = new FileOutputStream(target);
            while ((read = is.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, read);
            }
            Object var8_6 = null;
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    ((OutputStream)os).close();
                }
                break block16;
            }
            catch (IOException e2) {}
            break block16;
            {
                catch (FileNotFoundException targetException) {
                    throw new ConfigurationException("Can't write to file " + target.getAbsolutePath() + ". Check write permissions on target folder for user " + System.getProperty("user.name"));
                }
                catch (IOException e) {
                    GlobalLayerSupertype.LOGGER.log(Level.WARNING, "Error trying to copy logging configuration file", e);
                    Object var8_7 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                        break block16;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (os != null) {
                        ((OutputStream)os).close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void initJAI(double memCapacity, double memoryThreshold, Boolean recycling, Boolean ImageIOCache) {
        this.jaiDef.setRenderingHint(JAI.KEY_CACHED_TILE_RECYCLING_ENABLED, (Object)recycling);
        RecyclingTileFactory recyclingFactory = new RecyclingTileFactory();
        this.jaiDef.setRenderingHint(JAI.KEY_TILE_FACTORY, (Object)recyclingFactory);
        this.jaiDef.setRenderingHint(JAI.KEY_TILE_RECYCLER, (Object)recyclingFactory);
        this.jaiCache = (SunTileCache)this.jaiDef.getTileCache();
        long jaiMemory = (long)(memCapacity * (double)Runtime.getRuntime().maxMemory());
        this.jaiCache.setMemoryCapacity(jaiMemory);
        this.jaiCache.setMemoryThreshold((float)memoryThreshold);
        this.jaiDef.getTileScheduler().setParallelism(this.tileThreads);
        this.jaiDef.getTileScheduler().setPrefetchParallelism(this.tileThreads);
        this.jaiDef.getTileScheduler().setPriority(this.tilePriority);
        this.jaiDef.getTileScheduler().setPrefetchPriority(this.tilePriority);
        ImageIO.setUseCache(ImageIOCache);
    }

    public Object toDTO() {
        GeoServerDTO dto = new GeoServerDTO();
        dto.setCharSet(this.charSet);
        dto.setLog4jConfigFile(this.log4jConfigFile);
        dto.setMaxFeatures(this.maxFeatures);
        dto.setNumDecimals(this.numDecimals);
        dto.setSchemaBaseUrl(this.schemaBaseUrl);
        dto.setProxyBaseUrl(this.proxyBaseUrl);
        dto.setVerbose(this.verbose);
        dto.setAdminUserName(this.adminUserName);
        dto.setAdminPassword(this.adminPassword);
        dto.setVerboseExceptions(this.verboseExceptions);
        dto.setSuppressStdOutLogging(this.suppressStdOutLogging);
        dto.setLogLocation(this.logLocation);
        dto.setJaiMemoryCapacity(this.memoryCapacity);
        dto.setJaiMemoryThreshold(this.memoryThreshold);
        dto.setJaiTileThreads(this.tileThreads);
        dto.setJaiTilePriority(this.tilePriority);
        dto.setTileCache(this.tileCache);
        dto.setJaiRecycling(this.recycling);
        dto.setImageIOCache(this.imageIOCache);
        dto.setJaiJPEGNative(this.JPEGnativeAcc);
        dto.setJaiPNGNative(this.PNGnativeAcc);
        dto.setUpdateSequence(this.updateSequence);
        ContactDTO cdto = new ContactDTO();
        dto.setContact(cdto);
        cdto.setAddress(this.address);
        cdto.setAddressCity(this.addressCity);
        cdto.setAddressCountry(this.addressCountry);
        cdto.setAddressPostalCode(this.addressPostalCode);
        cdto.setAddressState(this.addressState);
        cdto.setAddressType(this.addressType);
        cdto.setContactEmail(this.contactEmail);
        cdto.setContactFacsimile(this.contactFacsimile);
        cdto.setContactOrganization(this.contactOrganization);
        cdto.setContactPerson(this.contactPerson);
        cdto.setContactPosition(this.contactPosition);
        cdto.setContactVoice(this.contactVoice);
        cdto.setOnlineResource(this.onlineResource);
        return dto;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContactParty() {
        if (this.getContactPerson() != null && this.getContactPerson().length() != 0) {
            return this.getContactPerson();
        }
        if (this.getContactPosition() != null && this.getContactPosition().length() != 0) {
            return this.getContactPosition();
        }
        if (this.getContactOrganization() != null && this.getContactOrganization().length() != 0) {
            return this.getContactOrganization();
        }
        return null;
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public String toString() {
        StringBuffer geoserver = new StringBuffer("[GeoServer: \n");
        geoserver.append("   maxFeatures - " + this.maxFeatures);
        geoserver.append("\n   verbose - " + this.verbose);
        geoserver.append("\n   numDecimals - " + this.numDecimals);
        geoserver.append("\n   charSet - " + this.charSet);
        geoserver.append("\n   log4jConfigFile - " + this.log4jConfigFile);
        geoserver.append("\n   adminUserName - " + this.adminUserName);
        geoserver.append("\n   adminPassword - " + this.adminPassword);
        return geoserver.toString();
    }

    public boolean isVerboseExceptions() {
        return this.verboseExceptions;
    }

    public void setVerboseExceptions(boolean showStackTraces) {
        this.verboseExceptions = showStackTraces;
    }

    public String getLogLocation() {
        return this.logLocation;
    }

    public void setLogLocation(String logLocation) {
        this.logLocation = logLocation;
    }

    public boolean getSuppressStdOutLogging() {
        return this.suppressStdOutLogging;
    }

    public void setSuppressStdOutLogging(boolean loggingToFile) {
        this.suppressStdOutLogging = loggingToFile;
    }

    public JAI getJAIDefault() {
        return this.jaiDef;
    }

    public SunTileCache getJaiCache() {
        return this.jaiCache;
    }

    public double getMemoryCapacity() {
        return this.memoryCapacity;
    }

    public Boolean getRecycling() {
        return this.recycling;
    }

    public Boolean getJPEGNativeAcceleration() {
        return this.JPEGnativeAcc;
    }

    public Boolean getPNGNativeAcceleration() {
        return this.PNGnativeAcc;
    }

    public double getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public Boolean getImageIOCache() {
        return this.imageIOCache;
    }

    public int getTilePriority() {
        return this.tilePriority;
    }

    public int getTileThreads() {
        return this.tileThreads;
    }

    public String getTileCache() {
        return this.tileCache;
    }

    public void setTileCache(String tileCache) {
        this.tileCache = tileCache;
    }

    public void destroy() throws Exception {
        Data catalog = (Data)this.config.getApplictionContext().getBean("data");
        Set dataStores = catalog.getDataStores();
        GlobalLayerSupertype.LOGGER.info("Disposing DataStores at GeoServer shutdown...");
        Iterator it = dataStores.iterator();
        while (it.hasNext()) {
            DataStoreInfo dataStoreInfo = (DataStoreInfo)it.next();
            GlobalLayerSupertype.LOGGER.fine("Disposing " + dataStoreInfo.getId());
            try {
                dataStoreInfo.dispose();
            }
            catch (RuntimeException e) {
                GlobalLayerSupertype.LOGGER.log(Level.WARNING, "Caught exception while disposing datastore " + dataStoreInfo.getId(), e);
            }
        }
        GlobalLayerSupertype.LOGGER.info("Done disposing datastores.");
        try {
            Class<?> sdepfClass = Class.forName("org.geotools.arcsde.pool.ArcSDEConnectionPoolFactory");
            GlobalLayerSupertype.LOGGER.fine("SDE datasource found, releasing resources");
            Method m = sdepfClass.getMethod("getInstance", new Class[0]);
            Object pfInstance = m.invoke(sdepfClass, new Object[0]);
            GlobalLayerSupertype.LOGGER.fine("got sde connection pool factory instance: " + pfInstance);
            Method closeMethod = pfInstance.getClass().getMethod("clear", new Class[0]);
            closeMethod.invoke(pfInstance, new Object[0]);
            GlobalLayerSupertype.LOGGER.info("Asking ArcSDE datasource to release connections.");
        }
        catch (ClassNotFoundException cnfe) {
            GlobalLayerSupertype.LOGGER.fine("No ArcSDE datasource found.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void suppressLoggingConfiguration() {
        suppressLoggingConfiguration = true;
    }

    public static interface Listener {
        public void changed();
    }
}

