/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.LockingManager;
import org.geotools.data.Transaction;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.vfny.geoserver.global.Config;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.CoverageStoreInfo;
import org.vfny.geoserver.global.DataStoreInfo;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;
import org.vfny.geoserver.global.dto.CoverageInfoDTO;
import org.vfny.geoserver.global.dto.CoverageStoreInfoDTO;
import org.vfny.geoserver.global.dto.DataDTO;
import org.vfny.geoserver.global.dto.DataStoreInfoDTO;
import org.vfny.geoserver.global.dto.DataTransferObjectFactory;
import org.vfny.geoserver.global.dto.FeatureTypeInfoDTO;
import org.vfny.geoserver.global.dto.NameSpaceInfoDTO;
import org.vfny.geoserver.global.dto.StyleDTO;

public class Data
extends GlobalLayerSupertype {
    public static final String WEB_CONTAINER_KEY = "DATA";
    public static final Integer TYPE_VECTOR = new Integer(0);
    public static final Integer TYPE_RASTER = new Integer(1);
    private static final String INFO_FILE = "info.xml";
    private static StyleFactory styleFactory = StyleFactoryFinder.createStyleFactory();
    private volatile Map layerNames = new HashMap();
    private Map nameSpaces;
    private NameSpaceInfo defaultNameSpace;
    private Map dataStores;
    private Map formats;
    private Map styles;
    private Map stFiles;
    private Map featureTypes;
    private Map coverages;
    private File baseDir;
    private GeoServer gs;
    private Map errors;

    public Data(DataDTO config, File dir, GeoServer g) throws ConfigurationException {
        this.baseDir = dir;
        this.load(config);
        this.gs = g;
    }

    public Data(File dir, GeoServer g) throws ConfigurationException {
        this.baseDir = dir;
        this.gs = g;
    }

    public Data(Config config, GeoServer g) throws ConfigurationException {
        this(config.getData(), config.dataDirectory(), g);
    }

    public GeoServer getGeoServer() {
        return this.gs;
    }

    public void setDataDirectory(File dataDirectory) {
        this.baseDir = dataDirectory;
    }

    public File getDataDirectory() {
        return this.baseDir;
    }

    public synchronized void load(DataDTO config) {
        if (config == null) {
            throw new NullPointerException("Non null DataDTO required for load");
        }
        if (this.dataStores != null) {
            Iterator it = this.dataStores.values().iterator();
            while (it.hasNext()) {
                DataStoreInfo ds = (DataStoreInfo)it.next();
                ds.dispose();
            }
        }
        this.formats = this.loadFormats(config);
        this.dataStores = this.loadDataStores(config);
        this.nameSpaces = this.loadNamespaces(config);
        this.defaultNameSpace = (NameSpaceInfo)this.nameSpaces.get(config.getDefaultNameSpacePrefix());
        this.styles = this.loadStyles(config);
        this.layerNames.clear();
        this.featureTypes = this.loadFeatureTypes(config);
        this.coverages = this.loadCoverages(config);
    }

    public synchronized Set getDataStores() {
        return new HashSet(this.dataStores.values());
    }

    public synchronized Set getFormats() {
        return new HashSet(this.formats.values());
    }

    private final Map loadFormats(DataDTO dto) {
        if (dto == null || dto.getFormats() == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, CoverageStoreInfo> map = new HashMap<String, CoverageStoreInfo>();
        Iterator i = dto.getFormats().values().iterator();
        while (i.hasNext()) {
            CoverageStoreInfoDTO formatDTO = (CoverageStoreInfoDTO)i.next();
            String id = formatDTO.getId();
            CoverageStoreInfo formatInfo = new CoverageStoreInfo(formatDTO, this);
            map.put(id, formatInfo);
            if (formatDTO.isEnabled()) {
                if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.FINE)) continue;
                GlobalLayerSupertype.LOGGER.fine("Register Format '" + id + "'");
                continue;
            }
            if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.FINE)) continue;
            GlobalLayerSupertype.LOGGER.fine("Did not Register Format '" + id + "' as it was not enabled");
        }
        return map;
    }

    private final Map loadDataStores(DataDTO dto) {
        if (dto == null || dto.getDataStores() == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, DataStoreInfo> map = new HashMap<String, DataStoreInfo>(dto.getDataStores().size());
        Iterator i = dto.getDataStores().values().iterator();
        while (i.hasNext()) {
            DataStoreInfoDTO dataStoreDTO = (DataStoreInfoDTO)i.next();
            String id = dataStoreDTO.getId();
            DataStoreInfo dataStoreInfo = new DataStoreInfo(dataStoreDTO, this);
            map.put(id, dataStoreInfo);
            if (dataStoreDTO.isEnabled()) {
                if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.FINE)) continue;
                GlobalLayerSupertype.LOGGER.fine("Register DataStore '" + id + "'");
                continue;
            }
            if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.FINE)) continue;
            GlobalLayerSupertype.LOGGER.fine("Did not Register DataStore '" + id + "' as it was not enabled");
        }
        return map;
    }

    private final Map loadNamespaces(DataDTO dto) {
        if (dto == null || dto.getNameSpaces() == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, NameSpaceInfo> map = new HashMap<String, NameSpaceInfo>(dto.getNameSpaces().size());
        Iterator i = dto.getNameSpaces().values().iterator();
        while (i.hasNext()) {
            NameSpaceInfoDTO namespaceDto = (NameSpaceInfoDTO)i.next();
            String prefix = namespaceDto.getPrefix();
            NameSpaceInfo namespaceInfo = new NameSpaceInfo(this, namespaceDto);
            map.put(prefix, namespaceInfo);
        }
        return map;
    }

    private final Map loadCoverages(DataDTO dto) {
        if (dto == null || dto.getCoverages() == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, CoverageInfo> map = new HashMap<String, CoverageInfo>(dto.getCoverages().size());
        Iterator i = dto.getCoverages().values().iterator();
        while (i.hasNext()) {
            CoverageInfo coverageInfo;
            CoverageInfoDTO coverageDTO = (CoverageInfoDTO)i.next();
            String id = coverageDTO.getName();
            try {
                coverageInfo = new CoverageInfo(coverageDTO, this);
            }
            catch (ConfigurationException e) {
                coverageInfo = null;
            }
            map.put(id, coverageInfo);
            this.layerNames.put(id, TYPE_RASTER);
            if (dto.getFormats() != null && dto.getFormats().get(coverageDTO.getFormatId()) != null) {
                if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.FINE)) continue;
                GlobalLayerSupertype.LOGGER.fine("Register Coverage '" + id + "'");
                continue;
            }
            if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.FINE)) continue;
            GlobalLayerSupertype.LOGGER.fine("Did not Register Coverage '" + id + "' as didn't exist a valid Format");
        }
        return map;
    }

    private final Map loadFeatureTypes(DataDTO dto) {
        this.errors = new HashMap();
        this.featureTypes = new HashMap();
        if (dto == null || dto.getFeaturesTypes() == null) {
            this.errors = null;
            return Collections.EMPTY_MAP;
        }
        HashMap<String, FeatureTypeInfo> map = new HashMap<String, FeatureTypeInfo>(dto.getFeaturesTypes().size());
        FeatureTypeInfoDTO[] ftypes = dto.getFeaturesTypes().values().toArray(new FeatureTypeInfoDTO[dto.getFeaturesTypes().size()]);
        Arrays.sort(ftypes, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                FeatureTypeInfoDTO a0 = (FeatureTypeInfoDTO)arg0;
                FeatureTypeInfoDTO a1 = (FeatureTypeInfoDTO)arg1;
                return a0.getKey().compareToIgnoreCase(a1.getKey());
            }
        });
        int curLayerNum = 0;
        int totalLayers = ftypes.length;
        Iterator<FeatureTypeInfoDTO> i = Arrays.asList(ftypes).iterator();
        while (i.hasNext()) {
            String typeName;
            DataStoreInfo dataStoreInfo;
            String key;
            FeatureTypeInfoDTO featureTypeDTO;
            block45: {
                Style s;
                ++curLayerNum;
                featureTypeDTO = i.next();
                if (featureTypeDTO == null) {
                    if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.WARNING)) continue;
                    GlobalLayerSupertype.LOGGER.warning("Ignore null FeatureTypeInfo DTO!");
                    continue;
                }
                key = featureTypeDTO.getKey();
                GlobalLayerSupertype.LOGGER.info("Loading feature type '" + key + "' (layer " + curLayerNum + "/" + totalLayers + ")");
                if (GlobalLayerSupertype.LOGGER.isLoggable(Level.FINER)) {
                    GlobalLayerSupertype.LOGGER.finer("FeatureType " + key + ": loading feature type info dto:" + featureTypeDTO);
                }
                String dataStoreId = featureTypeDTO.getDataStoreId();
                if (GlobalLayerSupertype.LOGGER.isLoggable(Level.FINEST)) {
                    GlobalLayerSupertype.LOGGER.finest("FeatureType " + key + " looking up :" + dataStoreId);
                }
                if ((dataStoreInfo = (DataStoreInfo)this.dataStores.get(dataStoreId)) == null) {
                    DataStoreInfoDTO tmp;
                    if (GlobalLayerSupertype.LOGGER.isLoggable(Level.SEVERE)) {
                        GlobalLayerSupertype.LOGGER.severe("FeatureTypeInfo " + key + " could not be used - DataStore " + dataStoreId + " is not defined!");
                    }
                    if ((tmp = (DataStoreInfoDTO)dto.getDataStores().get(dataStoreId)) != null && !tmp.isEnabled()) {
                        this.errors.put(featureTypeDTO, Boolean.FALSE);
                        continue;
                    }
                    this.errors.put(featureTypeDTO, new ConfigurationException("FeatureTypeInfo " + key + " could not be used - DataStore " + dataStoreId + " is not defined!"));
                    continue;
                }
                if (GlobalLayerSupertype.LOGGER.isLoggable(Level.FINEST)) {
                    GlobalLayerSupertype.LOGGER.finest(key + " datastore found :" + dataStoreInfo);
                }
                if ((s = this.getStyle(featureTypeDTO.getDefaultStyle())) == null) {
                    if (GlobalLayerSupertype.LOGGER.isLoggable(Level.SEVERE)) {
                        GlobalLayerSupertype.LOGGER.severe("FeatureTypeInfo " + key + " ignored - Style '" + featureTypeDTO.getDefaultStyle() + "' not found!");
                    }
                    this.errors.put(featureTypeDTO, new ConfigurationException("FeatureTypeInfo " + key + " ignored - Style '" + featureTypeDTO.getDefaultStyle() + "' not found!"));
                    continue;
                }
                typeName = featureTypeDTO.getName();
                try {
                    boolean createAttrDTO;
                    DataStore dataStore = dataStoreInfo.getDataStore();
                    FeatureType featureType = dataStore.getSchema(typeName);
                    HashSet<String> attributeNames = new HashSet<String>();
                    HashSet<String> ATTRIBUTENames = new HashSet<String>();
                    if (GlobalLayerSupertype.LOGGER.isLoggable(Level.FINE)) {
                        GlobalLayerSupertype.LOGGER.fine("locading datastore " + typeName);
                    }
                    if (featureTypeDTO.getSchemaAttributes() == null) {
                        createAttrDTO = true;
                    } else {
                        boolean bl = createAttrDTO = featureTypeDTO.getSchemaAttributes().size() == 0;
                    }
                    if (createAttrDTO) {
                        List attributeDTOs = this.createAttrDTOsFromSchema(featureType);
                        featureTypeDTO.setSchemaAttributes(attributeDTOs);
                        if (GlobalLayerSupertype.LOGGER.isLoggable(Level.FINER)) {
                            GlobalLayerSupertype.LOGGER.finer("No schema found, setting featureTypeDTO with " + attributeDTOs);
                        }
                        break block45;
                    }
                    for (int index = 0; index < featureType.getAttributeCount(); ++index) {
                        AttributeType attrib = featureType.getAttributeType(index);
                        attributeNames.add(attrib.getName());
                        ATTRIBUTENames.add(attrib.getName().toUpperCase());
                    }
                    if (featureTypeDTO.getSchemaAttributes() == null) break block45;
                    Iterator a = featureTypeDTO.getSchemaAttributes().iterator();
                    while (a.hasNext()) {
                        AttributeTypeInfoDTO attribDTO = (AttributeTypeInfoDTO)a.next();
                        String attributeName = attribDTO.getName();
                        if (attributeNames.contains(attributeName)) continue;
                        if (ATTRIBUTENames.contains(attributeName.toUpperCase())) {
                            if (GlobalLayerSupertype.LOGGER.isLoggable(Level.SEVERE)) {
                                GlobalLayerSupertype.LOGGER.severe("FeatureTypeInfo " + key + " ignored - attribute '" + attributeName + "' not found - please check captialization");
                            }
                        } else {
                            if (GlobalLayerSupertype.LOGGER.isLoggable(Level.SEVERE)) {
                                GlobalLayerSupertype.LOGGER.severe("FeatureTypeInfo " + key + " ignored - attribute '" + attributeName + "' not found!");
                            }
                            String names = "";
                            Iterator x = attributeNames.iterator();
                            if (x.hasNext()) {
                                names = x.next().toString();
                            }
                            while (x.hasNext()) {
                                names = ":::" + x.next().toString();
                            }
                            if (GlobalLayerSupertype.LOGGER.isLoggable(Level.SEVERE)) {
                                GlobalLayerSupertype.LOGGER.severe("Valid attribute names include :::" + names);
                            }
                        }
                        this.errors.put(featureTypeDTO, new ConfigurationException("FeatureTypeInfo " + key + " could not be used - DataStore " + dataStoreId + " is not defined!"));
                    }
                    break block45;
                }
                catch (IllegalStateException illegalState) {
                    if (GlobalLayerSupertype.LOGGER.isLoggable(Level.SEVERE)) {
                        GlobalLayerSupertype.LOGGER.severe("FeatureTypeInfo " + key + " ignored - as DataStore " + dataStoreId + " is disabled!");
                    }
                    this.errors.put(featureTypeDTO, Boolean.FALSE);
                }
                catch (IOException ioException) {
                    if (GlobalLayerSupertype.LOGGER.isLoggable(Level.SEVERE)) {
                        GlobalLayerSupertype.LOGGER.log(Level.SEVERE, "FeatureTypeInfo " + key + " ignored - as DataStore " + dataStoreId + " is unavailable:" + ioException);
                    }
                    if (GlobalLayerSupertype.LOGGER.isLoggable(Level.FINE)) {
                        GlobalLayerSupertype.LOGGER.log(Level.FINE, key + " unavailable", ioException);
                    }
                    this.errors.put(featureTypeDTO, ioException);
                }
                catch (NoSuchElementException nse) {
                    if (GlobalLayerSupertype.LOGGER.isLoggable(Level.SEVERE)) {
                        GlobalLayerSupertype.LOGGER.log(Level.SEVERE, "FeatureTypeInfo " + key + " ignored - as DataStore " + dataStoreId + (" can't find FeatureType '" + typeName + "'.  Error was:\n") + nse);
                    }
                    if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.FINE)) continue;
                    GlobalLayerSupertype.LOGGER.log(Level.FINE, typeName + " not found", nse);
                }
                catch (Throwable unExpected) {
                    if (GlobalLayerSupertype.LOGGER.isLoggable(Level.SEVERE)) {
                        GlobalLayerSupertype.LOGGER.log(Level.SEVERE, "FeatureTypeInfo " + key + " ignored - as DataStore " + dataStoreId + " is broken:" + unExpected);
                    }
                    if (GlobalLayerSupertype.LOGGER.isLoggable(Level.FINE)) {
                        GlobalLayerSupertype.LOGGER.log(Level.FINE, key + " unavailable", unExpected);
                    }
                    this.errors.put(featureTypeDTO, unExpected);
                }
                continue;
            }
            String prefix = dataStoreInfo.getNamesSpacePrefix();
            if (GlobalLayerSupertype.LOGGER.isLoggable(Level.FINEST)) {
                GlobalLayerSupertype.LOGGER.finest("FeatureType " + key + " creating FeatureTypeInfo for " + prefix + ":" + typeName);
            }
            FeatureTypeInfo featureTypeInfo = null;
            try {
                featureTypeInfo = new FeatureTypeInfo(featureTypeDTO, this);
            }
            catch (ConfigurationException configException) {
                if (GlobalLayerSupertype.LOGGER.isLoggable(Level.SEVERE)) {
                    GlobalLayerSupertype.LOGGER.log(Level.SEVERE, "FeatureTypeInfo " + key + " ignored - configuration problem:" + configException);
                }
                if (GlobalLayerSupertype.LOGGER.isLoggable(Level.FINEST)) {
                    GlobalLayerSupertype.LOGGER.log(Level.FINEST, key + " unavailable", configException);
                }
                this.errors.put(featureTypeDTO, configException);
                continue;
            }
            String key2 = featureTypeDTO.getAlias() == null ? prefix + ":" + typeName : prefix + ":" + featureTypeDTO.getAlias();
            if (map.containsKey(key2)) {
                if (GlobalLayerSupertype.LOGGER.isLoggable(Level.SEVERE)) {
                    GlobalLayerSupertype.LOGGER.severe("FeatureTypeInfo '" + key2 + "' already defined - you must have duplicate defined?");
                }
                this.errors.put(featureTypeDTO, new ConfigurationException("FeatureTypeInfo '" + key2 + "' already defined - you must have duplicate defined?"));
                continue;
            }
            if (GlobalLayerSupertype.LOGGER.isLoggable(Level.FINEST)) {
                GlobalLayerSupertype.LOGGER.finest("FeatureTypeInfo " + key2 + " has been created...");
            }
            map.put(key2, featureTypeInfo);
            this.layerNames.put(key2, TYPE_VECTOR);
            if (GlobalLayerSupertype.LOGGER.isLoggable(Level.FINEST)) {
                GlobalLayerSupertype.LOGGER.finest("FeatureTypeInfo '" + key2 + "' is registered:" + dataStoreInfo);
            }
            this.errors.put(featureTypeDTO, Boolean.TRUE);
        }
        return map;
    }

    private List createAttrDTOsFromSchema(FeatureType featureType) {
        List attrList = DataTransferObjectFactory.generateAttributes(featureType);
        return attrList;
    }

    private final Map loadStyles(DataDTO dto) {
        HashMap<String, Style> map = new HashMap<String, Style>();
        this.stFiles = new HashMap();
        if (dto == null || dto.getStyles() == null) {
            return Collections.EMPTY_MAP;
        }
        Iterator i = dto.getStyles().values().iterator();
        while (i.hasNext()) {
            Style style;
            StyleDTO styleDTO = (StyleDTO)i.next();
            String id = styleDTO.getId();
            try {
                style = this.loadStyle(styleDTO.getFilename());
                style.setName(id);
            }
            catch (Exception ioException) {
                if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.SEVERE)) continue;
                GlobalLayerSupertype.LOGGER.log(Level.SEVERE, "Could not load style " + id, ioException);
                continue;
            }
            this.stFiles.put(id, styleDTO.getFilename());
            map.put(id, style);
        }
        if (GlobalLayerSupertype.LOGGER.isLoggable(Level.FINER)) {
            GlobalLayerSupertype.LOGGER.finer("returning styles " + map + "\n and set map " + this.stFiles);
        }
        return map;
    }

    static final void outputStatus(String title, Map status) {
        if (GlobalLayerSupertype.LOGGER.isLoggable(Level.INFO)) {
            GlobalLayerSupertype.LOGGER.info(title);
        }
        Iterator i = status.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == Boolean.TRUE) {
                if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.FINE)) continue;
                GlobalLayerSupertype.LOGGER.fine(key + ": ready");
                continue;
            }
            if (value instanceof Throwable) {
                Throwable t = (Throwable)value;
                if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.SEVERE)) continue;
                GlobalLayerSupertype.LOGGER.log(Level.SEVERE, key + " not ready", t);
                continue;
            }
            if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.WARNING)) continue;
            GlobalLayerSupertype.LOGGER.warning(key + ": '" + value + "'");
        }
    }

    public synchronized Map statusDataStores() {
        HashMap m = new HashMap();
        Iterator i = this.errors.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            FeatureTypeInfoDTO ftdto = (FeatureTypeInfoDTO)e.getKey();
            m.put(ftdto.getDataStoreId() + ":" + ftdto.getName(), e.getValue());
        }
        return m;
    }

    public synchronized Map statusNamespaces() {
        HashMap m = new HashMap();
        Iterator i = this.errors.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            FeatureTypeInfoDTO ftdto = (FeatureTypeInfoDTO)e.getKey();
            DataStoreInfo dsdto = (DataStoreInfo)this.dataStores.get(ftdto.getDataStoreId());
            if (dsdto == null) continue;
            m.put(dsdto.getNamesSpacePrefix() + ":" + ftdto.getName(), e.getValue());
        }
        return m;
    }

    public synchronized Object toDTO() {
        DataDTO dto = new DataDTO();
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        Iterator i = this.nameSpaces.keySet().iterator();
        while (i.hasNext()) {
            NameSpaceInfo nsi = (NameSpaceInfo)this.nameSpaces.get(i.next());
            tmp.put(nsi.getPrefix(), nsi.toDTO());
        }
        dto.setNameSpaces(tmp);
        if (this.defaultNameSpace != null) {
            dto.setDefaultNameSpacePrefix(this.defaultNameSpace.getPrefix());
        }
        tmp = new HashMap();
        i = this.styles.keySet().iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            Style st = (Style)this.styles.get(id);
            StyleDTO sdto = new StyleDTO();
            sdto.setDefault(st.isDefault());
            sdto.setFilename((File)this.stFiles.get(id));
            sdto.setId(id);
            tmp.put(id, sdto);
        }
        if (GlobalLayerSupertype.LOGGER.isLoggable(Level.FINER)) {
            GlobalLayerSupertype.LOGGER.finer("setting styles to: " + tmp);
        }
        dto.setStyles(tmp);
        tmp = new HashMap();
        i = this.formats.keySet().iterator();
        while (i.hasNext()) {
            CoverageStoreInfo fmi = (CoverageStoreInfo)this.formats.get(i.next());
            tmp.put(fmi.getId(), fmi.toDTO());
        }
        dto.setFormats(tmp);
        tmp = new HashMap();
        i = this.dataStores.keySet().iterator();
        while (i.hasNext()) {
            DataStoreInfo dsi = (DataStoreInfo)this.dataStores.get(i.next());
            tmp.put(dsi.getId(), dsi.toDTO());
        }
        dto.setDataStores(tmp);
        tmp = new HashMap();
        i = this.errors.keySet().iterator();
        while (i.hasNext()) {
            FeatureTypeInfoDTO fti = (FeatureTypeInfoDTO)i.next();
            tmp.put(fti.getKey(), fti.clone());
        }
        dto.setFeaturesTypes(tmp);
        tmp = new HashMap();
        i = this.coverages.keySet().iterator();
        while (i.hasNext()) {
            CoverageInfo cvi = (CoverageInfo)this.coverages.get(i.next());
            tmp.put(cvi.getName(), cvi.toDTO());
        }
        dto.setCoverages(tmp);
        return dto;
    }

    public synchronized DataStoreInfo getDataStoreInfo(String id) {
        DataStoreInfo dsi = (DataStoreInfo)this.dataStores.get(id);
        if (dsi != null && dsi.isEnabled()) {
            return dsi;
        }
        return null;
    }

    public synchronized CoverageStoreInfo getFormatInfo(String id) {
        CoverageStoreInfo dfi = (CoverageStoreInfo)this.formats.get(id);
        if (dfi != null && dfi.isEnabled()) {
            return dfi;
        }
        return null;
    }

    public synchronized NameSpaceInfo[] getNameSpaces() {
        NameSpaceInfo[] ns = new NameSpaceInfo[this.nameSpaces.values().size()];
        return new ArrayList(this.nameSpaces.values()).toArray(ns);
    }

    public synchronized NameSpaceInfo getNameSpace(String prefix) {
        NameSpaceInfo retNS = (NameSpaceInfo)this.nameSpaces.get(prefix);
        return retNS;
    }

    public synchronized NameSpaceInfo getNameSpaceFromURI(String uri) {
        Iterator i = this.nameSpaces.values().iterator();
        while (i.hasNext()) {
            NameSpaceInfo nsInfo = (NameSpaceInfo)i.next();
            if (!nsInfo.getURI().equals(uri)) continue;
            return nsInfo;
        }
        return null;
    }

    public synchronized NameSpaceInfo getDefaultNameSpace() {
        return this.defaultNameSpace;
    }

    public synchronized Map getStyles() {
        return this.styles;
    }

    public synchronized Style getStyle(String id) {
        return (Style)this.styles.get(id);
    }

    public synchronized FeatureTypeInfo getFeatureTypeInfo(String name) throws NoSuchElementException {
        if (GlobalLayerSupertype.LOGGER.isLoggable(Level.FINE)) {
            GlobalLayerSupertype.LOGGER.fine("getting type " + name);
        }
        FeatureTypeInfo found = null;
        found = (FeatureTypeInfo)this.featureTypes.get(name);
        if (found != null) {
            return found;
        }
        String defaultPrefix = this.defaultNameSpace.getPrefix();
        found = (FeatureTypeInfo)this.featureTypes.get(defaultPrefix + ":" + name);
        if (found != null) {
            return found;
        }
        Iterator i = this.featureTypes.values().iterator();
        while (i.hasNext()) {
            FeatureTypeInfo fto = (FeatureTypeInfo)i.next();
            if (name == null || !name.equals(fto.getName())) continue;
            found = fto;
        }
        if (found != null) {
            return found;
        }
        throw new NoSuchElementException("Could not locate FeatureTypeConfig '" + name + "'");
    }

    public FeatureTypeInfo getFeatureTypeInfo(QName name) {
        return this.getFeatureTypeInfo(name.getLocalPart(), name.getNamespaceURI());
    }

    public synchronized FeatureTypeInfo getFeatureTypeInfo(String typename, String uri) {
        FeatureTypeInfo fallback = null;
        Iterator it = this.featureTypes.values().iterator();
        while (it.hasNext()) {
            FeatureTypeInfo fType = (FeatureTypeInfo)it.next();
            if (!fType.isEnabled()) continue;
            String typeId = fType.getNameSpace().getPrefix() + ":" + typename;
            boolean t1 = fType.getName().equals(typeId);
            boolean t2 = fType.getNameSpace().getUri().equals(uri);
            if (t1 && t2) {
                return fType;
            }
            if (!t1) continue;
            fallback = fType;
        }
        return fallback;
    }

    public synchronized CoverageInfo getCoverageInfo(String name) throws NoSuchElementException {
        GlobalLayerSupertype.LOGGER.fine("getting coverage " + name);
        CoverageInfo found = null;
        found = (CoverageInfo)this.coverages.get(name);
        if (found != null) {
            return found;
        }
        String defaultPrefix = this.defaultNameSpace.getPrefix();
        found = (CoverageInfo)this.coverages.get(defaultPrefix + ":" + name);
        if (found != null) {
            return found;
        }
        Iterator i = this.coverages.values().iterator();
        while (i.hasNext()) {
            CoverageInfo cvo = (CoverageInfo)i.next();
            if (name == null || !name.equals(cvo.getName())) continue;
            found = cvo;
        }
        if (found != null) {
            return found;
        }
        throw new NoSuchElementException("Could not locate CoverageConfig '" + name + "'");
    }

    public synchronized CoverageInfo getCoverageInfo(String name, String uri) {
        Iterator it = this.coverages.values().iterator();
        while (it.hasNext()) {
            CoverageInfo cvo = (CoverageInfo)it.next();
            if (!cvo.isEnabled()) continue;
            String cvId = cvo.getNameSpace().getPrefix() + ":" + name;
            boolean t1 = cvo.getName().equals(cvId);
            boolean t2 = cvo.getNameSpace().getUri().equals(uri);
            if (!t1) continue;
            return cvo;
        }
        return null;
    }

    public MapLayerInfo getMapLayerInfo(String layerName) {
        Integer layerType = this.getLayerType(layerName);
        if (layerType == TYPE_VECTOR) {
            return new MapLayerInfo(this.getFeatureTypeInfo(layerName));
        }
        if (layerType == TYPE_RASTER) {
            return new MapLayerInfo(this.getCoverageInfo(layerName));
        }
        return null;
    }

    public synchronized Map getFeatureTypeInfos() {
        return Collections.unmodifiableMap(this.featureTypes);
    }

    public synchronized Map getCoverageInfos() {
        return Collections.unmodifiableMap(this.coverages);
    }

    public Style loadStyle(String fileName, String base) throws IOException {
        return this.loadStyle(new File(base + fileName));
    }

    public Style loadStyle(File fileName) throws IOException {
        SLDParser stylereader = new SLDParser(styleFactory, fileName);
        return stylereader.readXML()[0];
    }

    private static boolean isInfoFile(File testFile) {
        String testName = testFile.getAbsolutePath();
        int start = testName.length() - INFO_FILE.length();
        int end = testName.length();
        return testName.substring(start, end).equals(INFO_FILE);
    }

    public synchronized int getConnectionCount() {
        int count = 0;
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            DataStoreInfo meta = (DataStoreInfo)i.next();
            if (!meta.isEnabled()) continue;
            try {
                DataStore dataStore = meta.getDataStore();
            }
            catch (Throwable notAvailable) {
                continue;
            }
            ++count;
        }
        return count;
    }

    public synchronized int getLockCount() {
        int count = 0;
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            DataStore dataStore;
            DataStoreInfo meta = (DataStoreInfo)i.next();
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            catch (Throwable huh) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager != null) continue;
        }
        return count;
    }

    public synchronized int lockReleaseAll() {
        int count = 0;
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            DataStore dataStore;
            DataStoreInfo meta = (DataStoreInfo)i.next();
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            catch (Throwable huh) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager != null) continue;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void lockRelease(String lockID) {
        boolean refresh = false;
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            DefaultTransaction t;
            block13: {
                DataStore dataStore;
                DataStoreInfo meta = (DataStoreInfo)i.next();
                if (!meta.isEnabled()) continue;
                try {
                    dataStore = meta.getDataStore();
                }
                catch (IllegalStateException notAvailable) {
                    continue;
                }
                LockingManager lockingManager = dataStore.getLockingManager();
                if (lockingManager == null) continue;
                t = new DefaultTransaction("Refresh " + meta.getNameSpace());
                t.addAuthorization(lockID);
                if (!lockingManager.release(lockID, (Transaction)t)) break block13;
                refresh = true;
            }
            Object var10_10 = null;
            try {
                t.close();
            }
            catch (IOException closeException) {
                if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.FINEST)) continue;
                GlobalLayerSupertype.LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
            }
            continue;
            {
                catch (IOException e) {
                    if (GlobalLayerSupertype.LOGGER.isLoggable(Level.WARNING)) {
                        GlobalLayerSupertype.LOGGER.log(Level.WARNING, e.getMessage(), e);
                    }
                    var10_10 = null;
                    try {
                        t.close();
                    }
                    catch (IOException closeException) {
                        if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.FINEST)) continue;
                        GlobalLayerSupertype.LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                block14: {
                    var10_10 = null;
                    try {
                        t.close();
                    }
                    catch (IOException closeException) {
                        if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.FINEST)) break block14;
                        GlobalLayerSupertype.LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                    }
                }
                throw throwable;
            }
        }
        if (!refresh) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void lockRefresh(String lockID) {
        boolean refresh = false;
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            DefaultTransaction t;
            block13: {
                DataStore dataStore;
                DataStoreInfo meta = (DataStoreInfo)i.next();
                if (!meta.isEnabled()) continue;
                try {
                    dataStore = meta.getDataStore();
                }
                catch (IllegalStateException notAvailable) {
                    continue;
                }
                LockingManager lockingManager = dataStore.getLockingManager();
                if (lockingManager == null) continue;
                t = new DefaultTransaction("Refresh " + meta.getNameSpace());
                t.addAuthorization(lockID);
                if (!lockingManager.refresh(lockID, (Transaction)t)) break block13;
                refresh = true;
            }
            Object var10_10 = null;
            try {
                t.close();
            }
            catch (IOException closeException) {
                if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.FINEST)) continue;
                GlobalLayerSupertype.LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
            }
            continue;
            {
                catch (IOException e) {
                    if (GlobalLayerSupertype.LOGGER.isLoggable(Level.WARNING)) {
                        GlobalLayerSupertype.LOGGER.log(Level.WARNING, e.getMessage(), e);
                    }
                    var10_10 = null;
                    try {
                        t.close();
                    }
                    catch (IOException closeException) {
                        if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.FINEST)) continue;
                        GlobalLayerSupertype.LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                block14: {
                    var10_10 = null;
                    try {
                        t.close();
                    }
                    catch (IOException closeException) {
                        if (!GlobalLayerSupertype.LOGGER.isLoggable(Level.FINEST)) break block14;
                        GlobalLayerSupertype.LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                    }
                }
                throw throwable;
            }
        }
        if (!refresh) {
            // empty if block
        }
    }

    public synchronized boolean lockRefresh(String lockID, Transaction t) throws IOException {
        boolean refresh = false;
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            DataStore dataStore;
            DataStoreInfo meta = (DataStoreInfo)i.next();
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager == null || !lockingManager.refresh(lockID, t)) continue;
            refresh = true;
        }
        return refresh;
    }

    public synchronized boolean lockRelease(String lockID, Transaction t) throws IOException {
        boolean release = false;
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            DataStore dataStore;
            DataStoreInfo meta = (DataStoreInfo)i.next();
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager == null || !lockingManager.release(lockID, t)) continue;
            release = true;
        }
        return release;
    }

    public synchronized boolean lockExists(String lockID) {
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            DataStore dataStore;
            DataStoreInfo meta = (DataStoreInfo)i.next();
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager == null || !lockingManager.exists(lockID)) continue;
            return true;
        }
        return false;
    }

    public synchronized Set getPrefixes() {
        return Collections.unmodifiableSet(this.nameSpaces.keySet());
    }

    public synchronized String getDefaultPrefix() {
        return this.defaultNameSpace.getPrefix();
    }

    public synchronized NameSpaceInfo getNamespaceMetaData(String prefix) {
        return this.getNameSpace(prefix);
    }

    public synchronized void registerDataStore(DataStore dataStore) throws IOException {
    }

    public synchronized FeatureSource getFeatureSource(String prefix, String typeName) throws IOException {
        if (prefix == null || prefix == "") {
            prefix = this.defaultNameSpace.getPrefix();
        }
        NameSpaceInfo namespace = this.getNamespaceMetaData(prefix);
        FeatureTypeInfo featureType = namespace.getFeatureTypeInfo(typeName);
        DataStoreInfo dataStore = featureType.getDataStoreMetaData();
        return dataStore.getDataStore().getFeatureSource(typeName);
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public Integer getLayerType(String layerName) {
        Integer layerType = (Integer)this.layerNames.get(layerName);
        if (layerType != null) {
            return layerType;
        }
        if (layerName.indexOf(":") == -1) {
            String prefixedName = this.defaultNameSpace.getPrefix() + ":" + layerName;
            return (Integer)this.layerNames.get(prefixedName);
        }
        String strippedName = layerName.substring(layerName.indexOf(":") + 1, layerName.length());
        return (Integer)this.layerNames.get(strippedName);
    }

    public Set getLayerNames() {
        return Collections.unmodifiableSet(this.layerNames.keySet());
    }
}

