/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.memory.UserMap;
import org.acegisecurity.userdetails.memory.UserMapEditor;
import org.geoserver.security.PropertyFileWatcher;
import org.geotools.util.logging.Logging;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class GeoserverUserDao
implements UserDetailsService {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    private UserMap userMap;
    private PropertyFileWatcher userDefinitionsFile;
    private GeoServer geoServer;
    static /* synthetic */ Class class$org$geoserver$security$GeoserverUserDao;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        this.checkUserMap();
        return this.userMap.getUser(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void checkUserMap() throws DataAccessResourceFailureException {
        block25: {
            InputStream is = null;
            OutputStream os = null;
            if (this.userMap == null || this.userDefinitionsFile != null && this.userDefinitionsFile.isStale()) {
                block23: {
                    if (this.userDefinitionsFile == null) {
                        File securityDir = GeoserverDataDirectory.findCreateConfigDir("security");
                        File propFile = new File(securityDir, "users.properties");
                        if (!propFile.exists()) {
                            Properties p = new Properties();
                            if (this.geoServer != null && this.geoServer.getAdminUserName() != null && !this.geoServer.getAdminUserName().trim().equals("")) {
                                ((Hashtable)p).put(this.geoServer.getAdminUserName(), this.geoServer.getAdminPassword() + ",ROLE_ADMINISTRATOR");
                            } else {
                                ((Hashtable)p).put("admin", "geoserver,ROLE_ADMINISTRATOR");
                            }
                            os = new FileOutputStream(propFile);
                            p.store(os, "Format: name=password,ROLE1,...,ROLEN");
                            os.close();
                            File serviceFile = new File(securityDir, "service.properties");
                            os = new FileOutputStream(serviceFile);
                            is = (class$org$geoserver$security$GeoserverUserDao == null ? (class$org$geoserver$security$GeoserverUserDao = GeoserverUserDao.class$("org.geoserver.security.GeoserverUserDao")) : class$org$geoserver$security$GeoserverUserDao).getResourceAsStream("serviceTemplate.properties");
                            byte[] buffer = new byte[1024];
                            int count = 0;
                            while ((count = is.read(buffer)) > 0) {
                                os.write(buffer, 0, count);
                            }
                        }
                        this.userDefinitionsFile = new PropertyFileWatcher(propFile);
                    }
                    this.userMap = new UserMap();
                    UserMapEditor.addUsersFromProperties((UserMap)this.userMap, (Properties)this.userDefinitionsFile.getProperties());
                    Object var10_10 = null;
                    if (is == null) break block23;
                    try {
                        is.close();
                    }
                    catch (IOException ei) {
                        // empty catch block
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException eo) {}
                }
                break block25;
                {
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "An error occurred loading user definitions", e);
                        Object var10_11 = null;
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException ei) {
                                // empty catch block
                            }
                        }
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException eo) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ei) {
                            // empty catch block
                        }
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException eo) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    public GeoServer getGeoServer() {
        return this.geoServer;
    }

    public void setGeoServer(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

