/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.List;
import org.geotools.data.FeatureSource;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.styling.Style;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.util.DataStoreUtils;

public final class MapLayerInfo
extends GlobalLayerSupertype {
    public static int TYPE_VECTOR = Data.TYPE_VECTOR;
    public static int TYPE_RASTER = Data.TYPE_RASTER;
    public static int TYPE_BASEMAP = Data.TYPE_RASTER + 1;
    public static int TYPE_REMOTE_VECTOR = Data.TYPE_RASTER + 2;
    private FeatureTypeInfo feature;
    private FeatureSource remoteFeatureSource;
    private CoverageInfo coverage;
    private int type;
    private String name;
    private String label;
    private String description;
    private String dirName;
    private List subLayerInfo;
    private List styles;

    public MapLayerInfo() {
        this.name = "";
        this.label = "";
        this.description = "";
        this.dirName = "";
        this.coverage = null;
        this.feature = null;
        this.type = -1;
    }

    public MapLayerInfo(CoverageInfo info) {
        this.name = info.getName();
        this.label = info.getLabel();
        this.description = info.getDescription();
        this.dirName = info.getDirName();
        this.coverage = info;
        this.feature = null;
        this.type = TYPE_RASTER;
    }

    public MapLayerInfo(FeatureTypeInfo info) {
        this.name = info.getName();
        this.label = info.getTitle();
        this.description = info.getAbstract();
        this.dirName = info.getDirName();
        this.feature = info;
        this.coverage = null;
        this.type = TYPE_VECTOR;
    }

    public MapLayerInfo(FeatureSource remoteSource) {
        this.label = this.name = remoteSource.getSchema().getTypeName();
        this.description = "Remote WFS";
        this.dirName = null;
        this.remoteFeatureSource = remoteSource;
        this.type = TYPE_REMOTE_VECTOR;
    }

    Object toDTO() {
        return null;
    }

    public Envelope getBoundingBox() throws IOException {
        if (this.type == TYPE_VECTOR) {
            try {
                return this.feature.getBoundingBox();
            }
            catch (IllegalArgumentException e) {
                FeatureSource realSource = this.feature.getFeatureSource();
                return DataStoreUtils.getBoundingBoxEnvelope(realSource);
            }
        }
        return new ReferencedEnvelope(this.coverage.getEnvelope().getMinimum(0), this.coverage.getEnvelope().getMaximum(0), this.coverage.getEnvelope().getMinimum(1), this.coverage.getEnvelope().getMaximum(1), this.coverage.getCrs());
    }

    public Envelope getLatLongBoundingBox() throws IOException {
        if (this.type == TYPE_VECTOR) {
            try {
                return this.feature.getLatLongBoundingBox();
            }
            catch (IllegalArgumentException e) {
                FeatureSource realSource = this.feature.getFeatureSource();
                return DataStoreUtils.getBoundingBoxEnvelope(realSource);
            }
        }
        GeneralEnvelope ge = this.coverage.getWGS84LonLatEnvelope();
        return new Envelope(ge.getMinimum(0), ge.getMaximum(0), ge.getMinimum(1), ge.getMaximum(1));
    }

    public CoverageInfo getCoverage() {
        return this.coverage;
    }

    public void setCoverage(CoverageInfo coverage) {
        this.name = coverage.getName();
        this.label = coverage.getLabel();
        this.description = coverage.getDescription();
        this.dirName = coverage.getDirName();
        this.coverage = coverage;
        this.feature = null;
        this.type = TYPE_RASTER;
    }

    public void setBase(String baseLayerName, List subLayerInfo, List styles) {
        this.name = baseLayerName;
        this.type = TYPE_BASEMAP;
        this.subLayerInfo = subLayerInfo;
        this.styles = styles;
    }

    public List getSubLayers() {
        return this.subLayerInfo;
    }

    public List getStyles() {
        return this.styles;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public FeatureTypeInfo getFeature() {
        return this.feature;
    }

    public void setFeature(FeatureTypeInfo feature) {
        try {
            this.name = feature.getName();
            this.label = feature.getTitle();
            this.description = feature.getAbstract();
            this.dirName = feature.getDirName();
        }
        catch (IllegalArgumentException e) {
            this.name = "";
            this.label = "";
            this.description = "";
            this.dirName = "";
        }
        this.feature = feature;
        this.coverage = null;
        this.type = TYPE_VECTOR;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Style getDefaultStyle() {
        if (this.type == TYPE_VECTOR) {
            return this.feature.getDefaultStyle();
        }
        if (this.type == TYPE_RASTER) {
            return this.coverage.getDefaultStyle();
        }
        return null;
    }

    public FeatureSource getRemoteFeatureSource() {
        return this.remoteFeatureSource;
    }

    public void setRemoteFeatureSource(FeatureSource remoteFeatureSource) {
        this.remoteFeatureSource = remoteFeatureSource;
    }
}

