/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.geoserver.feature.FeatureSourceUtils;
import org.geoserver.feature.retype.RetypingDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.factory.FactoryConfigurationError;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.SchemaException;
import org.geotools.feature.type.GeometricAttributeType;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.styling.Style;
import org.opengis.filter.Filter;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.vfny.geoserver.global.AttributeTypeInfo;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.DataStoreInfo;
import org.vfny.geoserver.global.GeoServerFeatureSource;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.LegendURL;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;
import org.vfny.geoserver.global.dto.DataTransferObjectFactory;
import org.vfny.geoserver.global.dto.FeatureTypeInfoDTO;
import org.vfny.geoserver.global.dto.LegendURLDTO;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class FeatureTypeInfo
extends GlobalLayerSupertype {
    private static Hashtable SRSLookup = new Hashtable();
    public static int FORCE = 0;
    public static int REPROJECT = 1;
    public static int LEAVE = 2;
    private static final int DEFAULT_NUM_DECIMALS = 8;
    private String dataStoreId;
    private Envelope latLongBBox;
    private Envelope nativeBBox;
    private int SRS;
    private List schema;
    private String schemaName;
    private String schemaBase;
    String typeName;
    private String wmsPath;
    private String dirName;
    private String _abstract;
    private List keywords;
    private List metadataLinks;
    private int numDecimals;
    private Filter definitionQuery = null;
    private String defaultStyle;
    private ArrayList styles;
    private String title;
    private Data data;
    private Map meta;
    private String xmlSchemaFrag;
    private FeatureType ft;
    private LegendURL legendURL;
    private File schemaFile;
    private String cacheMaxAge;
    private boolean cachingEnabled;
    private int srsHandling;
    private int maxFeatures;
    private String alias;
    static /* synthetic */ Class class$org$geotools$feature$FeatureType;
    static /* synthetic */ Class class$org$opengis$filter$Filter;
    static /* synthetic */ Class class$org$opengis$referencing$crs$CoordinateReferenceSystem;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;

    public FeatureTypeInfo() {
    }

    public FeatureTypeInfo(FeatureTypeInfoDTO dto, Data data) throws ConfigurationException {
        this.data = data;
        this._abstract = dto.getAbstract();
        this.dataStoreId = dto.getDataStoreId();
        this.defaultStyle = dto.getDefaultStyle();
        this.styles = dto.getStyles();
        if (dto.getLegendURL() != null) {
            this.legendURL = new LegendURL(dto.getLegendURL());
        }
        this.definitionQuery = dto.getDefinitionQuery();
        this.dirName = dto.getDirName();
        this.keywords = dto.getKeywords();
        this.metadataLinks = dto.getMetadataLinks();
        this.latLongBBox = dto.getLatLongBBox();
        this.typeName = dto.getName();
        this.alias = dto.getAlias();
        this.wmsPath = dto.getWmsPath();
        this.numDecimals = dto.getNumDecimals();
        List tmp = dto.getSchemaAttributes();
        this.schema = new LinkedList();
        if (tmp != null && !tmp.isEmpty()) {
            Iterator i = tmp.iterator();
            while (i.hasNext()) {
                this.schema.add(new AttributeTypeInfo((AttributeTypeInfoDTO)i.next()));
            }
        }
        this.schemaBase = dto.getSchemaBase();
        this.schemaName = dto.getSchemaName();
        this.schemaFile = dto.getSchemaFile();
        this.SRS = dto.getSRS();
        this.srsHandling = dto.getSRSHandling();
        this.nativeBBox = dto.getNativeBBox();
        this.title = dto.getTitle();
        this.cacheMaxAge = dto.getCacheMaxAge();
        this.cachingEnabled = dto.isCachingEnabled();
        this.maxFeatures = dto.getMaxFeatures();
    }

    public Object toDTO() {
        FeatureTypeInfoDTO dto = new FeatureTypeInfoDTO();
        dto.setAbstract(this._abstract);
        dto.setDataStoreId(this.dataStoreId);
        dto.setDefaultStyle(this.defaultStyle);
        dto.setStyles(this.styles);
        if (this.legendURL != null) {
            dto.setLegendURL((LegendURLDTO)this.legendURL.toDTO());
        }
        dto.setDefinitionQuery(this.definitionQuery);
        dto.setDirName(this.dirName);
        dto.setKeywords(this.keywords);
        dto.setMetadataLinks(this.metadataLinks);
        dto.setLatLongBBox(this.latLongBBox);
        dto.setNativeBBox(this.nativeBBox);
        dto.setName(this.typeName);
        dto.setAlias(this.typeName);
        dto.setWmsPath(this.wmsPath);
        dto.setNumDecimals(this.numDecimals);
        LinkedList<Object> tmp = new LinkedList<Object>();
        Iterator i = this.schema.iterator();
        while (i.hasNext()) {
            tmp.add(((AttributeTypeInfo)i.next()).toDTO());
        }
        dto.setSchemaAttributes(tmp);
        dto.setSchemaBase(this.schemaBase);
        dto.setSchemaName(this.getSchemaName());
        dto.setSRS(this.SRS);
        dto.setTitle(this.title);
        dto.setCacheMaxAge(this.cacheMaxAge);
        dto.setCachingEnabled(this.cachingEnabled);
        return dto;
    }

    public int getNumDecimals() {
        return this.numDecimals;
    }

    public DataStoreInfo getDataStoreInfo() {
        return this.data.getDataStoreInfo(this.dataStoreId);
    }

    public Style getDefaultStyle() {
        return this.data.getStyle(this.defaultStyle);
    }

    public ArrayList getStyles() {
        ArrayList<Style> realStyles = new ArrayList<Style>();
        Iterator s_IT = ((AbstractList)this.styles).iterator();
        while (s_IT.hasNext()) {
            realStyles.add(this.data.getStyle((String)s_IT.next()));
        }
        return realStyles;
    }

    public boolean isEnabled() {
        return this.getDataStoreInfo() != null && this.getDataStoreInfo().isEnabled();
    }

    public String getPrefix() {
        return this.getDataStoreInfo().getNameSpace().getPrefix();
    }

    public NameSpaceInfo getNameSpace() {
        if (!this.isEnabled()) {
            throw new IllegalStateException("This featureType is not enabled");
        }
        return this.getDataStoreInfo().getNameSpace();
    }

    public String getName() {
        if (this.alias == null) {
            return this.getPrefix() + ":" + this.typeName;
        }
        return this.getPrefix() + ":" + this.alias;
    }

    public FeatureSource getFeatureSource() throws IOException {
        return this.getFeatureSource(false);
    }

    public FeatureSource getFeatureSource(boolean skipReproject) throws IOException {
        if (!this.isEnabled() || this.getDataStoreInfo().getDataStore() == null) {
            throw new IOException("featureType: " + this.getName() + " does not have a properly configured " + "datastore");
        }
        FeatureSource realSource = this.getAliasedFeatureSource();
        int localSrsHandling = this.srsHandling;
        if (this.srsHandling == REPROJECT && skipReproject) {
            localSrsHandling = LEAVE;
        }
        if (this.schema == null || this.schema.isEmpty()) {
            return realSource;
        }
        CoordinateReferenceSystem resultCrs = null;
        GeometryAttributeType gat = realSource.getSchema().getDefaultGeometry();
        CoordinateReferenceSystem nativeCrs = gat != null ? gat.getCoordinateSystem() : null;
        resultCrs = localSrsHandling == LEAVE && nativeCrs != null ? nativeCrs : this.getSRS(this.SRS);
        FeatureType schema = this.getFeatureType(realSource);
        try {
            if (schema.getDefaultGeometry() != null && !CRS.equalsIgnoreMetadata((Object)resultCrs, (Object)schema.getDefaultGeometry().getCoordinateSystem())) {
                schema = FeatureTypes.transform((FeatureType)schema, (CoordinateReferenceSystem)resultCrs);
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Problem forcing CRS onto feature type", (Throwable)e);
        }
        if (!this.implementsInterface(realSource.getClass(), "org.geotools.data.VersioningFeatureSource")) {
            return GeoServerFeatureSource.create(realSource, schema, this.getDefinitionQuery(), resultCrs, localSrsHandling);
        }
        try {
            Class<?> clazz = Class.forName("org.vfny.geoserver.global.GeoServerVersioningFeatureSource");
            Method m = clazz.getMethod("create", Class.forName("org.geotools.data.VersioningFeatureSource"), class$org$geotools$feature$FeatureType == null ? (class$org$geotools$feature$FeatureType = FeatureTypeInfo.class$("org.geotools.feature.FeatureType")) : class$org$geotools$feature$FeatureType, class$org$opengis$filter$Filter == null ? (class$org$opengis$filter$Filter = FeatureTypeInfo.class$("org.opengis.filter.Filter")) : class$org$opengis$filter$Filter, class$org$opengis$referencing$crs$CoordinateReferenceSystem == null ? (class$org$opengis$referencing$crs$CoordinateReferenceSystem = FeatureTypeInfo.class$("org.opengis.referencing.crs.CoordinateReferenceSystem")) : class$org$opengis$referencing$crs$CoordinateReferenceSystem, Integer.TYPE);
            return (FeatureSource)m.invoke(null, realSource, schema, this.getDefinitionQuery(), resultCrs, new Integer(localSrsHandling));
        }
        catch (Exception e) {
            throw new DataSourceException("Creation of a versioning wrapper failed", (Throwable)e);
        }
    }

    private FeatureSource getAliasedFeatureSource() throws IOException {
        DataStore dataStore = this.data.getDataStoreInfo(this.dataStoreId).getDataStore();
        FeatureSource fs = this.alias == null ? dataStore.getFeatureSource(this.typeName) : new RenamingDataStore(dataStore, this.typeName, this.alias).getFeatureSource(this.alias);
        return fs;
    }

    private boolean implementsInterface(Class clazz, String interfaceName) {
        if (clazz.getName().equals(interfaceName)) {
            return true;
        }
        Class<?>[] ifaces = clazz.getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            if (ifaces[i].getName().equals(interfaceName)) {
                return true;
            }
            if (!this.implementsInterface(ifaces[i], interfaceName)) continue;
            return true;
        }
        if (clazz.getSuperclass() == null) {
            return false;
        }
        return this.implementsInterface(clazz.getSuperclass(), interfaceName);
    }

    public Envelope getBoundingBox() throws IOException {
        CoordinateReferenceSystem crs;
        CoordinateReferenceSystem declaredCRS = this.getDeclaredCRS();
        CoordinateReferenceSystem nativeCRS = this.getNativeCRS();
        if (this.nativeBBox == null || this.nativeBBox.isNull()) {
            crs = this.srsHandling == LEAVE ? nativeCRS : declaredCRS;
            this.nativeBBox = this.getBoundingBox(crs);
        }
        if (!(this.nativeBBox instanceof ReferencedEnvelope)) {
            crs = this.srsHandling == LEAVE ? nativeCRS : declaredCRS;
            this.nativeBBox = new ReferencedEnvelope(this.nativeBBox, crs);
        }
        if (this.srsHandling == REPROJECT) {
            try {
                ReferencedEnvelope re = (ReferencedEnvelope)this.nativeBBox;
                this.nativeBBox = re.transform(declaredCRS, true);
            }
            catch (Exception e) {
                GlobalLayerSupertype.LOGGER.warning("Issues trying to transform native CRS");
            }
        }
        return this.nativeBBox;
    }

    private Envelope getBoundingBox(CoordinateReferenceSystem targetCrs) throws IOException {
        FeatureSource realSource = this.getAliasedFeatureSource();
        Envelope bbox = FeatureSourceUtils.getBoundingBoxEnvelope((FeatureSource)realSource);
        GeometryAttributeType defaultGeometry = realSource.getSchema().getDefaultGeometry();
        CoordinateReferenceSystem originalCRS = defaultGeometry.getCoordinateSystem();
        try {
            if (targetCrs != null && !CRS.equalsIgnoreMetadata((Object)originalCRS, (Object)targetCrs)) {
                MathTransform xform = CRS.findMathTransform((CoordinateReferenceSystem)originalCRS, (CoordinateReferenceSystem)targetCrs, (boolean)true);
                bbox = bbox instanceof ReferencedEnvelope ? ((ReferencedEnvelope)bbox).transform(targetCrs, true, 10) : new ReferencedEnvelope(JTS.transform((Envelope)bbox, null, (MathTransform)xform, (int)10), targetCrs);
            }
        }
        catch (Exception e) {
            GlobalLayerSupertype.LOGGER.severe("Could not turn the original envelope in one into the declared CRS for type " + this.getTypeName());
            GlobalLayerSupertype.LOGGER.severe("Original CRS is " + originalCRS);
            GlobalLayerSupertype.LOGGER.severe("Declared CRS is " + targetCrs);
        }
        return new ReferencedEnvelope(bbox, targetCrs);
    }

    public Filter getDefinitionQuery() {
        return this.definitionQuery;
    }

    public Envelope getLatLongBoundingBox() throws IOException {
        if (this.latLongBBox == null) {
            this.latLongBBox = this.getBoundingBox(this.getSRS(4326));
        }
        return this.latLongBBox;
    }

    public String getSRS() {
        return this.SRS + "";
    }

    public CoordinateReferenceSystem getDeclaredCRS() {
        return this.getSRS(this.SRS);
    }

    public CoordinateReferenceSystem getNativeCRS() throws IOException {
        GeometryAttributeType dg = this.getDefaultGeometry();
        if (dg == null) {
            return null;
        }
        return dg.getCoordinateSystem();
    }

    GeometryAttributeType getDefaultGeometry() throws IOException {
        if (this.getDataStoreInfo().getDataStore() == null) {
            throw new IOException("featureType: " + this.getName() + " does not have a properly configured " + "datastore");
        }
        FeatureSource realSource = this.getAliasedFeatureSource();
        return realSource.getSchema().getDefaultGeometry();
    }

    public boolean isGeometryless() throws IOException {
        return this.getDefaultGeometry() == null;
    }

    private synchronized FeatureTypeInfoDTO getGeneratedDTO() throws IOException {
        return DataTransferObjectFactory.create(this.dataStoreId, this.getFeatureType());
    }

    protected String getAttribute(Element elem, String attName, boolean mandatory) throws ConfigurationException {
        Attr att = elem.getAttributeNode(attName);
        String value = null;
        if (att != null) {
            value = att.getValue();
        }
        if (mandatory) {
            if (att == null) {
                throw new ConfigurationException("element " + elem.getNodeName() + " does not contains an attribute named " + attName);
            }
            if ("".equals(value)) {
                throw new ConfigurationException("attribute " + attName + "in element " + elem.getNodeName() + " is empty");
            }
        }
        return value;
    }

    private static Envelope getLatLongBBox(String fromSrId, Envelope bbox) {
        return bbox;
    }

    public String getAbstract() {
        return this._abstract;
    }

    public List getKeywords() {
        return this.keywords;
    }

    public List getMetadataLinks() {
        return this.metadataLinks;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSchemaName() {
        if (this.schemaName == null) {
            return this.getTypeName() + "_Type";
        }
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public String getSchemaBase() {
        return this.schemaBase;
    }

    public void setSchemaBase(String string) {
        this.schemaBase = string;
    }

    public String getTypeName() {
        return this.alias == null ? this.typeName : this.alias;
    }

    public String getNativeTypeName() {
        return this.typeName;
    }

    public FeatureType getFeatureType() throws IOException {
        return this.getFeatureType(this.getFeatureSource());
    }

    private FeatureType getFeatureType(FeatureSource fs) throws IOException {
        if (this.ft == null) {
            this.ft = fs.getSchema();
            URI namespace = this.ft.getNamespace();
            String[] baseNames = DataTransferObjectFactory.getRequiredBaseAttributes(this.schemaBase);
            AttributeType[] attributes = new AttributeType[this.schema.size() + baseNames.length];
            if (attributes.length > 0) {
                int count;
                int errors = 0;
                for (count = 0; count < baseNames.length; ++count) {
                    attributes[count - errors] = this.ft.getAttributeType(baseNames[count]);
                    if (attributes[count - errors] != null) continue;
                    ++errors;
                }
                if (errors != 0) {
                    AttributeType[] tmp = new AttributeType[attributes.length - errors];
                    count -= errors;
                    for (int i = 0; i < count; ++i) {
                        tmp[i] = attributes[i];
                    }
                    attributes = tmp;
                }
                Iterator i = this.schema.iterator();
                while (i.hasNext()) {
                    AttributeTypeInfo ati = (AttributeTypeInfo)i.next();
                    String attName = ati.getName();
                    attributes[count] = this.ft.getAttributeType(attName);
                    if ((class$com$vividsolutions$jts$geom$Geometry == null ? FeatureTypeInfo.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(attributes[count].getType())) {
                        GeometricAttributeType old = (GeometricAttributeType)attributes[count];
                        try {
                            if (old.getCoordinateSystem() == null) {
                                attributes[count] = new GeometricAttributeType(old, this.getSRS(this.SRS));
                                this.srsHandling = FORCE;
                            } else if (this.srsHandling == REPROJECT || this.srsHandling == FORCE) {
                                attributes[count] = new GeometricAttributeType(old, this.getSRS(this.SRS));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (attributes[count] == null) {
                        throw new IOException("the FeatureType " + this.getName() + " does not contains the configured attribute " + attName + ". Check your schema configuration");
                    }
                    ++count;
                }
                try {
                    this.ft = FeatureTypeFactory.newFeatureType((AttributeType[])attributes, (String)this.getTypeName(), (URI)namespace);
                }
                catch (SchemaException ex) {
                }
                catch (FactoryConfigurationError ex) {
                    // empty catch block
                }
            }
        }
        return this.ft;
    }

    public DataStoreInfo getDataStoreMetaData() {
        return this.data.getDataStoreInfo(this.dataStoreId);
    }

    public List getAttributeNames() {
        List attribs = this.schema;
        if (attribs.size() != 0) {
            ArrayList<String> list = new ArrayList<String>(attribs.size());
            Iterator i = attribs.iterator();
            while (i.hasNext()) {
                AttributeTypeInfo at = (AttributeTypeInfo)i.next();
                list.add(at.getName());
            }
            return list;
        }
        ArrayList<String> list = new ArrayList<String>();
        try {
            FeatureType ftype = this.getFeatureType();
            AttributeType[] types = ftype.getAttributeTypes();
            list = new ArrayList(types.length);
            for (int i = 0; i < types.length; ++i) {
                list.add(types[i].getName());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    public List getAttributes() {
        return this.schema;
    }

    public synchronized AttributeTypeInfo AttributeTypeMetaData(String attributeName) {
        AttributeTypeInfo info = null;
        if (this.schema != null) {
            Iterator i = this.schema.iterator();
            while (i.hasNext()) {
                AttributeTypeInfoDTO dto = (AttributeTypeInfoDTO)i.next();
                info = new AttributeTypeInfo(dto);
            }
            DataStore dataStore = this.data.getDataStoreInfo(this.dataStoreId).getDataStore();
            try {
                FeatureType ftype = dataStore.getSchema(this.typeName);
                info.sync(ftype.getAttributeType(attributeName));
            }
            catch (IOException e) {}
        } else {
            DataStore dataStore = this.data.getDataStoreInfo(this.dataStoreId).getDataStore();
            try {
                FeatureType ftype = dataStore.getSchema(this.typeName);
                info = new AttributeTypeInfo(ftype.getAttributeType(attributeName));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return info;
    }

    public boolean containsMetaData(String key) {
        return this.meta.containsKey(key);
    }

    public void putMetaData(String key, Object value) {
        this.meta.put(key, value);
    }

    public Object getMetaData(String key) {
        return this.meta.get(key);
    }

    public LegendURL getLegendURL() {
        return this.legendURL;
    }

    public File getSchemaFile() {
        return this.schemaFile;
    }

    private CoordinateReferenceSystem getSRS(int epsg) {
        CoordinateReferenceSystem result = (CoordinateReferenceSystem)SRSLookup.get(new Integer(epsg));
        if (result == null) {
            try {
                result = CRS.decode((String)("EPSG:" + epsg));
                SRSLookup.put(new Integer(epsg), result);
            }
            catch (NoSuchAuthorityCodeException e) {
                String msg = "Error looking up SRS for EPSG: " + epsg + ":" + e.getLocalizedMessage();
                GlobalLayerSupertype.LOGGER.warning(msg);
            }
            catch (FactoryException e) {
                String msg = "Error looking up SRS for EPSG: " + epsg + ":" + e.getLocalizedMessage();
                GlobalLayerSupertype.LOGGER.warning(msg);
            }
        }
        return result;
    }

    public String getDirName() {
        return this.dirName;
    }

    public String getWmsPath() {
        return this.wmsPath;
    }

    public void setWmsPath(String wmsPath) {
        this.wmsPath = wmsPath;
    }

    public String getCacheMaxAge() {
        return this.cacheMaxAge;
    }

    public void setCacheMaxAge(String cacheMaxAge) {
        this.cacheMaxAge = cacheMaxAge;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public void setMaxFeatures(int maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class RenamingDataStore
    extends RetypingDataStore {
        private String name;
        private String renameTo;

        public RenamingDataStore(DataStore wrapped, String typeName, String alias) throws IOException {
            this.name = typeName;
            this.renameTo = alias;
            this.init(wrapped);
        }

        protected String transformFeatureTypeName(String originalName) {
            if (!this.name.equals(originalName)) {
                return originalName;
            }
            return this.renameTo;
        }
    }
}

