/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotools.data.DataStore;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.dto.DataStoreInfoDTO;
import org.vfny.geoserver.util.DataStoreUtils;

public class DataStoreInfo
extends GlobalLayerSupertype {
    private DataStore dataStore = null;
    private Data data;
    private String id;
    private String nameSpaceId;
    private boolean enabled;
    private String title;
    private String _abstract;
    private Map connectionParams;
    private Map meta;
    File baseDir;
    URL baseURL;

    public DataStoreInfo(DataStoreInfoDTO config, Data data) {
        this.data = data;
        this.meta = new HashMap();
        this.connectionParams = config.getConnectionParams();
        this.enabled = config.isEnabled();
        this.id = config.getId();
        this.nameSpaceId = config.getNameSpaceId();
        this.title = config.getTitle();
        this._abstract = config.getAbstract();
    }

    Object toDTO() {
        DataStoreInfoDTO dto = new DataStoreInfoDTO();
        dto.setAbstract(this._abstract);
        dto.setConnectionParams(this.connectionParams);
        dto.setEnabled(this.enabled);
        dto.setId(this.id);
        dto.setNameSpaceId(this.nameSpaceId);
        dto.setTitle(this.title);
        return dto;
    }

    public String getId() {
        return this.id;
    }

    protected Map getParams() {
        HashMap<String, String> params = new HashMap<String, String>(this.connectionParams);
        params.put("namespace", this.getNameSpace().getURI());
        return DataStoreInfo.getParams(params, this.data.getBaseDir().toString());
    }

    public static Map getParams(Map m, String baseDir) {
        Map params = Collections.synchronizedMap(new HashMap(m));
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                if (key != null && key.matches(".* *url") && value instanceof String) {
                    String path = (String)value;
                    GlobalLayerSupertype.LOGGER.finer("in string url");
                    if (!path.startsWith("file:")) continue;
                    File fixedPath = GeoserverDataDirectory.findDataFile(path);
                    entry.setValue(fixedPath.toURL().toExternalForm());
                    continue;
                }
                if (!(value instanceof URL) || !((URL)value).getProtocol().equals("file")) continue;
                File fixedPath = GeoserverDataDirectory.findDataFile((URL)value);
                entry.setValue(fixedPath.toURL());
            }
            catch (MalformedURLException ignore) {}
        }
        return params;
    }

    public synchronized DataStore getDataStore() throws IllegalStateException, NoSuchElementException {
        if (!this.isEnabled()) {
            throw new IllegalStateException("this datastore is not enabled, check your configuration");
        }
        if (this.dataStore == null) {
            Map m = this.getParams();
            try {
                this.dataStore = DataStoreUtils.getDataStore(m);
                GlobalLayerSupertype.LOGGER.fine("connection established by " + this.toString());
            }
            catch (Throwable ex) {
                throw new IllegalStateException("can't create the datastore " + this.getId() + ": " + ex.getClass().getName() + ": " + ex.getMessage() + "\n" + ex.toString());
            }
            if (this.dataStore == null) {
                this.enabled = false;
                GlobalLayerSupertype.LOGGER.fine("failed to establish connection with " + this.toString());
                throw new NoSuchElementException("No datastore found capable of managing " + this.toString());
            }
        }
        return this.dataStore;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAbstract() {
        return this._abstract;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public NameSpaceInfo getNameSpace() {
        return this.data.getNameSpace(this.getNamesSpacePrefix());
    }

    public String getNamesSpacePrefix() {
        return this.nameSpaceId;
    }

    public String toString() {
        return "DataStoreConfig[namespace=" + this.getNameSpace().getPrefix() + ", enabled=" + this.isEnabled() + ", abstract=" + this.getAbstract() + ", connection parameters=" + this.getParams() + "]";
    }

    public boolean containsMetaData(String key) {
        return this.meta.containsKey(key);
    }

    public void putMetaData(String key, Object value) {
        this.meta.put(key, value);
    }

    public Object getMetaData(String key) {
        return this.meta.get(key);
    }

    public void dispose() {
        if (this.dataStore != null) {
            this.dataStore.dispose();
        }
    }
}

