/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.awt.Rectangle;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.resources.CRSUtilities;
import org.geotools.styling.Style;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.CoverageDimension;
import org.vfny.geoserver.global.CoverageStoreInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.dto.CoverageInfoDTO;
import org.vfny.geoserver.util.CoverageStoreUtils;
import org.vfny.geoserver.util.CoverageUtils;

public final class CoverageInfo
extends GlobalLayerSupertype {
    private String formatId;
    private String name;
    private String wmsPath;
    private String label;
    private String description;
    private MetaDataLink metadataLink;
    private String dirName;
    private List keywords;
    private GeneralEnvelope envelope;
    private GeneralEnvelope lonLatWGS84Envelope;
    private GridGeometry grid;
    private CoverageDimension[] dimensions;
    private InternationalString[] dimensionNames;
    private List requestCRSs;
    private List responseCRSs;
    private String nativeFormat;
    private List supportedFormats;
    private String defaultInterpolationMethod;
    private List interpolationMethods;
    private Data data;
    private Map meta;
    private String srsName;
    private String srsWKT;
    private CoordinateReferenceSystem crs;
    private String defaultStyle;
    private ArrayList styles;
    private Map parameters;

    public CoverageInfo(CoverageInfoDTO dto, Data data) throws ConfigurationException {
        this.data = data;
        this.formatId = dto.getFormatId();
        this.name = dto.getName();
        this.wmsPath = dto.getWmsPath();
        this.label = dto.getLabel();
        this.description = dto.getDescription();
        this.metadataLink = dto.getMetadataLink();
        this.dirName = dto.getDirName();
        this.keywords = dto.getKeywords();
        this.crs = dto.getCrs();
        this.srsName = dto.getSrsName();
        this.srsWKT = dto.getSrsWKT();
        this.envelope = dto.getEnvelope();
        this.lonLatWGS84Envelope = dto.getLonLatWGS84Envelope();
        this.grid = dto.getGrid();
        this.dimensions = dto.getDimensions();
        this.dimensionNames = dto.getDimensionNames();
        this.requestCRSs = dto.getRequestCRSs();
        this.responseCRSs = dto.getResponseCRSs();
        this.nativeFormat = dto.getNativeFormat();
        this.supportedFormats = dto.getSupportedFormats();
        this.defaultInterpolationMethod = dto.getDefaultInterpolationMethod();
        this.interpolationMethods = dto.getInterpolationMethods();
        this.defaultStyle = dto.getDefaultStyle();
        this.styles = dto.getStyles();
        this.parameters = dto.getParameters();
    }

    Object toDTO() {
        CoverageInfoDTO dto = new CoverageInfoDTO();
        dto.setFormatId(this.formatId);
        dto.setName(this.name);
        dto.setWmsPath(this.wmsPath);
        dto.setLabel(this.label);
        dto.setDescription(this.description);
        dto.setMetadataLink(this.metadataLink);
        dto.setDirName(this.dirName);
        dto.setKeywords(this.keywords);
        dto.setCrs(this.crs);
        dto.setSrsName(this.srsName);
        dto.setSrsWKT(this.srsWKT);
        dto.setEnvelope(this.envelope);
        dto.setLonLatWGS84Envelope(this.lonLatWGS84Envelope);
        dto.setGrid(this.grid);
        dto.setDimensions(this.dimensions);
        dto.setDimensionNames(this.dimensionNames);
        dto.setRequestCRSs(this.requestCRSs);
        dto.setResponseCRSs(this.responseCRSs);
        dto.setNativeFormat(this.nativeFormat);
        dto.setSupportedFormats(this.supportedFormats);
        dto.setDefaultInterpolationMethod(this.defaultInterpolationMethod);
        dto.setInterpolationMethods(this.interpolationMethods);
        dto.setDefaultStyle(this.defaultStyle);
        dto.setStyles(this.styles);
        dto.setParameters(this.parameters);
        return dto;
    }

    public CoverageStoreInfo getFormatInfo() {
        return this.data.getFormatInfo(this.formatId);
    }

    public boolean isEnabled() {
        return this.getFormatInfo() != null && this.getFormatInfo().isEnabled();
    }

    public CoverageStoreInfo getFormatMetaData() {
        return this.data.getFormatInfo(this.formatId);
    }

    public boolean containsMetaData(String key) {
        return this.meta.containsKey(key);
    }

    public void putMetaData(String key, Object value) {
        this.meta.put(key, value);
    }

    public Object getMetaData(String key) {
        return this.meta.get(key);
    }

    public Data getData() {
        return this.data;
    }

    public String getDefaultInterpolationMethod() {
        return this.defaultInterpolationMethod;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDirName() {
        return this.dirName;
    }

    public GeneralEnvelope getEnvelope() {
        return this.envelope;
    }

    public String getFormatId() {
        return this.formatId;
    }

    public List getInterpolationMethods() {
        return this.interpolationMethods;
    }

    public List getKeywords() {
        return this.keywords;
    }

    public String getLabel() {
        return this.label;
    }

    public Map getMeta() {
        return this.meta;
    }

    public MetaDataLink getMetadataLink() {
        return this.metadataLink;
    }

    public String getPrefix() {
        CoverageStoreInfo info = this.getFormatInfo();
        if (info != null) {
            return info.getNameSpace().getPrefix();
        }
        return null;
    }

    public NameSpaceInfo getNameSpace() {
        if (!this.isEnabled()) {
            throw new IllegalStateException("This coverage is not enabled");
        }
        return this.getFormatInfo().getNameSpace();
    }

    public String getName() {
        return this.getPrefix() + ":" + this.name;
    }

    public String getNativeFormat() {
        return this.nativeFormat;
    }

    public List getRequestCRSs() {
        return this.requestCRSs;
    }

    public List getResponseCRSs() {
        return this.responseCRSs;
    }

    public String getSrsName() {
        return this.srsName;
    }

    public List getSupportedFormats() {
        return this.supportedFormats;
    }

    public Style getDefaultStyle() {
        return this.data.getStyle(this.defaultStyle);
    }

    public ArrayList getStyles() {
        ArrayList<Style> realStyles = new ArrayList<Style>();
        Iterator s_IT = ((AbstractList)this.styles).iterator();
        while (s_IT.hasNext()) {
            realStyles.add(this.data.getStyle((String)s_IT.next()));
        }
        return realStyles;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public GridGeometry getGrid() {
        return this.grid;
    }

    public InternationalString[] getDimensionNames() {
        return this.dimensionNames;
    }

    public CoverageDimension[] getDimensions() {
        return this.dimensions;
    }

    public String getSrsWKT() {
        return this.srsWKT;
    }

    public GeneralEnvelope getWGS84LonLatEnvelope() {
        if (this.lonLatWGS84Envelope == null) {
            try {
                this.lonLatWGS84Envelope = CoverageStoreUtils.getWGS84LonLatEnvelope(this.envelope);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            catch (FactoryException e) {
                return null;
            }
            catch (TransformException e) {
                return null;
            }
        }
        return this.lonLatWGS84Envelope;
    }

    public String getWmsPath() {
        return this.wmsPath;
    }

    public void setWmsPath(String wmsPath) {
        this.wmsPath = wmsPath;
    }

    public GridCoverageReader getReader() {
        return this.data.getFormatInfo(this.formatId).getReader();
    }

    public GridCoverageReader createReader(Hints hints) {
        return this.data.getFormatInfo(this.formatId).createReader(hints);
    }

    public Map getParameters() {
        return this.parameters;
    }

    public GridCoverage getCoverage() {
        return this.getCoverage(null, null);
    }

    public GridCoverage getCoverage(GeneralEnvelope envelope, Rectangle dim) {
        GridCoverage gc = null;
        try {
            MathTransform transform;
            CoordinateReferenceSystem destCRS;
            CoordinateReferenceSystem sourceCRS;
            if (envelope == null) {
                envelope = this.envelope;
            }
            if (!CRSUtilities.equalsIgnoreMetadata((Object)(sourceCRS = envelope.getCoordinateReferenceSystem()), (Object)(destCRS = this.crs)) && !(transform = CoverageUtils.getMathTransform(sourceCRS, destCRS)).isIdentity()) {
                envelope = CRSUtilities.transform((MathTransform)transform, (Envelope)envelope);
            }
            envelope.intersect((Envelope)this.envelope);
            if (envelope.isEmpty()) {
                return null;
            }
            envelope.setCoordinateReferenceSystem(destCRS);
            GridCoverageReader reader = this.getReader();
            if (reader == null) {
                return null;
            }
            gc = reader.read(CoverageUtils.getParameters(this.getReader().getFormat().getReadParameters(), this.getParameters()));
            if (gc == null || !(gc instanceof GridCoverage2D)) {
                throw new IOException("The requested coverage could not be found.");
            }
        }
        catch (InvalidParameterValueException e) {
            GlobalLayerSupertype.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (ParameterNotFoundException e) {
            GlobalLayerSupertype.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (MalformedURLException e) {
            GlobalLayerSupertype.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (IllegalArgumentException e) {
            GlobalLayerSupertype.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (SecurityException e) {
            GlobalLayerSupertype.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            GlobalLayerSupertype.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (TransformException e) {
            GlobalLayerSupertype.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return gc;
    }
}

