/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import com.sun.media.jai.util.SunTileCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.RecyclingTileFactory;
import javax.servlet.ServletContext;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.geotools.data.DataUtilities;
import org.geotools.util.Logging;
import org.springframework.beans.factory.DisposableBean;
import org.vfny.geoserver.global.Config;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.dto.ContactDTO;
import org.vfny.geoserver.global.dto.GeoServerDTO;

public class GeoServer
extends GlobalLayerSupertype
implements DisposableBean {
    public static final String WEB_CONTAINER_KEY = "GeoServer";
    private String title;
    private int maxFeatures = Integer.MAX_VALUE;
    private boolean verbose = true;
    private int numDecimals = 4;
    private Charset charSet = Charset.forName("UTF-8");
    private final JAI jaiDef = JAI.getDefaultInstance();
    private SunTileCache jaiCache;
    private String adminUserName = "admin";
    private String adminPassword;
    private String schemaBaseUrl;
    private String proxyBaseUrl;
    private String contactPerson;
    private String contactOrganization;
    private String contactPosition;
    private String addressType;
    private String address;
    private String addressCity;
    private String addressState;
    private String addressPostalCode;
    private String addressCountry;
    private String contactVoice;
    private String contactFacsimile;
    private String contactEmail;
    private String onlineResource;
    private double memoryCapacity;
    private double memoryThreshold;
    private int tileThreads;
    private int tilePriority;
    private String tileCache;
    private Boolean recycling;
    private Boolean imageIOCache;
    private Boolean JPEGnativeAcc;
    private Boolean PNGnativeAcc;
    private boolean verboseExceptions = false;
    private String log4jConfigFile;
    private boolean suppressStdOutLogging = false;
    private String logLocation = null;
    private static Logging[] GEOSERVER_LOGGING;

    public GeoServer() {
    }

    public GeoServer(Config config) throws ConfigurationException {
        GlobalLayerSupertype.LOGGER.fine("Creating GeoServer");
        this.load(config.getXMLReader().getGeoServer());
    }

    public String getAddress() {
        return this.notNull(this.address);
    }

    public String getAddressCity() {
        return this.notNull(this.addressCity);
    }

    public String getAddressCountry() {
        return this.notNull(this.addressCountry);
    }

    public String getAddressPostalCode() {
        return this.notNull(this.addressPostalCode);
    }

    public String getAddressState() {
        return this.notNull(this.addressState);
    }

    public String getAddressType() {
        return this.notNull(this.addressType);
    }

    public Charset getCharSet() {
        if (this.charSet != null) {
            return this.charSet;
        }
        return Charset.forName("UTF-8");
    }

    public String getContactEmail() {
        return this.notNull(this.contactEmail);
    }

    public String getContactFacsimile() {
        return this.notNull(this.contactFacsimile);
    }

    public String getContactOrganization() {
        return this.notNull(this.contactOrganization);
    }

    public String getContactPerson() {
        return this.notNull(this.contactPerson);
    }

    public String getContactPosition() {
        return this.notNull(this.contactPosition);
    }

    public String getContactVoice() {
        return this.notNull(this.contactVoice);
    }

    public String getOnlineResource() {
        return this.notNull(this.onlineResource);
    }

    public String getLog4jConfigFile() {
        return this.log4jConfigFile;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public String getMimeType() {
        return "text/xml; charset=" + this.getCharSet().name();
    }

    public int getNumDecimals() {
        return this.numDecimals;
    }

    public String getSchemaBaseUrl() {
        return this.schemaBaseUrl;
    }

    public String getProxyBaseUrl() {
        return this.proxyBaseUrl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void load(GeoServerDTO dto) throws ConfigurationException {
        if (dto != null) {
            this.address = dto.getContact().getAddress();
            this.addressCity = dto.getContact().getAddressCity();
            this.addressCountry = dto.getContact().getAddressCountry();
            this.addressPostalCode = dto.getContact().getAddressPostalCode();
            this.addressState = dto.getContact().getAddressState();
            this.addressType = dto.getContact().getAddressType();
            this.charSet = dto.getCharSet();
            this.contactEmail = dto.getContact().getContactEmail();
            this.contactFacsimile = dto.getContact().getContactFacsimile();
            this.contactOrganization = dto.getContact().getContactOrganization();
            this.contactPerson = dto.getContact().getContactPerson();
            this.contactPosition = dto.getContact().getContactPosition();
            this.contactVoice = dto.getContact().getContactVoice();
            this.log4jConfigFile = dto.getLog4jConfigFile();
            this.suppressStdOutLogging = dto.getSuppressStdOutLogging();
            this.logLocation = dto.getLogLocation();
            try {
                GeoServer.configureGeoServerLogging(this.log4jConfigFile, this.suppressStdOutLogging, this.logLocation);
            }
            catch (IOException ioe) {
                if (GlobalLayerSupertype.LOGGER.isLoggable(Level.FINE)) {
                    GlobalLayerSupertype.LOGGER.log(Level.FINE, "", ioe);
                }
                throw new ConfigurationException("", ioe);
            }
        } else {
            throw new ConfigurationException("load(GeoServerDTO) expected a non-null value");
        }
        this.memoryCapacity = dto.getJaiMemoryCapacity();
        this.memoryThreshold = dto.getJaiMemoryThreshold();
        this.tileThreads = dto.getJaiTileThreads();
        this.tilePriority = dto.getJaiTilePriority();
        this.tileCache = dto.getTileCache();
        this.recycling = dto.getJaiRecycling();
        this.imageIOCache = dto.getImageIOCache();
        this.JPEGnativeAcc = dto.getJaiJPEGNative();
        this.PNGnativeAcc = dto.getJaiPNGNative();
        this.initJAI(this.memoryCapacity, this.memoryThreshold, this.recycling, this.imageIOCache);
        this.maxFeatures = dto.getMaxFeatures();
        this.numDecimals = dto.getNumDecimals();
        this.onlineResource = dto.getContact().getOnlineResource();
        this.schemaBaseUrl = dto.getSchemaBaseUrl();
        this.proxyBaseUrl = dto.getProxyBaseUrl();
        this.verbose = dto.isVerbose();
        this.adminUserName = dto.getAdminUserName();
        this.adminPassword = dto.getAdminPassword();
        this.verboseExceptions = dto.isVerboseExceptions();
    }

    public final void load(GeoServerDTO dto, ServletContext context) throws ConfigurationException {
        this.load(dto);
    }

    public static File getLogLocation(String logLocation) throws IOException {
        File f = new File(logLocation);
        if (f.exists()) {
            if (f.isDirectory()) {
                if (!logLocation.endsWith(File.separator)) {
                    logLocation = logLocation + File.separator;
                }
                logLocation = logLocation + "geoserver.log";
            }
        } else {
            if (!f.isAbsolute()) {
                File data = GeoserverDataDirectory.getGeoserverDataDirectory();
                f = new File(data, f.getPath());
            }
            if (f.getParentFile() != null && !f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            f.createNewFile();
        }
        return f;
    }

    public static boolean isGeoserverControllingLogging() {
        URL clurl = Thread.currentThread().getContextClassLoader().getResource("commons-logging.properties");
        if (clurl == null) {
            GlobalLayerSupertype.LOGGER.warning("No 'commons-logging.properties' found on GeoServer's classpath.  GeoServer");
            return false;
        }
        File clfile = new File(clurl.getFile());
        Properties clprops = new Properties();
        try {
            clprops.load(new FileInputStream(clfile));
            if (((Hashtable)clprops).get("org.apache.commons.logging.Log") == null) {
                GlobalLayerSupertype.LOGGER.warning("No 'org.apache.commons.logging.Log' property found in commons-logging.");
                return false;
            }
            String loggingSystem = (String)((Hashtable)clprops).get("org.apache.commons.logging.Log");
            if (loggingSystem.indexOf("Log4JLogger") == -1) {
                GlobalLayerSupertype.LOGGER.warning("Non Log4JLogger commons-logging.properties detected: " + loggingSystem);
                return false;
            }
            return true;
        }
        catch (IOException ioe) {
            GlobalLayerSupertype.LOGGER.warning("Error figuring out GeoServer logging configuration: " + ioe);
            if (GlobalLayerSupertype.LOGGER.isLoggable(Level.FINE)) {
                GlobalLayerSupertype.LOGGER.log(Level.FINE, "", ioe);
            }
            return false;
        }
    }

    public static void configureGeoServerLogging(String log4jConfigFileStr, boolean suppressStdOutLogging, String logFileName) throws IOException, ConfigurationException {
        File log4jConfigFile;
        GlobalLayerSupertype.LOGGER.fine("CONFIGURING GEOSERVER LOGGING -------------------------");
        if (!GeoServer.isGeoserverControllingLogging()) {
            GlobalLayerSupertype.LOGGER.warning("GeoServer isn't controlling the logging system.");
            return;
        }
        if (log4jConfigFileStr == null) {
            log4jConfigFileStr = "DEFAULT_LOGGING.properties";
            GlobalLayerSupertype.LOGGER.warning("No log4jConfigFile defined in services.xml:  using 'DEFAULT_LOGGING.properties'");
        }
        if ((log4jConfigFile = GeoserverDataDirectory.findConfigFile("logs" + File.separator + log4jConfigFileStr)) == null) {
            GlobalLayerSupertype.LOGGER.warning("log4jConfigFile '" + log4jConfigFileStr + "' couldn't be found in the data dir, so GeoServer will " + "install the various logging config file into the data dir, and then try to find it again.");
            File lcdir = GeoserverDataDirectory.findCreateConfigDir("logs");
            String[] lcfiles = new String[]{"DEFAULT_LOGGING.properties", "VERBOSE_LOGGING.properties", "PRODUCTION_LOGGING.properties", "GEOTOOLS_DEVELOPER_LOGGING.properties", "GEOSERVER_DEVELOPER_LOGGING.properties"};
            for (int i = 0; i < lcfiles.length; ++i) {
                File target = new File(lcdir.getAbsolutePath() + File.separator + lcfiles[i]);
                if (target.exists()) continue;
                URL logConfFile = Thread.currentThread().getContextClassLoader().getResource(lcfiles[i]);
                try {
                    GeoServer.copyFile(DataUtilities.urlToFile((URL)logConfFile), target);
                    continue;
                }
                catch (Exception e) {
                    GlobalLayerSupertype.LOGGER.log(Level.FINE, "Couldn't copy log configuration files into your data dir.  Geoserver won't control logging.", e);
                    return;
                }
            }
            log4jConfigFile = GeoserverDataDirectory.findConfigFile("logs" + File.separator + log4jConfigFileStr);
            if (log4jConfigFile == null) {
                GlobalLayerSupertype.LOGGER.warning("Still couldn't find log4jConfigFile '" + log4jConfigFileStr + "'.  Using DEFAULT_LOGGING.properties instead.");
            }
            log4jConfigFile = GeoserverDataDirectory.findConfigFile("logs" + File.separator + "DEFAULT_LOGGING.properties");
        }
        if (log4jConfigFile == null) {
            throw new ConfigurationException("Unable to load logging configuration '" + log4jConfigFileStr + "'.  In addition, an attempt " + "was made to create the 'logs' directory in your data dir, and to use the DEFAULT_LOGGING configuration, but" + "this failed as well.  Is your data dir writeable?");
        }
        FileInputStream loggingConfigStream = new FileInputStream(log4jConfigFile);
        if (loggingConfigStream == null) {
            GlobalLayerSupertype.LOGGER.warning("Couldn't find Log4J configuration file '" + log4jConfigFileStr + "' in the 'loggingConfigs' directory.");
            return;
        }
        GlobalLayerSupertype.LOGGER.fine("GeoServer logging profile '" + log4jConfigFile.getName() + "' enabled.");
        Properties lprops = new Properties();
        lprops.load(loggingConfigStream);
        List sortedCategories = GeoServer.getSortedLog4JCategories(lprops);
        GlobalLayerSupertype.LOGGER.fine("sorted log4j categories: " + sortedCategories);
        Iterator i = sortedCategories.iterator();
        while (i.hasNext()) {
            String curCategory = (String)i.next();
            String logLevel = lprops.getProperty("log4j.category." + curCategory);
            Logger.getLogger(curCategory).setLevel(GeoServer.log4JLevelToJDKLoggingLevel(logLevel));
            GlobalLayerSupertype.LOGGER.fine("set logger '" + curCategory + "' to level '" + GeoServer.log4JLevelToJDKLoggingLevel(logLevel).getLocalizedName() + "' (from log4j string " + logLevel);
        }
        Enumeration<String> names = java.util.logging.LogManager.getLogManager().getLoggerNames();
        while (names.hasMoreElements()) {
            String curLName = names.nextElement();
            Iterator iCats = sortedCategories.iterator();
            while (iCats.hasNext()) {
                String curCat = (String)iCats.next();
                if (!curLName.startsWith(curCat)) continue;
                String logLevel = lprops.getProperty("log4j.category." + curCat);
                Logger.getLogger(curLName).setLevel(GeoServer.log4JLevelToJDKLoggingLevel(logLevel));
                GlobalLayerSupertype.LOGGER.fine("set java logger '" + curLName + "' to level '" + GeoServer.log4JLevelToJDKLoggingLevel(logLevel).getLocalizedName() + "', figured from log4j level '" + logLevel + "'");
            }
        }
        Appender gslf = org.apache.log4j.Logger.getRootLogger().getAppender("geoserverlogfile");
        if (gslf != null) {
            LogManager.getRootLogger().removeAppender(gslf);
        }
        org.apache.log4j.Logger.getLogger((String)"org.geotools").getLoggerRepository().resetConfiguration();
        org.apache.log4j.Logger.getLogger((String)"org.geoserver").getLoggerRepository().resetConfiguration();
        org.apache.log4j.Logger.getLogger((String)"org.vfny").getLoggerRepository().resetConfiguration();
        PropertyConfigurator.configure((Properties)lprops);
        gslf = org.apache.log4j.Logger.getRootLogger().getAppender("geoserverlogfile");
        if (gslf instanceof RollingFileAppender) {
            if (logFileName == null) {
                logFileName = GeoserverDataDirectory.getGeoserverDataDirectory().getAbsolutePath() + File.separator + "logs" + File.separator + "geoserver.log";
            } else if (!new File(logFileName).isAbsolute()) {
                logFileName = GeoserverDataDirectory.getGeoserverDataDirectory().getAbsolutePath() + File.separator + logFileName;
                GlobalLayerSupertype.LOGGER.fine("Non-absolute pathname detected for logfile.  Setting logfile relative to data dir.");
            }
            lprops.setProperty("log4j.appender.geoserverlogfile.File", logFileName);
            PropertyConfigurator.configure((Properties)lprops);
            GlobalLayerSupertype.LOGGER.fine("Logging output to file '" + logFileName + "'");
        } else if (gslf != null) {
            GlobalLayerSupertype.LOGGER.warning("'log4j.appender.geoserverlogfile' appender is defined, but isn't a RollingFileAppender.  GeoServer won't control the file-based logging.");
        } else {
            GlobalLayerSupertype.LOGGER.warning("'log4j.appender.geoserverlogfile' appender isn't defined.  GeoServer won't control the file-based logging.");
        }
        if (suppressStdOutLogging) {
            GlobalLayerSupertype.LOGGER.warning("Suppressing StdOut logging.  If you want to see GeoServer logs, be sure to look in '" + logFileName + "'");
            Enumeration allAppenders = org.apache.log4j.Logger.getRootLogger().getAllAppenders();
            while (allAppenders.hasMoreElements()) {
                Appender curApp = (Appender)allAppenders.nextElement();
                if (!(curApp instanceof ConsoleAppender)) continue;
                org.apache.log4j.Logger.getRootLogger().removeAppender(curApp);
            }
        } else {
            GlobalLayerSupertype.LOGGER.info("StdOut logging enabled.  Log file also output to '" + logFileName + "'");
        }
        GlobalLayerSupertype.LOGGER.fine("FINISHED CONFIGURING GEOSERVER LOGGING -------------------------");
    }

    private static Level log4JLevelToJDKLoggingLevel(String log4jLevel) {
        if (log4jLevel.equalsIgnoreCase("DEBUG")) {
            return Level.FINER;
        }
        if (log4jLevel.equalsIgnoreCase("INFO")) {
            return Level.CONFIG;
        }
        if (log4jLevel.equalsIgnoreCase("WARN")) {
            return Level.WARNING;
        }
        if (log4jLevel.equalsIgnoreCase("ERROR")) {
            return Level.SEVERE;
        }
        GlobalLayerSupertype.LOGGER.warning("Can't figure out what sort of Log4j log level '" + log4jLevel + "' is.");
        return Level.ALL;
    }

    private static List getSortedLog4JCategories(Properties log4jProps) {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator iCats = ((Hashtable)log4jProps).keySet().iterator();
        while (iCats.hasNext()) {
            String curCat = (String)iCats.next();
            if (!curCat.startsWith("log4j.category.")) continue;
            ret.add(curCat.substring("log4j.category.".length()));
        }
        Collections.sort(ret, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                int numDots2;
                String s1 = (String)arg0;
                String s2 = (String)arg1;
                int numDots1 = new StringTokenizer(s1, ".").countTokens();
                if (numDots1 > (numDots2 = new StringTokenizer(s2, ".").countTokens())) {
                    return -1;
                }
                if (numDots1 < numDots2) {
                    return 1;
                }
                return 0;
            }
        });
        return ret;
    }

    private static void copyFile(File source, File target) throws IOException {
        FileChannel sourceChannel = new FileInputStream(source).getChannel();
        FileChannel targetChannel = new FileOutputStream(target).getChannel();
        targetChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
        sourceChannel.close();
        targetChannel.close();
    }

    public void initJAI(double memCapacity, double memoryThreshold, Boolean recycling, Boolean ImageIOCache) {
        this.jaiDef.setRenderingHint(JAI.KEY_CACHED_TILE_RECYCLING_ENABLED, (Object)recycling);
        RecyclingTileFactory recyclingFactory = new RecyclingTileFactory();
        this.jaiDef.setRenderingHint(JAI.KEY_TILE_FACTORY, (Object)recyclingFactory);
        this.jaiDef.setRenderingHint(JAI.KEY_TILE_RECYCLER, (Object)recyclingFactory);
        this.jaiCache = (SunTileCache)this.jaiDef.getTileCache();
        long jaiMemory = (long)(memCapacity * (double)Runtime.getRuntime().maxMemory());
        this.jaiCache.setMemoryCapacity(jaiMemory);
        this.jaiCache.setMemoryThreshold((float)memoryThreshold);
        this.jaiDef.getTileScheduler().setParallelism(this.tileThreads);
        this.jaiDef.getTileScheduler().setPrefetchParallelism(this.tileThreads);
        this.jaiDef.getTileScheduler().setPriority(this.tilePriority);
        this.jaiDef.getTileScheduler().setPrefetchPriority(this.tilePriority);
        ImageIO.setUseCache(ImageIOCache);
    }

    public Object toDTO() {
        GeoServerDTO dto = new GeoServerDTO();
        dto.setCharSet(this.charSet);
        dto.setLog4jConfigFile(this.log4jConfigFile);
        dto.setMaxFeatures(this.maxFeatures);
        dto.setNumDecimals(this.numDecimals);
        dto.setSchemaBaseUrl(this.schemaBaseUrl);
        dto.setProxyBaseUrl(this.proxyBaseUrl);
        dto.setVerbose(this.verbose);
        dto.setAdminUserName(this.adminUserName);
        dto.setAdminPassword(this.adminPassword);
        dto.setVerboseExceptions(this.verboseExceptions);
        dto.setSuppressStdOutLogging(this.suppressStdOutLogging);
        dto.setLogLocation(this.logLocation);
        dto.setJaiMemoryCapacity(this.memoryCapacity);
        dto.setJaiMemoryThreshold(this.memoryThreshold);
        dto.setJaiTileThreads(this.tileThreads);
        dto.setJaiTilePriority(this.tilePriority);
        dto.setTileCache(this.tileCache);
        dto.setJaiRecycling(this.recycling);
        dto.setImageIOCache(this.imageIOCache);
        dto.setJaiJPEGNative(this.JPEGnativeAcc);
        dto.setJaiPNGNative(this.PNGnativeAcc);
        ContactDTO cdto = new ContactDTO();
        dto.setContact(cdto);
        cdto.setAddress(this.address);
        cdto.setAddressCity(this.addressCity);
        cdto.setAddressCountry(this.addressCountry);
        cdto.setAddressPostalCode(this.addressPostalCode);
        cdto.setAddressState(this.addressState);
        cdto.setAddressType(this.addressType);
        cdto.setContactEmail(this.contactEmail);
        cdto.setContactFacsimile(this.contactFacsimile);
        cdto.setContactOrganization(this.contactOrganization);
        cdto.setContactPerson(this.contactPerson);
        cdto.setContactPosition(this.contactPosition);
        cdto.setContactVoice(this.contactVoice);
        cdto.setOnlineResource(this.onlineResource);
        return dto;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContactParty() {
        if (this.getContactPerson() != null && this.getContactPerson().length() != 0) {
            return this.getContactPerson();
        }
        if (this.getContactPosition() != null && this.getContactPosition().length() != 0) {
            return this.getContactPosition();
        }
        if (this.getContactOrganization() != null && this.getContactOrganization().length() != 0) {
            return this.getContactOrganization();
        }
        return null;
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public String toString() {
        StringBuffer geoserver = new StringBuffer("[GeoServer: \n");
        geoserver.append("   maxFeatures - " + this.maxFeatures);
        geoserver.append("\n   verbose - " + this.verbose);
        geoserver.append("\n   numDecimals - " + this.numDecimals);
        geoserver.append("\n   charSet - " + this.charSet);
        geoserver.append("\n   log4jConfigFile - " + this.log4jConfigFile);
        geoserver.append("\n   adminUserName - " + this.adminUserName);
        geoserver.append("\n   adminPassword - " + this.adminPassword);
        return geoserver.toString();
    }

    public boolean isVerboseExceptions() {
        return this.verboseExceptions;
    }

    public void setVerboseExceptions(boolean showStackTraces) {
        this.verboseExceptions = showStackTraces;
    }

    public String getLogLocation() {
        return this.logLocation;
    }

    public void setLogLocation(String logLocation) {
        this.logLocation = logLocation;
    }

    public boolean getSuppressStdOutLogging() {
        return this.suppressStdOutLogging;
    }

    public void setSuppressStdOutLogging(boolean loggingToFile) {
        this.suppressStdOutLogging = loggingToFile;
    }

    public JAI getJAIDefault() {
        return this.jaiDef;
    }

    public SunTileCache getJaiCache() {
        return this.jaiCache;
    }

    public double getMemoryCapacity() {
        return this.memoryCapacity;
    }

    public Boolean getRecycling() {
        return this.recycling;
    }

    public Boolean getJPEGNativeAcceleration() {
        return this.JPEGnativeAcc;
    }

    public Boolean getPNGNativeAcceleration() {
        return this.PNGnativeAcc;
    }

    public double getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public Boolean getImageIOCache() {
        return this.imageIOCache;
    }

    public int getTilePriority() {
        return this.tilePriority;
    }

    public int getTileThreads() {
        return this.tileThreads;
    }

    public String getTileCache() {
        return this.tileCache;
    }

    public void setTileCache(String tileCache) {
        this.tileCache = tileCache;
    }

    public void destroy() throws Exception {
        try {
            Class<?> sdepfClass = Class.forName("org.geotools.arcsde.pool.ArcSDEConnectionPoolFactory");
            GlobalLayerSupertype.LOGGER.fine("SDE datasource found, releasing resources");
            Method m = sdepfClass.getMethod("getInstance", new Class[0]);
            Object pfInstance = m.invoke(sdepfClass, new Object[0]);
            GlobalLayerSupertype.LOGGER.fine("got sde connection pool factory instance: " + pfInstance);
            Method closeMethod = pfInstance.getClass().getMethod("clear", new Class[0]);
            closeMethod.invoke(pfInstance, new Object[0]);
            GlobalLayerSupertype.LOGGER.info("Asking ArcSDE datasource to release connections.");
        }
        catch (ClassNotFoundException cnfe) {
            GlobalLayerSupertype.LOGGER.fine("No ArcSDE datasource found.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

