/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.memory.UserMap;
import org.acegisecurity.userdetails.memory.UserMapEditor;
import org.geoserver.security.PropertyFileWatcher;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class GeoserverUserDao
implements UserDetailsService {
    static Logger LOGGER = Logger.getLogger("org.geoserver.security");
    private UserMap userMap;
    private PropertyFileWatcher userDefinitionsFile;
    private GeoServer geoServer;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        this.checkUserMap();
        return this.userMap.getUser(username);
    }

    private void checkUserMap() throws DataAccessResourceFailureException {
        if (this.userMap == null || this.userDefinitionsFile != null && this.userDefinitionsFile.isStale()) {
            try {
                if (this.userDefinitionsFile == null) {
                    File securityDir = GeoserverDataDirectory.findCreateConfigDir("security");
                    File propFile = new File(securityDir, "users.properties");
                    if (!propFile.exists()) {
                        Properties p = new Properties();
                        if (this.geoServer != null && this.geoServer.getAdminUserName() != null && !this.geoServer.getAdminUserName().trim().equals("")) {
                            ((Hashtable)p).put(this.geoServer.getAdminUserName(), this.geoServer.getAdminPassword() + ",ROLE_ADMINISTRATOR");
                        } else {
                            ((Hashtable)p).put("admin", "geoserver,ROLE_ADMINISTRATOR");
                        }
                        FileOutputStream out = new FileOutputStream(propFile);
                        p.store(out, "Format: name=password,ROLE1,...,ROLEN");
                        out.close();
                    }
                    this.userDefinitionsFile = new PropertyFileWatcher(propFile);
                }
                this.userMap = new UserMap();
                UserMapEditor.addUsersFromProperties((UserMap)this.userMap, (Properties)this.userDefinitionsFile.getProperties());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "An error occurred loading user definitions", e);
            }
        }
    }

    public GeoServer getGeoServer() {
        return this.geoServer;
    }

    public void setGeoServer(GeoServer geoServer) {
        this.geoServer = geoServer;
    }
}

