/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SLDValidator {
    static Logger LOGGER = Logger.getLogger("org.vfny.geoserver");

    public List validateSLD(InputStream xml, ServletContext servContext) {
        return this.validateSLD(new InputSource(xml), servContext);
    }

    public static String getErrorMessage(InputStream xml, List errors) {
        return SLDValidator.getErrorMessage(new InputStreamReader(xml), errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getErrorMessage(Reader xml, List errors) {
        StringBuffer result;
        block19: {
            SAXParseException sax;
            BufferedReader reader = null;
            result = new StringBuffer();
            result.append("Your SLD is not valid.\n");
            result.append("Most common problems are: \n(1) no namespaces - use <ows:GetMap>, <sld:Rule>, <ogc:Filter>, <gml:Point>  - the part before the ':' is important\n");
            result.append("(2) capitialization - use '<And>' not '<and>' \n");
            result.append("(3) Order - The order of elements is important \n");
            result.append("(4) Make sure your first tag imports the correct namespaces.  ie. xmlns:sld=\"http://www.opengis.net/sld\" for EVERY NAMESPACE \n");
            result.append("\n");
            reader = new BufferedReader(xml);
            String line = reader.readLine();
            int linenumber = 1;
            int exceptionNum = 0;
            if (errors.size() > 0 && (sax = (SAXParseException)errors.get(0)).getLineNumber() < 0) {
                result.append("   INVALID XML: " + sax.getLocalizedMessage() + "\n");
                result.append(" \n");
                exceptionNum = 1;
            }
            while (line != null) {
                line.replace('\n', ' ');
                line.replace('\r', ' ');
                String header = linenumber + ": ";
                result.append(header + line + "\n");
                boolean keep_going = true;
                while (keep_going) {
                    if (exceptionNum < errors.size()) {
                        SAXParseException sax2 = (SAXParseException)errors.get(exceptionNum);
                        if (sax2.getLineNumber() <= linenumber) {
                            String head = "---------------------".substring(0, header.length() - 1);
                            String body = "--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------";
                            int colNum = sax2.getColumnNumber();
                            if (colNum < 1) {
                                colNum = 1;
                            }
                            if (colNum > body.length() && colNum > (body = body + body + body + body + body + body).length()) {
                                colNum = body.length();
                            }
                            result.append(head + body.substring(0, colNum - 1) + "^\n");
                            result.append("       (line " + sax2.getLineNumber() + ", column " + sax2.getColumnNumber() + ")" + sax2.getLocalizedMessage() + "\n");
                            ++exceptionNum;
                            continue;
                        }
                        keep_going = false;
                        continue;
                    }
                    keep_going = false;
                }
                line = reader.readLine();
                ++linenumber;
            }
            for (int t = exceptionNum; t < errors.size(); ++t) {
                SAXParseException sax3 = (SAXParseException)errors.get(t);
                result.append("       (line " + sax3.getLineNumber() + ", column " + sax3.getColumnNumber() + ")" + sax3.getLocalizedMessage() + "\n");
            }
            Object var14_17 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                break block19;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            break block19;
            {
                catch (Exception e) {
                    e.printStackTrace();
                    Object var14_18 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block19;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_19 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
        return result.toString();
    }

    public List validateSLD(InputSource xml, ServletContext servContext) {
        SAXParser parser = new SAXParser();
        try {
            URL schemaFile = servContext.getResource("/schemas/sld/StyledLayerDescriptor.xsd");
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Validating SLD with " + schemaFile.toString());
            }
            String schemaUrl = schemaFile.toString();
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
            parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)schemaUrl);
            parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)("http://www.opengis.net/sld " + schemaUrl));
            Validator handler = new Validator();
            parser.setErrorHandler((ErrorHandler)handler);
            parser.parse(xml);
            return handler.errors;
        }
        catch (IOException ioe) {
            ArrayList<SAXParseException> al = new ArrayList<SAXParseException>();
            al.add(new SAXParseException(ioe.getLocalizedMessage(), null));
            return al;
        }
        catch (SAXException e) {
            ArrayList<SAXParseException> al = new ArrayList<SAXParseException>();
            al.add(new SAXParseException(e.getLocalizedMessage(), null));
            return al;
        }
    }

    private class Validator
    extends DefaultHandler {
        public ArrayList errors = new ArrayList();

        private Validator() {
        }

        public void error(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        public void warning(SAXParseException exception) throws SAXException {
        }
    }
}

