/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.dto;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.geotools.geometry.GeneralEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;
import org.vfny.geoserver.global.CoverageDimension;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.dto.CloneLibrary;
import org.vfny.geoserver.global.dto.DataTransferObject;
import org.vfny.geoserver.global.dto.EqualsLibrary;

public final class CoverageInfoDTO
implements DataTransferObject {
    private String formatId;
    private String name;
    private String wmsPath;
    private String label;
    private String description;
    private MetaDataLink metadataLink;
    private String dirName;
    private List keywords;
    private GeneralEnvelope envelope;
    private GeneralEnvelope lonLatWGS84Envelope;
    private GridGeometry grid;
    private CoverageDimension[] dimensions;
    private InternationalString[] dimensionNames;
    private List requestCRSs;
    private List responseCRSs;
    private String nativeFormat;
    private List supportedFormats;
    private String defaultInterpolationMethod;
    private List interpolationMethods;
    private String srsName;
    private String srsWKT;
    private CoordinateReferenceSystem crs;
    private String defaultStyle;
    private ArrayList styles = new ArrayList();
    private Map parameters;

    public CoverageInfoDTO() {
    }

    public CoverageInfoDTO(CoverageInfoDTO dto) {
        if (dto == null) {
            throw new NullPointerException("Non null CoverageInfoDTO required");
        }
        this.formatId = dto.getFormatId();
        this.name = dto.getName();
        this.wmsPath = dto.getWmsPath();
        this.label = dto.getLabel();
        this.description = dto.getDescription();
        this.metadataLink = dto.getMetadataLink();
        this.dirName = dto.getDirName();
        try {
            this.keywords = CloneLibrary.clone(dto.getKeywords());
        }
        catch (Exception e) {
            this.keywords = new LinkedList();
        }
        this.crs = dto.getCrs();
        this.srsName = dto.getSrsName();
        this.srsWKT = dto.getSrsWKT();
        this.envelope = dto.getEnvelope();
        this.lonLatWGS84Envelope = dto.getLonLatWGS84Envelope();
        this.grid = dto.getGrid();
        this.dimensions = dto.getDimensions();
        this.dimensionNames = dto.getDimensionNames();
        try {
            this.requestCRSs = CloneLibrary.clone(dto.getRequestCRSs());
        }
        catch (CloneNotSupportedException e1) {
            this.requestCRSs = new LinkedList();
        }
        try {
            this.responseCRSs = CloneLibrary.clone(dto.getResponseCRSs());
        }
        catch (CloneNotSupportedException e2) {
            this.responseCRSs = new LinkedList();
        }
        this.nativeFormat = dto.getNativeFormat();
        try {
            this.supportedFormats = CloneLibrary.clone(dto.getSupportedFormats());
        }
        catch (CloneNotSupportedException e3) {
            this.supportedFormats = new LinkedList();
        }
        this.defaultInterpolationMethod = dto.getDefaultInterpolationMethod();
        try {
            this.interpolationMethods = CloneLibrary.clone(dto.getInterpolationMethods());
        }
        catch (CloneNotSupportedException e4) {
            this.interpolationMethods = new LinkedList();
        }
        this.defaultStyle = dto.getDefaultStyle();
        this.styles = dto.getStyles();
        this.parameters = dto.getParameters();
    }

    public Object clone() {
        return new CoverageInfoDTO(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CoverageInfoDTO)) {
            return false;
        }
        CoverageInfoDTO f = (CoverageInfoDTO)obj;
        boolean r = true;
        boolean bl = r = r && this.formatId == f.getFormatId();
        if (this.envelope != null) {
            r = r && this.envelope.equals((Object)f.getEnvelope());
        } else if (f.getEnvelope() != null) {
            return false;
        }
        r = r && this.srsName == f.getSrsName();
        r = r && this.srsWKT == f.getSrsWKT();
        r = r && this.crs == f.getCrs();
        r = r && this.name == f.getName();
        r = r && this.wmsPath == f.getWmsPath();
        r = r && this.description == f.getDescription();
        r = r && this.label == f.getLabel();
        boolean bl2 = r = r && this.metadataLink == f.getMetadataLink();
        if (this.keywords != null) {
            r = r && EqualsLibrary.equals(this.keywords, f.getKeywords());
        } else if (f.getKeywords() != null) {
            return false;
        }
        r = r && this.defaultStyle == f.getDefaultStyle();
        r = r && this.styles == f.getStyles();
        r = r && this.dirName == f.getDirName();
        r = r && this.envelope == f.getEnvelope();
        r = r && this.grid == f.getGrid();
        return r;
    }

    public int hashCode() {
        int r = 1;
        if (this.name != null) {
            r *= this.name.hashCode();
        }
        if (this.formatId != null) {
            r *= this.formatId.hashCode();
        }
        if (this.label != null) {
            r *= this.label.hashCode();
        }
        if (this.envelope != null) {
            r *= this.envelope.hashCode();
        }
        if (this.grid != null) {
            r *= this.grid.hashCode();
        }
        if (this.srsName != null) {
            r *= this.srsName.hashCode();
        }
        if (this.srsWKT != null) {
            r *= this.srsWKT.hashCode();
        }
        if (this.crs != null) {
            r *= this.crs.hashCode();
        }
        return r;
    }

    public List getKeywords() {
        return this.keywords;
    }

    public String getKey() {
        return this.getFormatId() + ":::" + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setKeywords(List list) {
        this.keywords = list;
    }

    public boolean addKeyword(String key) {
        if (this.keywords == null) {
            this.keywords = new LinkedList();
        }
        return this.keywords.add(key);
    }

    public boolean removeKeyword(String key) {
        return this.keywords.remove(key);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setDirName(String string) {
        this.dirName = string;
    }

    public String toString() {
        return "[CoverageInfoDTO: " + this.name + ", formatId: " + this.formatId + ", envelope: " + this.envelope + "\n  SRS: " + this.srsName + ", dirName: " + this.dirName + ", label: " + this.label + "\n  description: " + this.description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFormatId() {
        return this.formatId;
    }

    public void setFormatId(String formatId) {
        this.formatId = formatId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public MetaDataLink getMetadataLink() {
        return this.metadataLink;
    }

    public void setMetadataLink(MetaDataLink metadataLink) {
        this.metadataLink = metadataLink;
    }

    public String getDefaultInterpolationMethod() {
        return this.defaultInterpolationMethod;
    }

    public void setDefaultInterpolationMethod(String defaultInterpolationMethod) {
        this.defaultInterpolationMethod = defaultInterpolationMethod;
    }

    public GeneralEnvelope getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(GeneralEnvelope envelope) {
        this.envelope = envelope;
    }

    public List getInterpolationMethods() {
        return this.interpolationMethods;
    }

    public void setInterpolationMethods(List interpolationMethods) {
        this.interpolationMethods = interpolationMethods;
    }

    public String getNativeFormat() {
        return this.nativeFormat;
    }

    public void setNativeFormat(String nativeFormat) {
        this.nativeFormat = nativeFormat;
    }

    public List getRequestCRSs() {
        return this.requestCRSs;
    }

    public void setRequestCRSs(List requestCRSs) {
        this.requestCRSs = requestCRSs;
    }

    public List getResponseCRSs() {
        return this.responseCRSs;
    }

    public void setResponseCRSs(List responseCRSs) {
        this.responseCRSs = responseCRSs;
    }

    public String getSrsName() {
        return this.srsName;
    }

    public void setSrsName(String srsName) {
        this.srsName = srsName;
    }

    public List getSupportedFormats() {
        return this.supportedFormats;
    }

    public void setSupportedFormats(List supportedFormats) {
        this.supportedFormats = supportedFormats;
    }

    public String getDefaultStyle() {
        if (this.defaultStyle == null || this.defaultStyle.equals("")) {
            this.defaultStyle = "raster";
        }
        return this.defaultStyle;
    }

    public void setDefaultStyle(String string) {
        this.defaultStyle = string;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public void setCrs(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public GridGeometry getGrid() {
        return this.grid;
    }

    public void setGrid(GridGeometry grid) {
        this.grid = grid;
    }

    public InternationalString[] getDimensionNames() {
        return this.dimensionNames;
    }

    public void setDimensionNames(InternationalString[] dimentionNames) {
        this.dimensionNames = dimentionNames;
    }

    public CoverageDimension[] getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(CoverageDimension[] dimensions) {
        this.dimensions = dimensions;
    }

    public String getSrsWKT() {
        return this.srsWKT;
    }

    public void setSrsWKT(String srsWKT) {
        this.srsWKT = srsWKT;
    }

    public GeneralEnvelope getLonLatWGS84Envelope() {
        return this.lonLatWGS84Envelope;
    }

    public void setLonLatWGS84Envelope(GeneralEnvelope latLonEnvelope) {
        this.lonLatWGS84Envelope = latLonEnvelope;
    }

    public String getWmsPath() {
        return this.wmsPath;
    }

    public void setWmsPath(String wmsPath) {
        this.wmsPath = wmsPath;
    }

    public ArrayList getStyles() {
        return this.styles;
    }

    public void addStyle(String styleName) {
        if (!this.styles.contains(styleName)) {
            this.styles.add(styleName);
        }
    }

    public void setStyles(ArrayList styles) {
        this.styles = styles;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public synchronized void setParameters(Map parameters) {
        this.parameters = parameters;
    }
}

