/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config;

import java.io.File;
import org.vfny.geoserver.global.dto.StyleDTO;

public class StyleConfig {
    private String id = "";
    private File filename = null;
    private boolean _default = false;

    public StyleConfig() {
        this.id = "";
        this.filename = null;
        this._default = false;
    }

    public StyleConfig(StyleConfig style) {
        if (style == null) {
            throw new NullPointerException("Non null StyleConfig required");
        }
        this.id = style.getId();
        this.filename = new File(style.getFilename().toString());
        this._default = style.isDefault();
    }

    public StyleConfig(StyleDTO style) {
        if (style == null) {
            throw new NullPointerException("Non null StyleDTO required");
        }
        this.id = style.getId();
        this.filename = new File(style.getFilename().toString());
        this._default = style.isDefault();
    }

    public void update(StyleDTO obj) {
        if (obj == null) {
            throw new NullPointerException("Style Data Transfer Object required");
        }
        StyleDTO sDto = obj;
        this.id = sDto.getId();
        this.filename = new File(sDto.getFilename().toString());
        this._default = sDto.isDefault();
    }

    public StyleDTO toDTO() {
        StyleDTO sDto = new StyleDTO();
        sDto.setDefault(this._default);
        sDto.setFilename(new File(this.filename.toString()));
        sDto.setId(this.id);
        return sDto;
    }

    public boolean isDefault() {
        return this._default;
    }

    public File getFilename() {
        return this.filename;
    }

    public String getId() {
        return this.id;
    }

    public void setDefault(boolean b) {
        this._default = b;
    }

    public void setFilename(File file) {
        this.filename = file;
    }

    public void setId(String string) {
        this.id = string;
    }
}

