/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.vfny.geoserver.global.ConfigurationException;

public class WriterHelper {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.global");
    protected Writer writer;
    protected int indent;
    protected StringBuffer indentBuffer = new StringBuffer();

    protected WriterHelper() {
    }

    public WriterHelper(Writer writer) {
        this.writer = writer;
    }

    public void write(String s) throws ConfigurationException {
        try {
            this.writer.write(s);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new ConfigurationException("Write" + this.writer, e);
        }
    }

    public void writeln(String s) throws ConfigurationException {
        try {
            this.writer.write(this.indentBuffer.subSequence(0, this.indent) + s + "\n");
            this.writer.flush();
        }
        catch (IOException e) {
            throw new ConfigurationException("Writeln" + this.writer, e);
        }
    }

    private void increaseIndent() {
        this.indent += 2;
        this.indentBuffer.append("  ");
    }

    private void decreaseIndent() {
        if (this.indent > 0) {
            this.indent -= 2;
            this.indentBuffer.setLength(this.indentBuffer.length() - 2);
        }
    }

    public void openTag(String tagName) throws ConfigurationException {
        this.openTag(tagName, Collections.EMPTY_MAP);
    }

    public void openTag(String tagName, Map attributes) throws ConfigurationException {
        StringBuffer sb = new StringBuffer();
        sb.append("<" + tagName + " ");
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            if (attributes.get(s) == null) continue;
            sb.append(s + " = " + "\"" + attributes.get(s).toString() + "\" ");
        }
        sb.append(">");
        this.writeln(sb.toString());
        this.increaseIndent();
    }

    public void closeTag(String tagName) throws ConfigurationException {
        this.decreaseIndent();
        this.writeln("</" + tagName + ">");
    }

    public void valueTag(String tagName, String value) throws ConfigurationException {
        this.writeln("<" + tagName + " value = \"" + value + "\" />");
    }

    public void attrTag(String tagName, Map attributes) throws ConfigurationException {
        StringBuffer sb = new StringBuffer();
        sb.append("<" + tagName + " ");
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            if (attributes.get(s) == null) continue;
            sb.append(s + " = " + "\"" + attributes.get(s).toString() + "\" ");
        }
        sb.append("/>");
        this.writeln(sb.toString());
    }

    public void textTag(String tagName, String data) throws ConfigurationException {
        this.textTag(tagName, Collections.EMPTY_MAP, data);
    }

    public void textTag(String tagName, Map attributes, String data) throws ConfigurationException {
        StringBuffer sb = new StringBuffer();
        sb.append("<" + tagName + (attributes.size() > 0 ? " " : ""));
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            if (attributes.get(s) == null) continue;
            sb.append(s + " = " + "\"" + attributes.get(s).toString() + "\" ");
        }
        sb.append(">" + (data != null ? data : "") + "</" + tagName + ">");
        this.writeln(sb.toString());
    }

    public void comment(String comment) throws ConfigurationException {
        this.writeln("<!--");
        this.increaseIndent();
        String ib = this.indentBuffer.substring(0, this.indent);
        comment = comment.trim();
        comment = comment.replaceAll("\n", "\n" + ib);
        this.writeln(comment);
        this.decreaseIndent();
        this.writeln("-->");
    }
}

