/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config;

import java.net.URL;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.dto.ServiceDTO;

public class ServiceConfig {
    private boolean enabled = true;
    private URL onlineResource;
    private String name;
    private String title;
    private String _abstract;
    private String[] keywords;
    private String fees;
    private String accessConstraints = "NONE";
    private String maintainer;
    private MetaDataLink metadataLink;

    public ServiceConfig() {
        this.enabled = true;
        this.name = "";
        this.title = "";
        this._abstract = "";
        this.keywords = new String[0];
        this.fees = "";
        this.accessConstraints = "NONE";
        this.maintainer = "";
        this.metadataLink = null;
    }

    public ServiceConfig(ServiceDTO dto) {
        if (dto == null) {
            throw new NullPointerException("Non null ServiceDTO required");
        }
        this.update(dto);
    }

    public void update(ServiceDTO dto) {
        if (dto == null) {
            throw new NullPointerException("Service Data Transfer Object required");
        }
        ServiceDTO s = dto;
        this.enabled = s.isEnabled();
        this.name = s.getName();
        this.title = s.getTitle();
        this._abstract = s.getAbstract();
        try {
            this.keywords = new String[s.getKeywords().length];
            for (int i = 0; i < this.keywords.length; ++i) {
                this.keywords[i] = s.getKeywords()[i];
            }
        }
        catch (Exception e) {
            this.keywords = new String[0];
        }
        this.fees = s.getFees();
        this.accessConstraints = s.getAccessConstraints();
        this.maintainer = s.getMaintainer();
        this.onlineResource = s.getOnlineResource();
        this.metadataLink = s.getMetadataLink();
    }

    public ServiceDTO toServDTO() {
        ServiceDTO sDto = new ServiceDTO();
        sDto.setAbstract(this._abstract);
        sDto.setAccessConstraints(this.accessConstraints);
        sDto.setEnabled(this.enabled);
        sDto.setFees(this.fees);
        String[] s = new String[this.keywords.length];
        for (int i = 0; i < this.keywords.length; ++i) {
            s[i] = this.keywords[i];
        }
        sDto.setKeywords(s);
        sDto.setMaintainer(this.maintainer);
        sDto.setName(this.name);
        sDto.setOnlineResource(this.onlineResource);
        sDto.setTitle(this.title);
        sDto.setMetadataLink(this.metadataLink);
        return sDto;
    }

    public String getName() {
        return this.name;
    }

    public URL getOnlineResource() {
        return this.onlineResource;
    }

    public String getTitle() {
        return this.title;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOnlineResource(URL url) {
        this.onlineResource = url;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getAbstract() {
        return this._abstract;
    }

    public String getAccessConstraints() {
        return this.accessConstraints;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getFees() {
        return this.fees;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public void setAbstract(String string) {
        this._abstract = string;
    }

    public void setAccessConstraints(String string) {
        this.accessConstraints = string;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public void setFees(String string) {
        this.fees = string;
    }

    public void setKeywords(String[] list) {
        this.keywords = list;
    }

    public void setMaintainer(String string) {
        this.maintainer = string;
    }

    public MetaDataLink getMetadataLink() {
        return this.metadataLink;
    }

    public void setMetadataLink(MetaDataLink metadataLink) {
        this.metadataLink = metadataLink;
    }
}

