/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util.requests.readers;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.FilterFilter;
import org.geotools.filter.FilterHandler;
import org.geotools.gml.GMLFilterDocument;
import org.geotools.gml.GMLFilterGeometry;
import org.geotools.gml.GMLHandlerGeometry;
import org.geotools.gml.GMLHandlerJTS;
import org.geotools.text.filter.FilterBuilder;
import org.geotools.text.filter.ParseException;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.servlets.AbstractService;
import org.vfny.geoserver.util.requests.FilterHandlerImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserAdapter;

public abstract class KvpRequestReader {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.readers");
    private static final String KEYWORD_DELIMITER = "&";
    private static final String VALUE_DELIMITER = "=";
    protected static final String OUTER_DELIMETER = "()";
    protected static final String INNER_DELIMETER = ",";
    protected static final FilterFactory factory = FilterFactoryFinder.createFilterFactory();
    protected Map kvpPairs = new HashMap(10);
    protected AbstractService service;
    static /* synthetic */ Class class$0;

    public KvpRequestReader(Map kvpPairs, AbstractService service) {
        this.kvpPairs = kvpPairs;
        this.service = service;
    }

    protected String getValue(String key) {
        return (String)this.kvpPairs.get(key);
    }

    protected boolean keyExists(String key) {
        return this.kvpPairs.containsKey(key);
    }

    public abstract Request getRequest(HttpServletRequest var1) throws ServiceException;

    protected List getTypesFromFids(String rawFidList) {
        ArrayList<String> typeList = new ArrayList<String>(10);
        List unparsed = KvpRequestReader.readNested(rawFidList);
        ListIterator i = unparsed.listIterator();
        while (i.hasNext()) {
            List ids = (List)i.next();
            ListIterator innerIterator = ids.listIterator();
            while (innerIterator.hasNext()) {
                String fid = innerIterator.next().toString();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("looking at featureId" + fid);
                }
                String typeName = fid.substring(0, fid.lastIndexOf("."));
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("adding typename: " + typeName + " from fid");
                }
                typeList.add(typeName);
            }
        }
        return typeList;
    }

    protected static List readFlat(String rawList, String delimiter) {
        ArrayList<String> kvpList = null;
        if (rawList == null || "".equals(rawList)) {
            return Collections.EMPTY_LIST;
        }
        if (rawList.equals("*")) {
            return Collections.EMPTY_LIST;
        }
        if (delimiter.length() == 1) {
            int index = -1;
            kvpList = new ArrayList<String>(10);
            rawList = String.valueOf(rawList) + delimiter;
            while ((index = rawList.indexOf(delimiter)) > -1) {
                String token = rawList.substring(0, index);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("adding simple element " + token);
                }
                kvpList.add(token);
                rawList = rawList.substring(++index);
            }
        } else {
            StringTokenizer kvps = new StringTokenizer(rawList, delimiter);
            kvpList = new ArrayList(kvps.countTokens());
            while (kvps.hasMoreTokens()) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("adding simple element");
                }
                kvpList.add(kvps.nextToken());
            }
        }
        return kvpList;
    }

    protected static List readNested(String rawList) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("reading nested: " + rawList);
        }
        ArrayList<List> kvpList = new ArrayList<List>(10);
        if (rawList == null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("found implicit all requested");
            }
            return kvpList;
        }
        if (rawList.equals("*")) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("found explicit all requested");
            }
            return kvpList;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("found explicit requested");
        }
        if (rawList.startsWith("(")) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("reading complex list");
            }
            List outerList = KvpRequestReader.readFlat(rawList, OUTER_DELIMETER);
            ListIterator i = outerList.listIterator();
            while (i.hasNext()) {
                kvpList.add(KvpRequestReader.readFlat((String)i.next(), INNER_DELIMETER));
            }
        } else {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("reading simple list");
            }
            kvpList.add(KvpRequestReader.readFlat(rawList, INNER_DELIMETER));
        }
        return kvpList;
    }

    public static Map parseKvpSet(String qString) {
        String cleanRequest = KvpRequestReader.clean(qString);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("clean request is " + cleanRequest);
        }
        HashMap<String, String> kvps = null;
        kvps = new HashMap<String, String>(10);
        StringTokenizer requestKeywords = new StringTokenizer(cleanRequest.trim(), KEYWORD_DELIMITER);
        while (requestKeywords.hasMoreTokens()) {
            String kvpPair = requestKeywords.nextToken();
            if (kvpPair.toUpperCase().startsWith("FILTER")) {
                String filterVal = kvpPair.substring(7);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("putting filter value " + filterVal);
                }
                kvps.put("FILTER", filterVal);
                continue;
            }
            StringTokenizer requestValues = new StringTokenizer(kvpPair, VALUE_DELIMITER);
            if (!requestValues.hasMoreTokens()) continue;
            String key = requestValues.nextToken().toUpperCase();
            if (!requestValues.hasMoreTokens()) continue;
            String value = requestValues.nextToken();
            LOGGER.finest("putting kvp pair: " + key + ": " + value);
            kvps.put(key, value);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("returning parsed " + kvps);
        }
        return kvps;
    }

    private static String clean(String raw) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("raw request: " + raw);
        }
        String clean = null;
        if (raw != null) {
            try {
                clean = URLDecoder.decode(raw, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Bad encoding for decoder " + e);
                }
            }
        } else {
            return "";
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("cleaned request: " + raw);
        }
        return clean;
    }

    public AbstractService getServiceRef() {
        return this.service;
    }

    public void setServiceRef(AbstractService service) {
        this.service = service;
    }

    protected Envelope parseBbox(String bboxParam) throws ServiceException {
        Envelope bbox = null;
        Object[] bboxValues = KvpRequestReader.readFlat(bboxParam, INNER_DELIMETER).toArray();
        if (bboxValues.length != 4) {
            throw new ServiceException(String.valueOf(bboxParam) + " is not a valid pair of coordinates", this.getClass().getName());
        }
        try {
            double minx = Double.parseDouble(bboxValues[0].toString());
            double miny = Double.parseDouble(bboxValues[1].toString());
            double maxx = Double.parseDouble(bboxValues[2].toString());
            double maxy = Double.parseDouble(bboxValues[3].toString());
            bbox = new Envelope(minx, maxx, miny, maxy);
            if (minx > maxx) {
                throw new ServiceException("illegal bbox, minX: " + minx + " is " + "greater than maxX: " + maxx);
            }
            if (miny > maxy) {
                throw new ServiceException("illegal bbox, minY: " + miny + " is " + "greater than maxY: " + maxy);
            }
        }
        catch (NumberFormatException ex) {
            throw new ServiceException(ex, "Illegal value for BBOX parameter: " + bboxParam, String.valueOf(this.getClass().getName()) + "::parseBbox()");
        }
        return bbox;
    }

    protected List readOGCFilter(String filter) throws ServiceException {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        LOGGER.finest("reading filter: " + filter);
        List unparsed = KvpRequestReader.readFlat(filter, OUTER_DELIMETER);
        ListIterator i = unparsed.listIterator();
        while (i.hasNext()) {
            String next = (String)i.next();
            if (next.trim().equals("")) {
                filters.add(Filter.NONE);
                continue;
            }
            filters.add(this.parseXMLFilter(new StringReader(next)));
        }
        return filters;
    }

    protected List readCQLFilter(String filter) throws ServiceException {
        try {
            return FilterBuilder.parseFilterList(null, (String)filter);
        }
        catch (ParseException pe) {
            throw new ServiceException("Could not parse CQL filter list." + pe.getMessage(), pe);
        }
    }

    protected List readFidFilters(String fid) {
        ArrayList<FidFilter> filters = new ArrayList<FidFilter>();
        LOGGER.finest("reading fid filter: " + fid);
        List unparsed = KvpRequestReader.readNested(fid);
        ListIterator i = unparsed.listIterator();
        while (i.hasNext()) {
            List ids = (List)i.next();
            ListIterator innerIterator = ids.listIterator();
            while (innerIterator.hasNext()) {
                FidFilter fidFilter = factory.createFidFilter();
                fidFilter.addFid((String)innerIterator.next());
                filters.add(fidFilter);
                LOGGER.finest("added fid filter: " + fidFilter);
            }
        }
        return filters;
    }

    protected Filter parseXMLFilter(Reader rawRequest) throws ServiceException {
        InputSource requestSource = new InputSource(rawRequest);
        FilterHandlerImpl contentHandler = new FilterHandlerImpl();
        FilterFilter filterParser = new FilterFilter((FilterHandler)contentHandler, null);
        GMLFilterGeometry geometryFilter = new GMLFilterGeometry((GMLHandlerJTS)filterParser);
        GMLFilterDocument documentFilter = new GMLFilterDocument((GMLHandlerGeometry)geometryFilter);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            ParserAdapter adapter = new ParserAdapter(parser.getParser());
            adapter.setContentHandler((ContentHandler)documentFilter);
            adapter.parse(requestSource);
            LOGGER.fine("just parsed: " + requestSource);
        }
        catch (SAXException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.vfny.geoserver.util.requests.readers.XmlRequestReader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new ServiceException(e, "XML getFeature request SAX parsing error", clazz.getName());
        }
        catch (IOException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.vfny.geoserver.util.requests.readers.XmlRequestReader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new ServiceException(e, "XML get feature request input error", clazz.getName());
        }
        catch (ParserConfigurationException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.vfny.geoserver.util.requests.readers.XmlRequestReader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new ServiceException(e, "Some sort of issue creating parser", clazz.getName());
        }
        LOGGER.fine("passing filter: " + contentHandler.getFilter());
        return contentHandler.getFilter();
    }
}

