/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.awt.Color;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GeneralGridGeometry;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.BufferedCoordinateOperationFactory;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public class CoverageUtils {
    private static final BufferedCoordinateOperationFactory operationFactory = new BufferedCoordinateOperationFactory(new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
    private static final Logger LOGGER;
    public static final int TRANSPARENT = 0;
    public static final int OPAQUE = 1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.vfny.geoserver.util.CoverageUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = Logger.getLogger(clazz.toString());
    }

    public static GeneralParameterValue[] getParameters(ParameterValueGroup params) {
        ArrayList<GeneralParameterValue> parameters = new ArrayList<GeneralParameterValue>();
        String readGeometryKey = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
        if (params != null && params.values().size() > 0) {
            List list = params.values();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                ParameterDescriptor descr;
                String _key;
                ParameterValue val = (ParameterValue)it.next();
                if (val == null || "namespace".equals(_key = (descr = (ParameterDescriptor)val.getDescriptor()).getName().toString()) || _key.equalsIgnoreCase(readGeometryKey)) continue;
                Object value = val.getValue();
                parameters.add(new DefaultParameterDescriptor(_key, value.getClass(), null, value).createValue());
            }
            return !parameters.isEmpty() ? parameters.toArray(new GeneralParameterValue[parameters.size()]) : null;
        }
        return null;
    }

    public static GeneralParameterValue[] getParameters(ParameterValueGroup params, Map values) {
        return CoverageUtils.getParameters(params, values, false);
    }

    public static GeneralParameterValue[] getParameters(ParameterValueGroup params, Map values, boolean readGeom) {
        ArrayList<GeneralParameterValue> parameters = new ArrayList<GeneralParameterValue>();
        String readGeometryKey = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
        if (params != null && params.values().size() > 0) {
            List list = params.values();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                ParameterDescriptor descr;
                String _key;
                ParameterValue val = (ParameterValue)it.next();
                if (val == null || "namespace".equals(_key = (descr = (ParameterDescriptor)val.getDescriptor()).getName().toString()) || _key.equalsIgnoreCase(readGeometryKey) && !readGeom) continue;
                Object value = CoverageUtils.getCvParamValue(_key, val, values);
                if (value == null && (_key.equalsIgnoreCase("InputTransparentColor") || _key.equalsIgnoreCase("OutputTransparentColor"))) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.awt.Color");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    parameters.add(new DefaultParameterDescriptor(_key, (Class)clazz, null, value).createValue());
                    continue;
                }
                parameters.add(new DefaultParameterDescriptor(_key, value.getClass(), null, value).createValue());
            }
            return !parameters.isEmpty() ? parameters.toArray(new GeneralParameterValue[parameters.size()]) : null;
        }
        return null;
    }

    public static Map getParametersKVP(ParameterValueGroup params) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String readGeometryKey = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
        if (params != null && params.values().size() > 0) {
            List list = params.values();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                ParameterDescriptor descr;
                String _key;
                ParameterValue val = (ParameterValue)it.next();
                if (val == null || "namespace".equals(_key = (descr = (ParameterDescriptor)val.getDescriptor()).getName().toString()) || _key.equalsIgnoreCase(readGeometryKey)) continue;
                Object value = val.getValue();
                String text = "";
                text = value == null ? null : (value instanceof String ? (String)value : value.toString());
                parameters.put(_key, text != null ? text : "");
            }
            return parameters;
        }
        return parameters;
    }

    public static Object getCvParamValue(String key, ParameterValue param, List paramValues, int index) {
        Object value = null;
        try {
            if (key.equalsIgnoreCase("crs")) {
                if (CoverageUtils.getParamValue(paramValues, index) != null && CoverageUtils.getParamValue(paramValues, index).length() > 0) {
                    if (paramValues.get(index) != null && ((String)paramValues.get(index)).length() > 0) {
                        value = CRS.parseWKT((String)((String)paramValues.get(index)));
                    }
                } else {
                    LOGGER.info("Unable to find a crs for the coverage param, using EPSG:4326");
                    value = CRS.decode((String)"EPSG:4326");
                }
            } else if (key.equalsIgnoreCase("envelope")) {
                String tmp;
                if (CoverageUtils.getParamValue(paramValues, index) != null && CoverageUtils.getParamValue(paramValues, index).length() > 0 && (tmp = CoverageUtils.getParamValue(paramValues, index)).indexOf("[") > 0 && tmp.indexOf("]") > tmp.indexOf("[")) {
                    tmp = tmp.substring(tmp.indexOf("[") + 1, tmp.indexOf("]")).trim();
                    tmp = tmp.replaceAll(",", "");
                    String[] strCoords = tmp.split(" ");
                    double[] coords = new double[strCoords.length];
                    if (strCoords.length == 4) {
                        int iT = 0;
                        while (iT < 4) {
                            coords[iT] = Double.parseDouble(strCoords[iT].trim());
                            ++iT;
                        }
                        value = new GeneralEnvelope(new double[]{coords[0], coords[1]}, new double[]{coords[2], coords[3]});
                    }
                }
            } else {
                Class[] clArray = new Class[]{CoverageUtils.getParamValue(paramValues, index).getClass()};
                Object[] inArray = new Object[]{CoverageUtils.getParamValue(paramValues, index)};
                value = param.getValue().getClass().getConstructor(clArray).newInstance(inArray);
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            value = null;
        }
        return value;
    }

    private static String getParamValue(List paramValues, int index) {
        return (String)paramValues.get(index);
    }

    public static Object getCvParamValue(String key, ParameterValue param, Map params) {
        Object value;
        block25: {
            value = null;
            try {
                if (key.equalsIgnoreCase("crs")) {
                    if (params.get(key) != null && ((String)params.get(key)).length() > 0) {
                        value = CRS.parseWKT((String)((String)params.get(key)));
                    } else {
                        LOGGER.info("Unable to find a crs for the coverage param, using EPSG:4326");
                        value = CRS.decode((String)"EPSG:4326");
                    }
                    break block25;
                }
                if (key.equalsIgnoreCase("envelope")) {
                    String tmp;
                    if (params.get(key) != null && ((String)params.get(key)).length() > 0 && (tmp = (String)params.get(key)).indexOf("[") > 0 && tmp.indexOf("]") > tmp.indexOf("[")) {
                        tmp = tmp.substring(tmp.indexOf("[") + 1, tmp.indexOf("]")).trim();
                        tmp = tmp.replaceAll(",", "");
                        String[] strCoords = tmp.split(" ");
                        double[] coords = new double[strCoords.length];
                        if (strCoords.length == 4) {
                            int iT = 0;
                            while (iT < 4) {
                                coords[iT] = Double.parseDouble(strCoords[iT].trim());
                                ++iT;
                            }
                            value = new GeneralEnvelope(new double[]{coords[0], coords[1]}, new double[]{coords[2], coords[3]});
                        }
                    }
                    break block25;
                }
                if (key.equalsIgnoreCase(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) {
                    if (params.get(key) != null && params.get(key) instanceof String && ((String)params.get(key)).length() > 0) {
                        String tmp = (String)params.get(key);
                        if (tmp.indexOf("[") > 0 && tmp.indexOf("]") > tmp.indexOf("[")) {
                            tmp = tmp.substring(tmp.indexOf("[") + 1, tmp.indexOf("]")).trim();
                            tmp = tmp.replaceAll(",", "");
                            String[] strCoords = tmp.split(" ");
                            double[] coords = new double[strCoords.length];
                            if (strCoords.length == 4) {
                                int iT = 0;
                                while (iT < 4) {
                                    coords[iT] = Double.parseDouble(strCoords[iT].trim());
                                    ++iT;
                                }
                                value = new GeneralEnvelope(new double[]{coords[0], coords[1]}, new double[]{coords[2], coords[3]});
                            }
                        }
                    } else if (params.get(key) != null && params.get(key) instanceof GeneralGridGeometry) {
                        value = params.get(key);
                    }
                    break block25;
                }
                if (key.equalsIgnoreCase("InputTransparentColor") || key.equalsIgnoreCase("OutputTransparentColor")) {
                    if (params.get(key) != null) {
                        value = Color.decode((String)params.get(key));
                        break block25;
                    }
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.awt.Color");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    Class[] clArray = classArray;
                    Object[] inArray = new Object[]{params.get(key)};
                    value = param.getValue().getClass().getConstructor(clArray).newInstance(inArray);
                    break block25;
                }
                Class[] classArray = new Class[1];
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class[] clArray = classArray;
                Object[] inArray = new Object[]{params.get(key)};
                value = param.getValue().getClass().getConstructor(clArray).newInstance(inArray);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                value = param.getValue();
            }
        }
        return value;
    }
}

