/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.geotools.data.coverage.grid.GridFormatFactorySpi;
import org.geotools.data.coverage.grid.GridFormatFinder;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.resources.CRSUtilities;
import org.opengis.coverage.grid.Format;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;

public final class CoverageStoreUtils {
    private static final Logger LOGGER;
    public static final Format[] formats;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.vfny.geoserver.util.CoverageStoreUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = Logger.getLogger(clazz.toString());
        formats = GridFormatFinder.getFormatArray();
    }

    private CoverageStoreUtils() {
    }

    public static Format acquireFormat(String type, ServletContext sc) throws IOException {
        Format[] formats = GridFormatFinder.getFormatArray();
        int i = 0;
        while (i < formats.length) {
            Format format = formats[i];
            if (formats[i].getName().equals(type)) {
                return format;
            }
            ++i;
        }
        throw new IOException("Cannot handle format: " + type);
    }

    public static ParameterValue find(Format format, String key) {
        return CoverageStoreUtils.find(format.getReadParameters(), key);
    }

    public static ParameterValue find(ParameterValueGroup params, String key) {
        List list = params.values();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ParameterValue val = (ParameterValue)it.next();
            ParameterDescriptor descr = (ParameterDescriptor)val.getDescriptor();
            if (!key.equalsIgnoreCase(descr.getName().toString())) continue;
            return val;
        }
        return null;
    }

    public static Format aquireFactoryByType(String type) {
        Format[] formats = GridFormatFinder.getFormatArray();
        int i = 0;
        while (i < formats.length) {
            Format format = formats[i];
            if (format.getName().equals(type)) {
                return format;
            }
            ++i;
        }
        return null;
    }

    public static Format aquireFactory(String description) {
        Format[] formats = GridFormatFinder.getFormatArray();
        int i = 0;
        while (i < formats.length) {
            Format format = formats[i];
            if (format.getDescription().equals(description)) {
                return format;
            }
            ++i;
        }
        return null;
    }

    public static List listDataFormatsDescriptions() {
        ArrayList<String> list = new ArrayList<String>(155);
        Format[] formats = GridFormatFinder.getFormatArray();
        int i = 0;
        while (i < formats.length) {
            String desc = formats[i].getDescription();
            if (!list.contains(desc)) {
                list.add(desc);
            }
            ++i;
        }
        return Collections.synchronizedList(list);
    }

    public static List listDataFormats() {
        ArrayList<Format> list = new ArrayList<Format>(15);
        Format[] formats = GridFormatFinder.getFormatArray();
        int i = 0;
        while (i < formats.length) {
            Format format = formats[i];
            if (!list.contains(format)) {
                list.add(format);
            }
            ++i;
        }
        return Collections.synchronizedList(list);
    }

    public static Map defaultParams(String description) {
        return Collections.synchronizedMap(CoverageStoreUtils.defaultParams(CoverageStoreUtils.aquireFactory(description)));
    }

    public static Map defaultParams(Format factory) {
        HashMap<String, String> defaults = new HashMap<String, String>();
        ParameterValueGroup params = factory.getReadParameters();
        if (params != null) {
            List list = params.values();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                ParameterValue val = (ParameterValue)it.next();
                ParameterDescriptor descr = (ParameterDescriptor)val.getDescriptor();
                String key = descr.getName().toString();
                String value = null;
                if (val.getValue() != null) {
                    value = val.getValue().toString();
                }
                if (value == null) {
                    value = "";
                }
                if (value == null) continue;
                defaults.put(key, value);
            }
        }
        return Collections.synchronizedMap(defaults);
    }

    public static Map toParams(GridFormatFactorySpi factory, Map params) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(params.size());
        ParameterValueGroup info = factory.createFormat().getReadParameters();
        Iterator i = params.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = CoverageStoreUtils.find(info, key).getValue();
            if (value == null) continue;
            map.put(key, value);
        }
        return Collections.synchronizedMap(map);
    }

    public static GeneralEnvelope getWGS84LonLatEnvelope(GeneralEnvelope envelope) throws IndexOutOfBoundsException, FactoryException, TransformException {
        CoordinateReferenceSystem sourceCRS = envelope.getCoordinateReferenceSystem();
        if (CRSUtilities.equalsIgnoreMetadata((Object)sourceCRS, (Object)DefaultGeographicCRS.WGS84)) {
            return new GeneralEnvelope((Envelope)envelope);
        }
        DefaultGeographicCRS targetCRS = DefaultGeographicCRS.WGS84;
        MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)true);
        GeneralEnvelope targetEnvelope = !mathTransform.isIdentity() ? CRSUtilities.transform((MathTransform)mathTransform, (Envelope)envelope) : new GeneralEnvelope((Envelope)envelope);
        targetEnvelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)targetCRS);
        return targetEnvelope;
    }
}

