/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.vfny.geoserver.global.ConfigurationException;

public class WriterHelper {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.global");
    protected Writer writer;

    protected WriterHelper() {
    }

    public WriterHelper(Writer writer) {
        this.writer = writer;
    }

    public void write(String s) throws ConfigurationException {
        try {
            this.writer.write(s);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new ConfigurationException("Write" + this.writer, e);
        }
    }

    public void writeln(String s) throws ConfigurationException {
        try {
            this.writer.write(String.valueOf(s) + "\n");
            this.writer.flush();
        }
        catch (IOException e) {
            throw new ConfigurationException("Writeln" + this.writer, e);
        }
    }

    public void openTag(String tagName) throws ConfigurationException {
        this.writeln("<" + tagName + ">");
    }

    public void openTag(String tagName, Map attributes) throws ConfigurationException {
        this.write("<" + tagName + " ");
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            if (attributes.get(s) == null) continue;
            this.write(String.valueOf(s) + " = " + "\"" + attributes.get(s).toString() + "\" ");
        }
        this.writeln(">");
    }

    public void closeTag(String tagName) throws ConfigurationException {
        this.writeln("</" + tagName + ">");
    }

    public void textTag(String tagName, String data) throws ConfigurationException {
        this.writeln("<" + tagName + ">" + data + "</" + tagName + ">");
    }

    public void valueTag(String tagName, String value) throws ConfigurationException {
        this.writeln("<" + tagName + " value = \"" + value + "\" />");
    }

    public void attrTag(String tagName, Map attributes) throws ConfigurationException {
        this.write("<" + tagName + " ");
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            if (attributes.get(s) == null) continue;
            this.write(String.valueOf(s) + " = " + "\"" + attributes.get(s).toString() + "\" ");
        }
        this.write(" />\n");
    }

    public void textTag(String tagName, Map attributes, String data) throws ConfigurationException {
        this.write("<" + tagName + " ");
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            if (attributes.get(s) == null) continue;
            this.write(String.valueOf(s) + " = " + "\"" + attributes.get(s).toString() + "\" ");
        }
        this.write(">" + data + "</" + tagName + ">");
    }

    public void comment(String comment) throws ConfigurationException {
        this.writeln("<!--");
        this.writeln(comment);
        this.writeln("-->");
    }
}

