/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.geoserver.GeoServerResourceLoader;
import org.vfny.geoserver.global.ConfigurationException;

public class GeoserverDataDirectory {
    private static GeoServerResourceLoader loader;
    private static final Logger LOGGER;
    private static boolean isTrueDataDir;

    static {
        LOGGER = Logger.getLogger("org.vfny.geoserver.global");
        isTrueDataDir = false;
    }

    public static File getGeoserverDataDirectory() {
        return loader.getBaseDirectory();
    }

    public static boolean isTrueDataDir() {
        return isTrueDataDir;
    }

    public static File findConfigDir(File root, String dirName) throws ConfigurationException {
        File configDir;
        try {
            configDir = loader.find(dirName);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        return configDir;
    }

    public static File findDataFile(URL url) {
        return GeoserverDataDirectory.findDataFile(url.getFile());
    }

    public static File findDataFile(String path) {
        File baseDir = GeoserverDataDirectory.getGeoserverDataDirectory();
        if (path.startsWith("file:")) {
            File f = new File(path = path.substring(5));
            if (f.exists()) {
                return f;
            }
            return new File(baseDir, path);
        }
        return new File(path);
    }

    public static File findConfigFile(String file) throws ConfigurationException {
        try {
            return loader.find(file);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
    }

    public static void init(ServletContext servContext) {
        if (loader == null) {
            File dataDir = null;
            try {
                String prop = System.getProperty("GEOSERVER_DATA_DIR");
                if (prop != null && !prop.equals("")) {
                    isTrueDataDir = true;
                    dataDir = new File(prop);
                    loader = new GeoServerResourceLoader(dataDir);
                    loader.addSearchLocation(new File(dataDir, "data"));
                    loader.addSearchLocation(new File(dataDir, "WEB-INF"));
                    System.out.println("----------------------------------");
                    System.out.println("- GEOSERVER_DATA_DIR: " + dataDir.getAbsolutePath());
                    System.out.println("----------------------------------");
                    return;
                }
            }
            catch (SecurityException e) {
                LOGGER.fine("Security exception occurred. This is usually not a big deal.\n" + e.getMessage());
            }
            String loc = servContext.getInitParameter("GEOSERVER_DATA_DIR");
            if (loc != null) {
                isTrueDataDir = true;
                dataDir = new File(loc);
                loader = new GeoServerResourceLoader(dataDir);
                loader.addSearchLocation(new File(dataDir, "data"));
                loader.addSearchLocation(new File(dataDir, "WEB-INF"));
                System.out.println("----------------------------------");
                System.out.println("- GEOSERVER_DATA_DIR: " + dataDir.getAbsolutePath());
                System.out.println("----------------------------------");
                return;
            }
            isTrueDataDir = false;
            String rootDir = servContext.getRealPath("/data");
            dataDir = new File(rootDir);
            loader = new GeoServerResourceLoader(dataDir);
            loader.addSearchLocation(new File(dataDir, "data"));
            loader.addSearchLocation(new File(dataDir, "WEB-INF"));
            System.out.println("----------------------------------");
            System.out.println("- GEOSERVER_DATA_DIR: " + dataDir.getAbsolutePath());
            System.out.println("----------------------------------");
            loader.addSearchLocation(new File(servContext.getRealPath("WEB-INF")));
            loader.addSearchLocation(new File(servContext.getRealPath("data")));
        }
    }
}

