/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureResults;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.LogicFilter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.GeoServerFeatureLocking;
import org.vfny.geoserver.global.GeoServerFeatureStore;

public class GeoServerFeatureSource
implements FeatureSource {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.global");
    protected FeatureSource source;
    private FeatureType schema;
    private Filter definitionQuery = Filter.NONE;
    private CoordinateReferenceSystem forcedCRS;

    GeoServerFeatureSource(FeatureSource source, FeatureType schema, Filter definitionQuery, CoordinateReferenceSystem forcedCRS) {
        this.source = source;
        this.schema = schema;
        this.definitionQuery = definitionQuery;
        this.forcedCRS = forcedCRS;
        if (this.definitionQuery == null) {
            this.definitionQuery = Filter.NONE;
        }
    }

    public static GeoServerFeatureSource create(FeatureSource featureSource, FeatureType schema, Filter definitionQuery, CoordinateReferenceSystem forcedCRS) {
        if (featureSource instanceof FeatureLocking) {
            return new GeoServerFeatureLocking((FeatureLocking)featureSource, schema, definitionQuery, forcedCRS);
        }
        if (featureSource instanceof FeatureStore) {
            return new GeoServerFeatureStore((FeatureStore)featureSource, schema, definitionQuery, forcedCRS);
        }
        return new GeoServerFeatureSource(featureSource, schema, definitionQuery, forcedCRS);
    }

    protected Query makeDefinitionQuery(Query query) throws IOException {
        if (query == Query.ALL || query.equals(Query.ALL)) {
            return query;
        }
        try {
            String handle = query.getHandle();
            int maxFeatures = query.getMaxFeatures();
            String typeName = query.getTypeName();
            String[] propNames = this.extractAllowedAttributes(query);
            Filter filter = query.getFilter();
            filter = this.makeDefinitionFilter(filter);
            return new DefaultQuery(typeName, filter, maxFeatures, propNames, handle);
        }
        catch (Exception ex) {
            throw new DataSourceException("Could not restrict the query to the definition criteria: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private String[] extractAllowedAttributes(Query query) {
        String[] propNames = null;
        if (query.retrieveAllProperties()) {
            propNames = new String[this.schema.getAttributeCount()];
            int i = 0;
            while (i < this.schema.getAttributeCount()) {
                propNames[i] = this.schema.getAttributeType(i).getName();
                ++i;
            }
        } else {
            String[] queriedAtts = query.getPropertyNames();
            int queriedAttCount = queriedAtts.length;
            LinkedList<String> allowedAtts = new LinkedList<String>();
            int i = 0;
            while (i < queriedAttCount) {
                if (this.schema.getAttributeType(queriedAtts[i]) != null) {
                    allowedAtts.add(queriedAtts[i]);
                } else {
                    LOGGER.info("queried a not allowed property: " + queriedAtts[i] + ". Ommitting it from query");
                }
                ++i;
            }
            propNames = allowedAtts.toArray(new String[allowedAtts.size()]);
        }
        return propNames;
    }

    protected Filter makeDefinitionFilter(Filter filter) throws DataSourceException {
        Filter newFilter = filter;
        try {
            if (this.definitionQuery != Filter.NONE) {
                FilterFactory ff = FilterFactoryFinder.createFilterFactory();
                newFilter = ff.createLogicFilter((short)2);
                ((LogicFilter)newFilter).addFilter(this.definitionQuery);
                ((LogicFilter)newFilter).addFilter(filter);
            }
        }
        catch (Exception ex) {
            throw new DataSourceException("Can't create the definition filter", (Throwable)ex);
        }
        return newFilter;
    }

    public DataStore getDataStore() {
        return this.source.getDataStore();
    }

    public void addFeatureListener(FeatureListener listener) {
        this.source.addFeatureListener(listener);
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.source.removeFeatureListener(listener);
    }

    public FeatureCollection getFeatures(Query query) throws IOException {
        boolean requireXferCRS;
        Query newQuery = this.makeDefinitionQuery(query);
        boolean bl = requireXferCRS = newQuery.getCoordinateSystem() == null && query.getCoordinateSystem() != null;
        if (newQuery.getCoordinateSystem() != null && query.getCoordinateSystem() != null) {
            boolean bl2 = requireXferCRS = !newQuery.getCoordinateSystem().equals(query.getCoordinateSystem());
        }
        if (requireXferCRS) {
            if (!(newQuery instanceof DefaultQuery)) {
                newQuery = new DefaultQuery(newQuery);
            }
            ((DefaultQuery)newQuery).setCoordinateSystem(query.getCoordinateSystem());
        }
        try {
            FeatureCollection fc = this.source.getFeatures(newQuery);
            if (this.forcedCRS != null) {
                return new ForceCoordinateSystemFeatureResults((FeatureResults)fc, this.forcedCRS);
            }
            return fc;
        }
        catch (SchemaException e) {
            throw new DataSourceException((Throwable)e);
        }
    }

    public FeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures((Query)new DefaultQuery(this.schema.getTypeName(), filter));
    }

    public FeatureCollection getFeatures() throws IOException {
        return this.getFeatures(Query.ALL);
    }

    public FeatureType getSchema() {
        return this.schema;
    }

    public Envelope getBounds() throws IOException {
        if (this.definitionQuery == Filter.NONE) {
            return this.source.getBounds();
        }
        DefaultQuery query = new DefaultQuery(this.getSchema().getTypeName(), this.definitionQuery);
        return this.source.getBounds((Query)query);
    }

    public Envelope getBounds(Query query) throws IOException {
        try {
            query = this.makeDefinitionQuery(query);
        }
        catch (IOException ex) {
            return null;
        }
        return this.source.getBounds(query);
    }

    public int getCount(Query query) {
        try {
            query = this.makeDefinitionQuery(query);
        }
        catch (IOException ex) {
            return -1;
        }
        try {
            return this.source.getCount(query);
        }
        catch (IOException e) {
            return 0;
        }
    }
}

