/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.geotools.catalog.GeoResource;
import org.geotools.catalog.GeoResourceInfo;
import org.geotools.catalog.Resolve;
import org.geotools.catalog.ResolveChangeEvent;
import org.geotools.catalog.ResolveChangeListener;
import org.geotools.catalog.defaults.DefaultGeoResourceInfo;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.factory.FactoryConfigurationError;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.SchemaException;
import org.geotools.feature.type.GeometricAttributeType;
import org.geotools.filter.Filter;
import org.geotools.geometry.JTS;
import org.geotools.referencing.CRS;
import org.geotools.styling.Style;
import org.geotools.util.ProgressListener;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.vfny.geoserver.global.AttributeTypeInfo;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.DataStoreInfo;
import org.vfny.geoserver.global.GeoServerFeatureLocking;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.LegendURL;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;
import org.vfny.geoserver.global.dto.DataTransferObjectFactory;
import org.vfny.geoserver.global.dto.FeatureTypeInfoDTO;
import org.vfny.geoserver.global.dto.LegendURLDTO;
import org.vfny.geoserver.util.DataStoreUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class FeatureTypeInfo
extends GlobalLayerSupertype
implements GeoResource {
    private static Hashtable SRSLookup = new Hashtable();
    private static final int DEFAULT_NUM_DECIMALS = 8;
    private String dataStoreId;
    private Envelope latLongBBox;
    private int SRS;
    private List schema;
    private String schemaName;
    private String schemaBase;
    private String typeName;
    private String wmsPath;
    private String dirName;
    private String _abstract;
    private List keywords;
    private List metadataLinks;
    private int numDecimals;
    private Filter definitionQuery = null;
    private String defaultStyle;
    private ArrayList styles;
    private String title;
    private Data data;
    private Map meta;
    private String xmlSchemaFrag;
    private FeatureType ft;
    private LegendURL legendURL;
    private File schemaFile;
    private String cacheMaxAge;
    private boolean cachingEnabled;
    private boolean forcedCRS;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public FeatureTypeInfo() {
    }

    public FeatureTypeInfo(FeatureTypeInfoDTO dto, Data data) throws ConfigurationException {
        this.data = data;
        this._abstract = dto.getAbstract();
        this.dataStoreId = dto.getDataStoreId();
        this.defaultStyle = dto.getDefaultStyle();
        this.styles = dto.getStyles();
        if (dto.getLegendURL() != null) {
            this.legendURL = new LegendURL(dto.getLegendURL());
        }
        this.definitionQuery = dto.getDefinitionQuery();
        this.dirName = dto.getDirName();
        this.keywords = dto.getKeywords();
        this.metadataLinks = dto.getMetadataLinks();
        this.latLongBBox = dto.getLatLongBBox();
        this.typeName = dto.getName();
        this.wmsPath = dto.getWmsPath();
        this.numDecimals = dto.getNumDecimals();
        List tmp = dto.getSchemaAttributes();
        this.schema = new LinkedList();
        if (tmp != null && !tmp.isEmpty()) {
            Iterator i = tmp.iterator();
            while (i.hasNext()) {
                this.schema.add(new AttributeTypeInfo((AttributeTypeInfoDTO)i.next()));
            }
        }
        this.schemaBase = dto.getSchemaBase();
        this.schemaName = dto.getSchemaName();
        this.schemaFile = dto.getSchemaFile();
        this.SRS = dto.getSRS();
        this.title = dto.getTitle();
        this.cacheMaxAge = dto.getCacheMaxAge();
        this.cachingEnabled = dto.isCachingEnabled();
    }

    Object toDTO() {
        FeatureTypeInfoDTO dto = new FeatureTypeInfoDTO();
        dto.setAbstract(this._abstract);
        dto.setDataStoreId(this.dataStoreId);
        dto.setDefaultStyle(this.defaultStyle);
        dto.setStyles(this.styles);
        if (this.legendURL != null) {
            dto.setLegendURL((LegendURLDTO)this.legendURL.toDTO());
        }
        dto.setDefinitionQuery(this.definitionQuery);
        dto.setDirName(this.dirName);
        dto.setKeywords(this.keywords);
        dto.setMetadataLinks(this.metadataLinks);
        dto.setLatLongBBox(this.latLongBBox);
        dto.setName(this.typeName);
        dto.setWmsPath(this.wmsPath);
        dto.setNumDecimals(this.numDecimals);
        LinkedList<Object> tmp = new LinkedList<Object>();
        Iterator i = this.schema.iterator();
        while (i.hasNext()) {
            tmp.add(((AttributeTypeInfo)i.next()).toDTO());
        }
        dto.setSchemaAttributes(tmp);
        dto.setSchemaBase(this.schemaBase);
        dto.setSchemaName(this.getSchemaName());
        dto.setSRS(this.SRS);
        dto.setTitle(this.title);
        dto.setCacheMaxAge(this.cacheMaxAge);
        dto.setCachingEnabled(this.cachingEnabled);
        return dto;
    }

    public int getNumDecimals() {
        return this.numDecimals;
    }

    public DataStoreInfo getDataStoreInfo() {
        return this.data.getDataStoreInfo(this.dataStoreId);
    }

    public Style getDefaultStyle() {
        return this.data.getStyle(this.defaultStyle);
    }

    public ArrayList getStyles() {
        ArrayList<Style> realStyles = new ArrayList<Style>();
        Iterator s_IT = this.styles.iterator();
        while (s_IT.hasNext()) {
            realStyles.add(this.data.getStyle((String)s_IT.next()));
        }
        return realStyles;
    }

    public boolean isEnabled() {
        return this.getDataStoreInfo() != null && this.getDataStoreInfo().isEnabled();
    }

    public String getPrefix() {
        return this.getDataStoreInfo().getNameSpace().getPrefix();
    }

    public NameSpaceInfo getNameSpace() {
        if (!this.isEnabled()) {
            throw new IllegalStateException("This featureType is not enabled");
        }
        return this.getDataStoreInfo().getNameSpace();
    }

    public String getName() {
        return String.valueOf(this.getPrefix()) + ":" + this.typeName;
    }

    public FeatureSource getFeatureSource() throws IOException {
        if (!this.isEnabled() || this.getDataStoreInfo().getDataStore() == null) {
            throw new IOException("featureType: " + this.getName() + " does not have a properly configured " + "datastore");
        }
        DataStore dataStore = this.data.getDataStoreInfo(this.dataStoreId).getDataStore();
        FeatureSource realSource = dataStore.getFeatureSource(this.typeName);
        if (this.schema == null || this.schema.isEmpty()) {
            return realSource;
        }
        return GeoServerFeatureLocking.create(realSource, this.getFeatureType(realSource), this.getDefinitionQuery(), this.forcedCRS ? this.getSRS(this.SRS) : null);
    }

    public Envelope getBoundingBox() throws IOException {
        DataStore dataStore = this.data.getDataStoreInfo(this.dataStoreId).getDataStore();
        FeatureSource realSource = dataStore.getFeatureSource(this.typeName);
        Envelope bbox = DataStoreUtils.getBoundingBoxEnvelope(realSource);
        GeometryAttributeType defaultGeometry = realSource.getSchema().getDefaultGeometry();
        CoordinateReferenceSystem declaredCRS = this.getSRS(this.SRS);
        CoordinateReferenceSystem originalCRS = defaultGeometry.getCoordinateSystem();
        try {
            if (!this.forcedCRS && defaultGeometry != null && !CRS.equalsIgnoreMetadata((Object)originalCRS, (Object)declaredCRS)) {
                MathTransform xform = CRS.transform((CoordinateReferenceSystem)originalCRS, (CoordinateReferenceSystem)declaredCRS, (boolean)true);
                bbox = JTS.transform((Envelope)bbox, (MathTransform)xform, (int)10);
            }
        }
        catch (Exception e) {
            LOGGER.severe("Could not turn the original envelope in one into the declared CRS for type " + this.typeName);
            LOGGER.severe("Original CRS is " + originalCRS);
            LOGGER.severe("Declared CRS is " + declaredCRS);
        }
        return bbox;
    }

    public Filter getDefinitionQuery() {
        return this.definitionQuery;
    }

    public Envelope getLatLongBoundingBox() throws IOException {
        if (this.latLongBBox == null) {
            return this.getBoundingBox();
        }
        return this.latLongBBox;
    }

    public String getSRS() {
        return String.valueOf(this.SRS);
    }

    public CoordinateReferenceSystem getDeclaredCRS() {
        return this.getSRS(this.SRS);
    }

    public CoordinateReferenceSystem getNativeCRS() throws IOException {
        if (this.getDataStoreInfo().getDataStore() == null) {
            throw new IOException("featureType: " + this.getName() + " does not have a properly configured " + "datastore");
        }
        DataStore dataStore = this.data.getDataStoreInfo(this.dataStoreId).getDataStore();
        FeatureSource realSource = dataStore.getFeatureSource(this.typeName);
        GeometryAttributeType dg = realSource.getSchema().getDefaultGeometry();
        if (dg == null) {
            throw new IOException("Feature type: " + this.getName() + " does not have a default geometry");
        }
        return dg.getCoordinateSystem();
    }

    private synchronized FeatureTypeInfoDTO getGeneratedDTO() throws IOException {
        return DataTransferObjectFactory.create(this.dataStoreId, this.getFeatureType());
    }

    protected String getAttribute(Element elem, String attName, boolean mandatory) throws ConfigurationException {
        Attr att = elem.getAttributeNode(attName);
        String value = null;
        if (att != null) {
            value = att.getValue();
        }
        if (mandatory) {
            if (att == null) {
                throw new ConfigurationException("element " + elem.getNodeName() + " does not contains an attribute named " + attName);
            }
            if ("".equals(value)) {
                throw new ConfigurationException("attribute " + attName + "in element " + elem.getNodeName() + " is empty");
            }
        }
        return value;
    }

    private static Envelope getLatLongBBox(String fromSrId, Envelope bbox) {
        return bbox;
    }

    public String getAbstract() {
        return this._abstract;
    }

    public List getKeywords() {
        return this.keywords;
    }

    public List getMetadataLinks() {
        return this.metadataLinks;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSchemaName() {
        if (this.schemaName == null) {
            return String.valueOf(this.typeName) + "_Type";
        }
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public String getSchemaBase() {
        return this.schemaBase;
    }

    public void setSchemaBase(String string) {
        this.schemaBase = string;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public FeatureType getFeatureType() throws IOException {
        return this.getFeatureType(this.getFeatureSource());
    }

    private FeatureType getFeatureType(FeatureSource fs) throws IOException {
        if (this.ft == null) {
            int count = 0;
            this.ft = fs.getSchema();
            URI namespace = this.ft.getNamespace();
            String[] baseNames = DataTransferObjectFactory.getRequiredBaseAttributes(this.schemaBase);
            AttributeType[] attributes = new AttributeType[this.schema.size() + baseNames.length];
            if (attributes.length > 0) {
                int errors = 0;
                while (count < baseNames.length) {
                    attributes[count - errors] = this.ft.getAttributeType(baseNames[count]);
                    if (attributes[count - errors] == null) {
                        ++errors;
                    }
                    ++count;
                }
                if (errors != 0) {
                    AttributeType[] tmp = new AttributeType[attributes.length - errors];
                    count -= errors;
                    int i = 0;
                    while (i < count) {
                        tmp[i] = attributes[i];
                        ++i;
                    }
                    attributes = tmp;
                }
                Iterator i = this.schema.iterator();
                while (i.hasNext()) {
                    AttributeTypeInfo ati = (AttributeTypeInfo)i.next();
                    String attName = ati.getName();
                    attributes[count] = this.ft.getAttributeType(attName);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("com.vividsolutions.jts.geom.Geometry");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.isAssignableFrom(attributes[count].getType())) {
                        GeometricAttributeType old = (GeometricAttributeType)attributes[count];
                        try {
                            if (old.getCoordinateSystem() == null) {
                                attributes[count] = new GeometricAttributeType(old, this.getSRS(this.SRS));
                                this.forcedCRS = true;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (attributes[count] == null) {
                        throw new IOException("the FeatureType " + this.getName() + " does not contains the configured attribute " + attName + ". Check your schema configuration");
                    }
                    ++count;
                }
                try {
                    this.ft = FeatureTypeFactory.newFeatureType((AttributeType[])attributes, (String)this.typeName, (URI)namespace);
                }
                catch (SchemaException schemaException) {
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    // empty catch block
                }
            }
        }
        return this.ft;
    }

    public DataStoreInfo getDataStoreMetaData() {
        return this.data.getDataStoreInfo(this.dataStoreId);
    }

    public List getAttributeNames() {
        List attribs = this.schema;
        if (attribs.size() != 0) {
            ArrayList<String> list = new ArrayList<String>(attribs.size());
            Iterator i = attribs.iterator();
            while (i.hasNext()) {
                AttributeTypeInfo at = (AttributeTypeInfo)i.next();
                list.add(at.getName());
            }
            return list;
        }
        ArrayList<String> list = new ArrayList<String>();
        try {
            FeatureType ftype = this.getFeatureType();
            AttributeType[] types = ftype.getAttributeTypes();
            list = new ArrayList(types.length);
            int i = 0;
            while (i < types.length) {
                list.add(types[i].getName());
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    public List getAttributes() {
        return this.schema;
    }

    public synchronized AttributeTypeInfo AttributeTypeMetaData(String attributeName) {
        AttributeTypeInfo info = null;
        if (this.schema != null) {
            Iterator i = this.schema.iterator();
            while (i.hasNext()) {
                AttributeTypeInfoDTO dto = (AttributeTypeInfoDTO)i.next();
                info = new AttributeTypeInfo(dto);
            }
            DataStore dataStore = this.data.getDataStoreInfo(this.dataStoreId).getDataStore();
            try {
                FeatureType ftype = dataStore.getSchema(this.typeName);
                info.sync(ftype.getAttributeType(attributeName));
            }
            catch (IOException ftype) {}
        } else {
            DataStore dataStore = this.data.getDataStoreInfo(this.dataStoreId).getDataStore();
            try {
                FeatureType ftype = dataStore.getSchema(this.typeName);
                info = new AttributeTypeInfo(ftype.getAttributeType(attributeName));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return info;
    }

    public boolean containsMetaData(String key) {
        return this.meta.containsKey(key);
    }

    public void putMetaData(String key, Object value) {
        this.meta.put(key, value);
    }

    public Object getMetaData(String key) {
        return this.meta.get(key);
    }

    public LegendURL getLegendURL() {
        return this.legendURL;
    }

    public File getSchemaFile() {
        return this.schemaFile;
    }

    private CoordinateReferenceSystem getSRS(int epsg) {
        CoordinateReferenceSystem result = (CoordinateReferenceSystem)SRSLookup.get(new Integer(epsg));
        if (result == null) {
            try {
                result = CRS.decode((String)("EPSG:" + epsg));
                SRSLookup.put(new Integer(epsg), result);
            }
            catch (NoSuchAuthorityCodeException e) {
                String msg = "Error looking up SRS for EPSG: " + epsg + ":" + e.getLocalizedMessage();
                LOGGER.warning(msg);
            }
            catch (FactoryException e) {
                String msg = "Error looking up SRS for EPSG: " + epsg + ":" + e.getLocalizedMessage();
                LOGGER.warning(msg);
            }
        }
        return result;
    }

    public String getDirName() {
        return this.dirName;
    }

    public String getWmsPath() {
        return this.wmsPath;
    }

    public void setWmsPath(String wmsPath) {
        this.wmsPath = wmsPath;
    }

    public String getCacheMaxAge() {
        return this.cacheMaxAge;
    }

    public void setCacheMaxAge(String cacheMaxAge) {
        this.cacheMaxAge = cacheMaxAge;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    public boolean canResolve(Class adaptee) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.geotools.feature.FeatureType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(adaptee)) {
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.geotools.catalog.Service");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz2.isAssignableFrom(adaptee)) {
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("org.geotools.catalog.GeoResourceInfo");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz3.isAssignableFrom(adaptee)) {
                    return false;
                }
            }
        }
        return true;
    }

    public Object resolve(Class adaptee, ProgressListener monitor) throws IOException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.geotools.feature.FeatureType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(adaptee)) {
            return this.getFeatureType();
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.geotools.catalog.Service");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isAssignableFrom(adaptee)) {
            return this.getDataStoreInfo();
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.geotools.catalog.GeoResourceInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.isAssignableFrom(adaptee)) {
            return this.getInfo(monitor);
        }
        return null;
    }

    public GeoResourceInfo getInfo(ProgressListener monitor) throws IOException {
        return new DefaultGeoResourceInfo(this.getTitle(), this.getTypeName(), null, this.getSchemaFile() != null ? this.getSchemaFile().toURI() : null, this.getBoundingBox(), this.getSRS(this.SRS), null, null);
    }

    public Resolve parent(ProgressListener monitor) throws IOException {
        return this.getDataStoreInfo();
    }

    public List members(ProgressListener monitor) throws IOException {
        return null;
    }

    public Resolve.Status getStatus() {
        if (this.isEnabled()) {
            return Resolve.Status.CONNECTED;
        }
        return Resolve.Status.NOTCONNECTED;
    }

    public Throwable getMessage() {
        return null;
    }

    public URI getIdentifier() {
        URI uri = this.getDataStoreInfo().getIdentifier();
        try {
            return new URI(uri.getScheme(), uri.getHost(), uri.getPath(), this.getTypeName());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public void addListener(ResolveChangeListener listener) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeListener(ResolveChangeListener listener) {
    }

    public void fire(ResolveChangeEvent event) {
    }
}

