/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config;

import org.vfny.geoserver.global.dto.NameSpaceInfoDTO;

public class NameSpaceConfig {
    private String prefix;
    private String uri;
    private boolean _default;

    public NameSpaceConfig() {
        this.prefix = "";
        this.uri = "";
        this._default = false;
    }

    public NameSpaceConfig(NameSpaceInfoDTO ns) {
        if (ns == null) {
            throw new NullPointerException("");
        }
        this.prefix = ns.getPrefix();
        this.uri = ns.getUri();
        this._default = ns.isDefault();
    }

    public void update(NameSpaceInfoDTO dto) {
        if (dto == null) {
            throw new NullPointerException("NameSpace Data Transfer Object required");
        }
        NameSpaceInfoDTO ns = dto;
        this.prefix = ns.getPrefix();
        this.uri = ns.getUri();
        this._default = ns.isDefault();
    }

    public NameSpaceInfoDTO toDTO() {
        NameSpaceInfoDTO nsDto = new NameSpaceInfoDTO();
        nsDto.setDefault(this._default);
        nsDto.setPrefix(this.prefix);
        nsDto.setUri(this.uri);
        return nsDto;
    }

    public boolean isDefault() {
        return this._default;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUri() {
        return this.uri;
    }

    public void setDefault(boolean b) {
        this._default = b;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void setUri(String string) {
        this.uri = string;
    }
}

