/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config;

import org.geotools.feature.AttributeType;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;
import org.vfny.geoserver.global.xml.NameSpaceElement;
import org.vfny.geoserver.global.xml.NameSpaceTranslator;
import org.vfny.geoserver.global.xml.NameSpaceTranslatorFactory;

public class AttributeTypeInfoConfig {
    public static final String TYPE_FRAGMENT = "(xml fragment)";
    private String fragment;
    private int maxOccurs;
    private int minOccurs;
    private final String name;
    private boolean nillable;
    public String type;

    public AttributeTypeInfoConfig(AttributeType attributeType) {
        this.name = attributeType.getName();
        this.minOccurs = 1;
        this.maxOccurs = 1;
        NameSpaceTranslatorFactory nsFactory = NameSpaceTranslatorFactory.getInstance();
        NameSpaceTranslator nst = nsFactory.getNameSpaceTranslator("xs");
        NameSpaceElement nse = nst.getElement(this.name);
        if (nse == null) {
            nse = nst.getDefaultElement(attributeType.getType());
        }
        if (nse == null && (nse = (nst = nsFactory.getNameSpaceTranslator("gml")).getElement(this.name)) == null) {
            nse = nst.getDefaultElement(attributeType.getType());
        }
        this.fragment = "<!-- definition for " + attributeType.getType() + " -->";
        if (nse == null) {
            this.type = TYPE_FRAGMENT;
        } else {
            this.type = nse.getTypeDefName();
            this.fragment = "";
        }
    }

    public AttributeTypeInfoConfig(AttributeTypeInfoDTO dto) {
        this.name = dto.getName();
        if (dto.isComplex()) {
            this.type = TYPE_FRAGMENT;
            this.fragment = dto.getType();
        } else {
            this.type = dto.getType();
            this.fragment = "";
        }
        this.minOccurs = dto.getMinOccurs();
        this.maxOccurs = dto.getMaxOccurs();
        this.nillable = dto.isNillable();
    }

    public String getFragment() {
        return this.fragment;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }

    public void setMaxOccurs(int max) {
        this.maxOccurs = max;
    }

    public void setMinOccurs(int min) {
        this.minOccurs = min;
    }

    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AttributeTypeInfoDTO toDTO() {
        AttributeTypeInfoDTO dto = new AttributeTypeInfoDTO();
        dto.setNillable(this.nillable);
        dto.setName(this.name);
        dto.setMaxOccurs(this.maxOccurs);
        dto.setMinOccurs(this.minOccurs);
        if (this.type != TYPE_FRAGMENT) {
            dto.setComplex(false);
            dto.setType(this.type);
        } else {
            dto.setComplex(true);
            dto.setType(this.fragment);
        }
        return dto;
    }
}

