/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util.requests;

public class EncodingInfo {
    private String fEncoding = null;
    private Boolean fIsBigEndian = null;
    private boolean fHasBOM;

    public EncodingInfo() {
    }

    public EncodingInfo(String encoding, Boolean isBigEndian) {
        this.fEncoding = encoding;
        this.fIsBigEndian = isBigEndian;
        this.fHasBOM = false;
    }

    public EncodingInfo(String encoding, Boolean isBigEndian, boolean hasBOM) {
        this.fEncoding = encoding;
        this.fIsBigEndian = isBigEndian;
        this.fHasBOM = hasBOM;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncoding(String encoding) {
        this.fEncoding = encoding;
    }

    public Boolean isBigEndian() {
        return this.fIsBigEndian;
    }

    public boolean hasBOM() {
        return this.fHasBOM;
    }

    public void copyFrom(EncodingInfo encInfo) {
        this.fEncoding = encInfo.getEncoding();
        this.fIsBigEndian = encInfo.isBigEndian();
        this.fHasBOM = encInfo.hasBOM();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(null == this.fEncoding ? "[NULL]" : this.fEncoding);
        if (null != this.fIsBigEndian) {
            sb.append(this.fIsBigEndian != false ? " BIG ENDIAN" : " LITTLE ENDIAN");
        }
        if (this.fHasBOM) {
            sb.append(" with BOM");
        }
        return sb.toString();
    }
}

