/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.UserContainer;

public final class Requests {
    public static final String PROXY_PARAM = "PROXY_BASE_URL";

    public static String getBaseUrl(HttpServletRequest httpServletRequest, GeoServer geoserver) {
        String url = geoserver.getProxyBaseUrl();
        if (geoserver != null && url != null) {
            url = Requests.concatUrl(url, httpServletRequest.getContextPath());
        }
        if (url == null || url.trim().length() == 0) {
            if (httpServletRequest != null) {
                url = httpServletRequest.getSession().getServletContext().getInitParameter(PROXY_PARAM);
            }
            url = url == null || url.trim().length() == 0 ? httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + httpServletRequest.getContextPath() + "/" : Requests.concatUrl(url, httpServletRequest.getContextPath());
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    public static String getBaseJspUrl(HttpServletRequest httpServletRequest, GeoServer geoserver) {
        String url = geoserver.getProxyBaseUrl();
        if (geoserver != null && url != null) {
            url = Requests.concatUrl(url, httpServletRequest.getRequestURI());
        }
        if (url == null || url.trim().length() == 0) {
            if (httpServletRequest != null) {
                url = httpServletRequest.getSession().getServletContext().getInitParameter(PROXY_PARAM);
            }
            url = url == null || url.trim().length() == 0 ? httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + httpServletRequest.getRequestURI() + "/" : Requests.concatUrl(url, httpServletRequest.getRequestURI());
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String concatUrl(String url, String contextPath) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        return url + "/" + contextPath;
    }

    public static String getSchemaBaseUrl(HttpServletRequest httpServletRequest, GeoServer geoserver) {
        return Requests.getBaseUrl(httpServletRequest, geoserver) + "schemas/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserContainer getUserContainer(HttpServletRequest request) {
        HttpSession session;
        HttpSession httpSession = session = request.getSession();
        synchronized (httpSession) {
            UserContainer user = (UserContainer)session.getAttribute("GEOSERVER.USER");
            return user;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoggedIn(HttpServletRequest request) {
        HttpSession session;
        HttpSession httpSession = session = request.getSession();
        synchronized (httpSession) {
            UserContainer user = (UserContainer)session.getAttribute("GEOSERVER.USER");
            return user != null;
        }
    }

    public static void logOut(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.removeAttribute("GEOSERVER.USER");
    }
}

