/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;

public class PartialBufferedOutputStream
extends OutputStream {
    public static final int DEFAULT_BUFFER_SIZE = 50;
    private static final int KILOBYTE = 1024;
    private static int BUFFER_SIZE = 1024;
    private boolean sendToUser = false;
    private ByteArrayOutputStream out_buffer;
    private OutputStream out_real;
    private HttpServletResponse response;
    private boolean closed = false;

    public PartialBufferedOutputStream(HttpServletResponse response) {
        this(response, 50);
    }

    public PartialBufferedOutputStream(HttpServletResponse response, int kilobytes) {
        if (kilobytes < 1) {
            throw new IllegalArgumentException("Buffer size not greater than 0: " + kilobytes);
        }
        BUFFER_SIZE = 1024 * kilobytes;
        this.response = response;
        this.out_buffer = new ByteArrayOutputStream(BUFFER_SIZE);
    }

    public int bufferCapacity() {
        return BUFFER_SIZE / 1024;
    }

    public int bufferSize() {
        return this.out_buffer.size();
    }

    public synchronized void write(int b) throws IOException {
        if (this.closed) {
            return;
        }
        if (this.sendToUser || this.out_buffer.size() >= BUFFER_SIZE) {
            if (this.sendToUser) {
                this.out_real.write(b);
            } else {
                this.sendToUser = true;
                this.out_real = new BufferedOutputStream((OutputStream)this.response.getOutputStream());
                this.out_buffer.writeTo(this.out_real);
                this.out_buffer.reset();
                this.out_real.write(b);
            }
        } else {
            this.out_buffer.write(b);
        }
    }

    public synchronized void flush() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.sendToUser && this.out_real != null) {
            this.out_real.flush();
        }
    }

    public synchronized void forceFlush() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.out_buffer != null && this.out_buffer.size() > 0 && !this.sendToUser) {
            if (this.out_real == null) {
                this.out_real = new BufferedOutputStream((OutputStream)this.response.getOutputStream());
            }
            this.out_buffer.writeTo(this.out_real);
            this.out_buffer = null;
        }
        if (this.out_real != null) {
            this.out_real.flush();
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.out_buffer.close();
        this.out_buffer = null;
        this.out_real = null;
        this.response = null;
    }

    public synchronized boolean abort() throws IOException {
        if (this.out_buffer != null && this.out_buffer.size() < BUFFER_SIZE) {
            this.out_buffer.close();
            this.out_buffer = null;
            this.out_real = null;
            this.response = null;
            return true;
        }
        this.out_real = null;
        this.response = null;
        return false;
    }
}

