/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.xml;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.geoserver.util.ReaderUtils;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterDOMParser;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;
import org.vfny.geoserver.global.dto.ContactDTO;
import org.vfny.geoserver.global.dto.DataDTO;
import org.vfny.geoserver.global.dto.DataStoreInfoDTO;
import org.vfny.geoserver.global.dto.FeatureTypeInfoDTO;
import org.vfny.geoserver.global.dto.GeoServerDTO;
import org.vfny.geoserver.global.dto.LegendURLDTO;
import org.vfny.geoserver.global.dto.NameSpaceInfoDTO;
import org.vfny.geoserver.global.dto.ServiceDTO;
import org.vfny.geoserver.global.dto.StyleDTO;
import org.vfny.geoserver.global.dto.WFSDTO;
import org.vfny.geoserver.global.dto.WMSDTO;
import org.vfny.geoserver.global.xml.NameSpaceElement;
import org.vfny.geoserver.global.xml.NameSpaceTranslator;
import org.vfny.geoserver.global.xml.NameSpaceTranslatorFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLConfigReader {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.global");
    private File root;
    private boolean initialized = false;
    private WMSDTO wms;
    private WFSDTO wfs;
    private GeoServerDTO geoServer;
    private DataDTO data;
    ServletContext context;

    protected XMLConfigReader(ServletContext context) {
        this.context = context;
        this.wms = new WMSDTO();
        this.wfs = new WFSDTO();
        this.geoServer = new GeoServerDTO();
        this.data = new DataDTO();
        this.root = new File(".");
    }

    public XMLConfigReader(File root, ServletContext context) throws ConfigurationException {
        this.root = root;
        this.context = context;
        this.wms = new WMSDTO();
        this.wfs = new WFSDTO();
        this.geoServer = new GeoServerDTO();
        this.data = new DataDTO();
        this.load();
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void load() throws ConfigurationException {
        try {
            this.root = ReaderUtils.checkFile((File)this.root, (boolean)true);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        File servicesFile = GeoserverDataDirectory.findConfigFile("services.xml");
        this.loadServices(servicesFile);
        File catalogFile = GeoserverDataDirectory.findConfigFile("catalog.xml");
        File featureTypeDir = GeoserverDataDirectory.findConfigDir(this.root, "featureTypes/");
        File styleDir = GeoserverDataDirectory.findConfigDir(this.root, "styles/");
        this.loadCatalog(catalogFile, featureTypeDir, styleDir);
    }

    protected void loadServices(File configFile) throws ConfigurationException {
        LOGGER.config("Loading configuration file: " + configFile);
        Element configElem = null;
        try {
            FileReader fr = new FileReader(configFile);
            configElem = ReaderUtils.parse((Reader)fr);
            fr.close();
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException(e);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        LOGGER.config("parsing configuration documents");
        Element elem = (Element)configElem.getElementsByTagName("global").item(0);
        this.loadGlobal(elem);
        NodeList configuredServices = configElem.getElementsByTagName("service");
        int nServices = configuredServices.getLength();
        for (int i = 0; i < nServices; ++i) {
            elem = (Element)configuredServices.item(i);
            String serviceType = elem.getAttribute("type");
            if ("WFS".equalsIgnoreCase(serviceType)) {
                this.loadWFS(elem);
                continue;
            }
            if ("WMS".equalsIgnoreCase(serviceType)) {
                this.loadWMS(elem);
                continue;
            }
            if ("Z39.50".equalsIgnoreCase(serviceType)) continue;
            throw new ConfigurationException("Unknown service type: " + serviceType);
        }
    }

    protected void loadCatalog(File catalogFile, File featureTypeDir, File styleDir) throws ConfigurationException {
        Element catalogElem = null;
        try {
            LOGGER.config("Loading configuration file: " + catalogFile);
            FileReader fr = new FileReader(catalogFile);
            catalogElem = ReaderUtils.parse((Reader)fr);
            fr.close();
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException(e);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        try {
            this.data.setNameSpaces(this.loadNameSpaces(ReaderUtils.getChildElement((Element)catalogElem, (String)"namespaces", (boolean)true)));
            this.setDefaultNS();
            this.data.setDataStores(this.loadDataStores(ReaderUtils.getChildElement((Element)catalogElem, (String)"datastores", (boolean)true)));
            this.data.setStyles(this.loadStyles(ReaderUtils.getChildElement((Element)catalogElem, (String)"styles", (boolean)false), styleDir));
            this.data.setFeaturesTypes(this.loadFeatureTypes(featureTypeDir));
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    protected void setDefaultNS() {
        Iterator i = this.data.getNameSpaces().values().iterator();
        while (i.hasNext()) {
            NameSpaceInfoDTO ns = (NameSpaceInfoDTO)i.next();
            if (!ns.isDefault()) continue;
            this.data.setDefaultNameSpacePrefix(ns.getPrefix());
            LOGGER.finer("set default namespace pre to " + ns.getPrefix());
            return;
        }
    }

    protected Level getLoggingLevel(Element globalConfigElem) throws ConfigurationException {
        Level level = Logger.getLogger("org.vfny.geoserver").getLevel();
        Element levelElem = ReaderUtils.getChildElement((Element)globalConfigElem, (String)"loggingLevel");
        if (levelElem != null) {
            String levelName = levelElem.getFirstChild().getNodeValue();
            try {
                level = Level.parse(levelName);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning("illegal loggingLevel name: " + levelName);
            }
        } else {
            LOGGER.config("No loggingLevel found, using default logging.properties setting");
        }
        return level;
    }

    protected void loadGlobal(Element globalElem) throws ConfigurationException {
        try {
            String adminPassword;
            String logLocation;
            this.geoServer = new GeoServerDTO();
            LOGGER.finer("parsing global configuration parameters");
            Level loggingLevel = this.getLoggingLevel(globalElem);
            this.geoServer.setLoggingLevel(loggingLevel);
            boolean loggingToFile = false;
            Element elem = null;
            elem = ReaderUtils.getChildElement((Element)globalElem, (String)"loggingToFile", (boolean)false);
            if (elem != null) {
                loggingToFile = ReaderUtils.getBooleanAttribute((Element)elem, (String)"value", (boolean)false, (boolean)false);
            }
            if ((logLocation = ReaderUtils.getChildText((Element)globalElem, (String)"logLocation")) != null && "".equals(logLocation.trim())) {
                logLocation = null;
            }
            this.geoServer.setLoggingToFile(loggingToFile);
            this.geoServer.setLogLocation(logLocation);
            try {
                GeoServer.initLogging(loggingLevel, loggingToFile, logLocation, this.context);
            }
            catch (IOException e) {
                throw new ConfigurationException(e);
            }
            LOGGER.config("logging level is " + loggingLevel);
            if (logLocation != null) {
                LOGGER.config("logging to " + logLocation);
            }
            elem = ReaderUtils.getChildElement((Element)globalElem, (String)"ContactInformation");
            this.geoServer.setContact(this.loadContact(elem));
            elem = ReaderUtils.getChildElement((Element)globalElem, (String)"verbose", (boolean)false);
            if (elem != null) {
                this.geoServer.setVerbose(ReaderUtils.getBooleanAttribute((Element)elem, (String)"value", (boolean)false, (boolean)true));
            }
            if ((elem = ReaderUtils.getChildElement((Element)globalElem, (String)"maxFeatures")) != null) {
                this.geoServer.setMaxFeatures(ReaderUtils.getIntAttribute((Element)elem, (String)"value", (boolean)true, (int)this.geoServer.getMaxFeatures()));
            }
            LOGGER.config("maxFeatures is " + this.geoServer.getMaxFeatures());
            elem = ReaderUtils.getChildElement((Element)globalElem, (String)"numDecimals");
            if (elem != null) {
                this.geoServer.setNumDecimals(ReaderUtils.getIntAttribute((Element)elem, (String)"value", (boolean)true, (int)this.geoServer.getNumDecimals()));
            }
            LOGGER.config("numDecimals returning is " + this.geoServer.getNumDecimals());
            elem = ReaderUtils.getChildElement((Element)globalElem, (String)"charSet");
            if (elem != null) {
                String chSet = ReaderUtils.getAttribute((Element)elem, (String)"value", (boolean)true);
                try {
                    Charset cs = Charset.forName(chSet);
                    this.geoServer.setCharSet(cs);
                    LOGGER.finer("charSet: " + cs.displayName());
                }
                catch (Exception ex) {
                    LOGGER.info(ex.getMessage());
                }
            }
            LOGGER.config("charSet is " + this.geoServer.getCharSet());
            String schemaBaseUrl = ReaderUtils.getChildText((Element)globalElem, (String)"SchemaBaseUrl");
            if (schemaBaseUrl != null) {
                this.geoServer.setSchemaBaseUrl(schemaBaseUrl);
            } else {
                this.geoServer.setSchemaBaseUrl(this.root.toString() + "/data/capabilities/");
            }
            String proxyBaseUrl = ReaderUtils.getChildText((Element)globalElem, (String)"ProxyBaseUrl");
            if (proxyBaseUrl != null) {
                this.geoServer.setProxyBaseUrl(proxyBaseUrl);
            } else {
                this.geoServer.setSchemaBaseUrl(null);
            }
            String adminUserName = ReaderUtils.getChildText((Element)globalElem, (String)"adminUserName");
            if (adminUserName != null) {
                this.geoServer.setAdminUserName(adminUserName);
            }
            if ((adminPassword = ReaderUtils.getChildText((Element)globalElem, (String)"adminPassword")) != null) {
                this.geoServer.setAdminPassword(adminPassword);
            }
            if ((elem = ReaderUtils.getChildElement((Element)globalElem, (String)"verboseExceptions", (boolean)false)) != null) {
                this.geoServer.setVerboseExceptions(ReaderUtils.getBooleanAttribute((Element)elem, (String)"value", (boolean)false, (boolean)true));
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    protected ContactDTO loadContact(Element contactInfoElement) throws ConfigurationException {
        ContactDTO c = new ContactDTO();
        if (contactInfoElement == null) {
            return c;
        }
        Element elem = ReaderUtils.getChildElement((Element)contactInfoElement, (String)"ContactPersonPrimary");
        if (elem != null) {
            c.setContactPerson(ReaderUtils.getChildText((Element)elem, (String)"ContactPerson"));
            c.setContactOrganization(ReaderUtils.getChildText((Element)elem, (String)"ContactOrganization"));
        }
        c.setContactPosition(ReaderUtils.getChildText((Element)contactInfoElement, (String)"ContactPosition"));
        elem = ReaderUtils.getChildElement((Element)contactInfoElement, (String)"ContactAddress");
        if (elem != null) {
            c.setAddressType(ReaderUtils.getChildText((Element)elem, (String)"AddressType"));
            c.setAddress(ReaderUtils.getChildText((Element)elem, (String)"Address"));
            c.setAddressCity(ReaderUtils.getChildText((Element)elem, (String)"City"));
            c.setAddressState(ReaderUtils.getChildText((Element)elem, (String)"StateOrProvince"));
            c.setAddressPostalCode(ReaderUtils.getChildText((Element)elem, (String)"PostCode"));
            c.setAddressCountry(ReaderUtils.getChildText((Element)elem, (String)"Country"));
        }
        c.setContactVoice(ReaderUtils.getChildText((Element)contactInfoElement, (String)"ContactVoiceTelephone"));
        c.setContactFacsimile(ReaderUtils.getChildText((Element)contactInfoElement, (String)"ContactFacsimileTelephone"));
        c.setContactEmail(ReaderUtils.getChildText((Element)contactInfoElement, (String)"ContactElectronicMailAddress"));
        c.setOnlineResource(ReaderUtils.getChildText((Element)contactInfoElement, (String)"ContactOnlineResource"));
        return c;
    }

    protected void loadWFS(Element wfsElement) throws ConfigurationException {
        this.wfs = new WFSDTO();
        try {
            this.wfs.setFeatureBounding(ReaderUtils.getBooleanAttribute((Element)ReaderUtils.getChildElement((Element)wfsElement, (String)"featureBounding"), (String)"value", (boolean)false, (boolean)false));
            Element elem = ReaderUtils.getChildElement((Element)wfsElement, (String)"srsXmlStyle", (boolean)false);
            LOGGER.config("reading srsXmlStyle: " + elem);
            if (elem != null) {
                this.wfs.setSrsXmlStyle(ReaderUtils.getBooleanAttribute((Element)elem, (String)"value", (boolean)false, (boolean)true));
                LOGGER.fine("set srsXmlStyle to " + ReaderUtils.getBooleanAttribute((Element)elem, (String)"value", (boolean)false, (boolean)true));
            }
            String serviceLevelValue = ReaderUtils.getChildText((Element)wfsElement, (String)"serviceLevel");
            int serviceLevel = 31;
            if (serviceLevelValue != null && !serviceLevelValue.equals("")) {
                LOGGER.finer("reading serviceLevel: " + serviceLevelValue);
                if (serviceLevelValue.equalsIgnoreCase("basic")) {
                    serviceLevel = 1;
                } else if (serviceLevelValue.equalsIgnoreCase("complete")) {
                    serviceLevel = 31;
                } else if (serviceLevelValue.equalsIgnoreCase("transactional")) {
                    serviceLevel = 15;
                } else {
                    try {
                        serviceLevel = Integer.parseInt(serviceLevelValue);
                    }
                    catch (NumberFormatException nfe) {
                        String mesg = "Could not parse serviceLevel.  It should be one of Basic, Complete, or Transactional or else an integer value";
                        throw new ConfigurationException(mesg, nfe);
                    }
                }
            } else {
                serviceLevel = ReaderUtils.getIntAttribute((Element)ReaderUtils.getChildElement((Element)wfsElement, (String)"serviceLevel"), (String)"value", (boolean)false, (int)31);
            }
            LOGGER.finer("setting service level to " + serviceLevel);
            this.wfs.setServiceLevel(serviceLevel);
            Element e = ReaderUtils.getChildElement((Element)wfsElement, (String)"citeConformanceHacks");
            if (e != null) {
                String text = ReaderUtils.getChildText((Element)wfsElement, (String)"citeConformanceHacks");
                boolean citeConformanceHacks = Boolean.valueOf(text);
                this.wfs.setCiteConformanceHacks(citeConformanceHacks);
                LOGGER.finer("setting citeConformanceHacks to " + citeConformanceHacks);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        ServiceDTO s = this.loadService(wfsElement);
        this.wfs.setService(s);
    }

    protected void loadWMS(Element wmsElement) throws ConfigurationException {
        this.wms = new WMSDTO();
        this.wms.setService(this.loadService(wmsElement));
        this.wms.setSvgRenderer(ReaderUtils.getChildText((Element)wmsElement, (String)"svgRenderer"));
        this.wms.setSvgAntiAlias(!"false".equals(ReaderUtils.getChildText((Element)wmsElement, (String)"svgAntiAlias")));
        this.loadBaseMapLayers(wmsElement);
    }

    private void loadBaseMapLayers(Element wmsElement) {
        HashMap<String, String> layerMap = new HashMap<String, String>();
        HashMap<String, String> styleMap = new HashMap<String, String>();
        Element groupBase = ReaderUtils.getChildElement((Element)wmsElement, (String)"BaseMapGroups");
        if (groupBase == null) {
            LOGGER.info("No baseMap groups defined yet");
            return;
        }
        Element[] groups = ReaderUtils.getChildElements((Element)groupBase, (String)"BaseMapGroup");
        for (int i = 0; i < groups.length; ++i) {
            Element group = groups[i];
            try {
                String title = ReaderUtils.getAttribute((Element)group, (String)"baseMapTitle", (boolean)true);
                String layers = ReaderUtils.getChildText((Element)group, (String)"baseMapLayers");
                String styles = ReaderUtils.getChildText((Element)group, (String)"baseMapStyles");
                layerMap.put(title, layers);
                styleMap.put(title, styles);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.wms.setBaseMapLayers(layerMap);
        this.wms.setBaseMapStyles(styleMap);
    }

    protected ServiceDTO loadService(Element serviceRoot) throws ConfigurationException {
        ServiceDTO s = new ServiceDTO();
        try {
            s.setName(ReaderUtils.getChildText((Element)serviceRoot, (String)"name", (boolean)true));
            s.setTitle(ReaderUtils.getChildText((Element)serviceRoot, (String)"title", (boolean)false));
            s.setAbstract(ReaderUtils.getChildText((Element)serviceRoot, (String)"abstract"));
            s.setKeywords(ReaderUtils.getKeyWords((Element)ReaderUtils.getChildElement((Element)serviceRoot, (String)"keywords")));
            s.setMetadataLink(XMLConfigReader.getMetaDataLink(ReaderUtils.getChildElement((Element)serviceRoot, (String)"metadataLink")));
            s.setFees(ReaderUtils.getChildText((Element)serviceRoot, (String)"fees"));
            s.setAccessConstraints(ReaderUtils.getChildText((Element)serviceRoot, (String)"accessConstraints"));
            s.setMaintainer(ReaderUtils.getChildText((Element)serviceRoot, (String)"maintainer"));
            s.setEnabled(ReaderUtils.getBooleanAttribute((Element)serviceRoot, (String)"enabled", (boolean)false, (boolean)true));
            s.setStrategy(ReaderUtils.getChildText((Element)serviceRoot, (String)"serviceStrategy"));
            s.setPartialBufferSize(ReaderUtils.getIntAttribute((Element)serviceRoot, (String)"partialBufferSize", (boolean)false, (int)0));
            try {
                s.setOnlineResource(new URL(ReaderUtils.getChildText((Element)serviceRoot, (String)"onlineResource", (boolean)true)));
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException(e);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        return s;
    }

    protected Map loadNameSpaces(Element nsRoot) throws ConfigurationException {
        NodeList nsList = nsRoot.getElementsByTagName("namespace");
        int nsCount = nsList.getLength();
        HashMap<String, NameSpaceInfoDTO> nameSpaces = new HashMap<String, NameSpaceInfoDTO>(nsCount);
        try {
            for (int i = 0; i < nsCount; ++i) {
                Element elem = (Element)nsList.item(i);
                NameSpaceInfoDTO ns = new NameSpaceInfoDTO();
                ns.setUri(ReaderUtils.getAttribute((Element)elem, (String)"uri", (boolean)true));
                ns.setPrefix(ReaderUtils.getAttribute((Element)elem, (String)"prefix", (boolean)true));
                ns.setDefault(ReaderUtils.getBooleanAttribute((Element)elem, (String)"default", (boolean)false, (boolean)false) || nsCount == 1);
                LOGGER.config("added namespace " + ns);
                nameSpaces.put(ns.getPrefix(), ns);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        return nameSpaces;
    }

    protected Map loadStyles(Element stylesElem, File baseDir) throws ConfigurationException {
        HashMap<String, StyleDTO> styles = new HashMap<String, StyleDTO>();
        NodeList stylesList = null;
        if (stylesElem != null) {
            stylesList = stylesElem.getElementsByTagName("style");
        }
        if (stylesList == null || stylesList.getLength() == 0) {
            StyleDTO s = new StyleDTO();
            s.setId("normal");
            s.setFilename(new File(baseDir, "normal.sld"));
            s.setDefault(true);
            styles.put("normal", s);
            return styles;
        }
        int styleCount = stylesList.getLength();
        try {
            for (int i = 0; i < styleCount; ++i) {
                Element styleElem = (Element)stylesList.item(i);
                StyleDTO s = new StyleDTO();
                s.setId(ReaderUtils.getAttribute((Element)styleElem, (String)"id", (boolean)true));
                s.setFilename(new File(baseDir, ReaderUtils.getAttribute((Element)styleElem, (String)"filename", (boolean)true)));
                s.setDefault(ReaderUtils.getBooleanAttribute((Element)styleElem, (String)"default", (boolean)false, (boolean)false));
                styles.put(s.getId(), s);
                LOGGER.config("Loaded style " + s.getId());
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        return styles;
    }

    protected Map loadDataStores(Element dsRoot) throws ConfigurationException {
        HashMap<String, DataStoreInfoDTO> dataStores = new HashMap<String, DataStoreInfoDTO>();
        NodeList dsElements = dsRoot.getElementsByTagName("datastore");
        int dsCnt = dsElements.getLength();
        for (int i = 0; i < dsCnt; ++i) {
            Element dsElem = (Element)dsElements.item(i);
            DataStoreInfoDTO dsConfig = this.loadDataStore(dsElem);
            if (dataStores.containsKey(dsConfig.getId())) {
                throw new ConfigurationException("duplicated datastore id: " + this.data.getNameSpaces().get(dsConfig.getNameSpaceId()));
            }
            dataStores.put(dsConfig.getId(), dsConfig);
        }
        return dataStores;
    }

    protected DataStoreInfoDTO loadDataStore(Element dsElem) throws ConfigurationException {
        DataStoreInfoDTO ds = new DataStoreInfoDTO();
        try {
            LOGGER.finer("creating a new DataStoreDTO configuration");
            ds.setId(ReaderUtils.getAttribute((Element)dsElem, (String)"id", (boolean)true));
            String namespacePrefix = ReaderUtils.getAttribute((Element)dsElem, (String)"namespace", (boolean)true);
            if (!this.data.getNameSpaces().containsKey(namespacePrefix)) {
                String msg = "there is no namespace defined for datatasore '" + namespacePrefix + "'";
                throw new ConfigurationException(msg);
            }
            ds.setNameSpaceId(namespacePrefix);
            ds.setEnabled(ReaderUtils.getBooleanAttribute((Element)dsElem, (String)"enabled", (boolean)false, (boolean)true));
            ds.setTitle(ReaderUtils.getChildText((Element)dsElem, (String)"title", (boolean)false));
            ds.setAbstract(ReaderUtils.getChildText((Element)dsElem, (String)"description", (boolean)false));
            LOGGER.finer("loading connection parameters for DataStoreDTO " + ds.getNameSpaceId());
            ds.setConnectionParams(this.loadConnectionParams(ReaderUtils.getChildElement((Element)dsElem, (String)"connectionParams", (boolean)true)));
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        LOGGER.config("Loaded datastore " + ds.getId());
        return ds;
    }

    protected Map loadConnectionParams(Element connElem) throws ConfigurationException {
        HashMap<String, String> connectionParams = new HashMap<String, String>();
        if (connElem == null) {
            return connectionParams;
        }
        NodeList paramElems = connElem.getElementsByTagName("parameter");
        int pCount = paramElems.getLength();
        try {
            for (int i = 0; i < pCount; ++i) {
                Element param = (Element)paramElems.item(i);
                String paramKey = ReaderUtils.getAttribute((Element)param, (String)"name", (boolean)true);
                String paramValue = ReaderUtils.getAttribute((Element)param, (String)"value", (boolean)false);
                connectionParams.put(paramKey, paramValue);
                LOGGER.finer("added parameter " + paramKey + ": '" + paramValue + "'");
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        return connectionParams;
    }

    protected Map loadFeatureTypes(File featureTypeRoot) throws ConfigurationException {
        LOGGER.finest("examining: " + featureTypeRoot.getAbsolutePath());
        LOGGER.finest("is dir: " + featureTypeRoot.isDirectory());
        if (!featureTypeRoot.isDirectory()) {
            throw new IllegalArgumentException("featureTypeRoot must be a directoy");
        }
        File[] directories = featureTypeRoot.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        HashMap<String, FeatureTypeInfoDTO> map = new HashMap<String, FeatureTypeInfoDTO>();
        int n = directories.length;
        for (int i = 0; i < n; ++i) {
            File info = new File(directories[i], "info.xml");
            if (!info.exists() || !info.isFile()) continue;
            LOGGER.finer("Info dir:" + info);
            FeatureTypeInfoDTO dto = this.loadFeature(info);
            String ftName = null;
            try {
                ftName = URLDecoder.decode(dto.getKey(), "UTF-8");
                LOGGER.info("Decoding file name: " + ftName);
            }
            catch (UnsupportedEncodingException e) {
                throw new ConfigurationException(e);
            }
            map.put(ftName, dto);
        }
        return map;
    }

    protected FeatureTypeInfoDTO loadFeature(File infoFile) throws ConfigurationException {
        if (!infoFile.exists()) {
            throw new IllegalArgumentException("Info File not found:" + infoFile);
        }
        if (!infoFile.isFile()) {
            throw new IllegalArgumentException("Info file is the wrong type:" + infoFile);
        }
        if (!XMLConfigReader.isInfoFile(infoFile)) {
            throw new IllegalArgumentException("Info File not valid:" + infoFile);
        }
        Element featureElem = null;
        try {
            LOGGER.config("Loading configuration file: " + infoFile);
            FileReader reader = null;
            reader = new FileReader(infoFile);
            featureElem = ReaderUtils.parse((Reader)reader);
            ((Reader)reader).close();
        }
        catch (FileNotFoundException fileNotFound) {
            throw new ConfigurationException("Could not read info file:" + infoFile, fileNotFound);
        }
        catch (Exception erk) {
            throw new ConfigurationException("Could not parse info file:" + infoFile, erk);
        }
        FeatureTypeInfoDTO dto = this.loadFeaturePt2(featureElem);
        File parentDir = infoFile.getParentFile();
        dto.setDirName(parentDir.getName());
        File schemaFile = new File(parentDir, "schema.xml");
        if (schemaFile.exists() && schemaFile.isFile()) {
            LOGGER.finest("process schema file " + infoFile);
            try {
                this.loadSchema(schemaFile, dto);
            }
            catch (Exception badDog) {
                badDog.printStackTrace();
            }
        } else {
            dto.setSchemaAttributes(Collections.EMPTY_LIST);
        }
        LOGGER.config("added featureType " + dto.getName());
        return dto;
    }

    protected FeatureTypeInfoDTO loadFeaturePt2(Element fTypeRoot) throws ConfigurationException {
        FeatureTypeInfoDTO ft = new FeatureTypeInfoDTO();
        try {
            Element legendURL;
            Element cacheInfo;
            Element urls;
            ft.setName(ReaderUtils.getChildText((Element)fTypeRoot, (String)"name", (boolean)true));
            ft.setTitle(ReaderUtils.getChildText((Element)fTypeRoot, (String)"title", (boolean)true));
            ft.setAbstract(ReaderUtils.getChildText((Element)fTypeRoot, (String)"abstract"));
            ft.setWmsPath(ReaderUtils.getChildText((Element)fTypeRoot, (String)"wmspath"));
            String keywords = ReaderUtils.getChildText((Element)fTypeRoot, (String)"keywords");
            if (keywords != null) {
                LinkedList<String> l = new LinkedList<String>();
                String[] ss = keywords.split(",");
                for (int i = 0; i < ss.length; ++i) {
                    l.add(ss[i].trim());
                }
                ft.setKeywords(l);
            }
            if ((urls = ReaderUtils.getChildElement((Element)fTypeRoot, (String)"metadataLinks")) != null) {
                Element[] childs = ReaderUtils.getChildElements((Element)urls, (String)"metadataLink");
                LinkedList<MetaDataLink> l = new LinkedList<MetaDataLink>();
                for (int i = 0; i < childs.length; ++i) {
                    l.add(XMLConfigReader.getMetaDataLink(childs[i]));
                }
                ft.setMetadataLinks(l);
            }
            ft.setDataStoreId(ReaderUtils.getAttribute((Element)fTypeRoot, (String)"datastore", (boolean)true));
            ft.setSRS(Integer.parseInt(ReaderUtils.getChildText((Element)fTypeRoot, (String)"SRS", (boolean)true)));
            Element tmp = ReaderUtils.getChildElement((Element)fTypeRoot, (String)"styles");
            if (tmp != null) {
                ft.setDefaultStyle(ReaderUtils.getAttribute((Element)tmp, (String)"default", (boolean)false));
            }
            if ((cacheInfo = ReaderUtils.getChildElement((Element)fTypeRoot, (String)"cacheinfo")) != null) {
                ft.setCacheMaxAge(ReaderUtils.getAttribute((Element)cacheInfo, (String)"maxage", (boolean)false));
                ft.setCachingEnabled(Boolean.valueOf(ReaderUtils.getAttribute((Element)cacheInfo, (String)"enabled", (boolean)true)));
            }
            if ((legendURL = ReaderUtils.getChildElement((Element)fTypeRoot, (String)"LegendURL")) != null) {
                LegendURLDTO legend = new LegendURLDTO();
                legend.setWidth(Integer.parseInt(ReaderUtils.getAttribute((Element)legendURL, (String)"width", (boolean)true)));
                legend.setHeight(Integer.parseInt(ReaderUtils.getAttribute((Element)legendURL, (String)"height", (boolean)true)));
                legend.setFormat(ReaderUtils.getChildText((Element)legendURL, (String)"Format", (boolean)true));
                legend.setOnlineResource(ReaderUtils.getAttribute((Element)ReaderUtils.getChildElement((Element)legendURL, (String)"OnlineResource", (boolean)true), (String)"xlink:href", (boolean)true));
                ft.setLegendURL(legend);
            }
            ft.setLatLongBBox(this.loadLatLongBBox(ReaderUtils.getChildElement((Element)fTypeRoot, (String)"latLonBoundingBox")));
            Element numDecimalsElem = ReaderUtils.getChildElement((Element)fTypeRoot, (String)"numDecimals", (boolean)false);
            if (numDecimalsElem != null) {
                ft.setNumDecimals(ReaderUtils.getIntAttribute((Element)numDecimalsElem, (String)"value", (boolean)false, (int)8));
            }
            ft.setDefinitionQuery(this.loadDefinitionQuery(fTypeRoot));
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        return ft;
    }

    protected List getKeyWords(Element keywordsElem) {
        NodeList klist = keywordsElem.getElementsByTagName("keyword");
        int kCount = klist.getLength();
        LinkedList<String> keywords = new LinkedList<String>();
        for (int i = 0; i < kCount; ++i) {
            Element kelem = (Element)klist.item(i);
            String kword = ReaderUtils.getElementText((Element)kelem);
            if (kword == null) continue;
            keywords.add(kword);
        }
        return keywords;
    }

    protected Envelope loadLatLongBBox(Element bboxElem) throws ConfigurationException {
        if (bboxElem == null) {
            return new Envelope();
        }
        try {
            boolean dynamic = ReaderUtils.getBooleanAttribute((Element)bboxElem, (String)"dynamic", (boolean)false, (boolean)true);
            if (!dynamic) {
                double minx = ReaderUtils.getDoubleAttribute((Element)bboxElem, (String)"minx", (boolean)true);
                double miny = ReaderUtils.getDoubleAttribute((Element)bboxElem, (String)"miny", (boolean)true);
                double maxx = ReaderUtils.getDoubleAttribute((Element)bboxElem, (String)"maxx", (boolean)true);
                double maxy = ReaderUtils.getDoubleAttribute((Element)bboxElem, (String)"maxy", (boolean)true);
                return new Envelope(minx, maxx, miny, maxy);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        return new Envelope();
    }

    protected Filter loadDefinitionQuery(Element typeRoot) throws ConfigurationException {
        try {
            Element defQNode = ReaderUtils.getChildElement((Element)typeRoot, (String)"definitionQuery", (boolean)false);
            Filter filter = null;
            if (defQNode != null) {
                LOGGER.finer("definitionQuery element found, looking for Filter");
                Element filterNode = ReaderUtils.getChildElement((Element)defQNode, (String)"Filter", (boolean)false);
                if (filterNode != null && (filterNode = ReaderUtils.getFirstChildElement((Element)filterNode)) != null) {
                    filter = FilterDOMParser.parseFilter((Node)filterNode);
                    return filter;
                }
                LOGGER.finer("No Filter definition query found");
            }
            return filter;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    protected static boolean isInfoFile(File testFile) {
        String testName = testFile.getAbsolutePath();
        int start = testName.length() - "info.xml".length();
        int end = testName.length();
        return testName.substring(start, end).equals("info.xml");
    }

    protected void loadSchema(File schemaFile, FeatureTypeInfoDTO dto) throws ConfigurationException {
        try {
            schemaFile = ReaderUtils.checkFile((File)schemaFile, (boolean)false);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        Element elem = null;
        dto.setSchemaFile(schemaFile);
        if (schemaFile == null || !schemaFile.exists() || !schemaFile.canRead()) {
            System.err.println("File does not exist for schema for " + dto.getName());
            return;
        }
        try {
            LOGGER.config("Loading configuration file: " + schemaFile);
            FileReader reader = new FileReader(schemaFile);
            elem = ReaderUtils.parse((Reader)reader);
            ((Reader)reader).close();
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.FINEST, e.getMessage(), e);
            throw new ConfigurationException("Could not open schema file:" + schemaFile, e);
        }
        catch (Exception erk) {
            throw new ConfigurationException("Could not parse schema file:" + schemaFile, erk);
        }
        try {
            XMLConfigReader.processSchema(elem, dto);
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException("Error occured in " + schemaFile + "\n" + e.getMessage(), e);
        }
    }

    public static void processSchema(Element elem, FeatureTypeInfoDTO featureTypeInfoDTO) throws ConfigurationException {
        ArrayList<AttributeTypeInfoDTO> list = new ArrayList<AttributeTypeInfoDTO>();
        try {
            featureTypeInfoDTO.setSchemaName(ReaderUtils.getAttribute((Element)elem, (String)"name", (boolean)true));
            elem = ReaderUtils.getChildElement((Element)elem, (String)"xs:complexContent");
            elem = ReaderUtils.getChildElement((Element)elem, (String)"xs:extension");
            NameSpaceTranslator gml = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("gml");
            NameSpaceElement nse = gml.getElement(ReaderUtils.getAttribute((Element)elem, (String)"base", (boolean)true));
            featureTypeInfoDTO.setSchemaBase(nse.getTypeDefName());
            elem = ReaderUtils.getChildElement((Element)elem, (String)"xs:sequence");
            NodeList nl = elem.getElementsByTagName("xs:element");
            for (int i = 0; i < nl.getLength(); ++i) {
                Object tmp;
                elem = (Element)nl.item(i);
                AttributeTypeInfoDTO ati = new AttributeTypeInfoDTO();
                String name = ReaderUtils.getAttribute((Element)elem, (String)"name", (boolean)false);
                String ref = ReaderUtils.getAttribute((Element)elem, (String)"ref", (boolean)false);
                String type = ReaderUtils.getAttribute((Element)elem, (String)"type", (boolean)false);
                NameSpaceTranslator nst1 = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("xs");
                NameSpaceTranslator nst2 = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("gml");
                if (ref != null && ref != "") {
                    ati.setComplex(false);
                    nse = nst1.getElement(ref);
                    if (nse == null) {
                        nse = nst2.getElement(ref);
                    }
                    tmp = nse.getTypeRefName();
                    ati.setType((String)tmp);
                    ati.setName((String)tmp);
                } else {
                    ati.setName(name);
                    if (type != null && type != "") {
                        nse = nst1.getElement(type);
                        if (nse == null) {
                            nse = nst2.getElement(type);
                        }
                        tmp = nse.getTypeRefName();
                        ati.setType((String)tmp);
                        ati.setComplex(false);
                    } else {
                        tmp = ReaderUtils.getFirstChildElement((Element)elem);
                        OutputFormat format = new OutputFormat(tmp.getOwnerDocument());
                        format.setLineSeparator("\r\n");
                        format.setIndenting(true);
                        format.setLineWidth(0);
                        format.setPreserveSpace(true);
                        StringWriter sw = new StringWriter();
                        XMLSerializer serializer = new XMLSerializer((Writer)sw, format);
                        try {
                            serializer.asDOMSerializer();
                            serializer.serialize((Element)tmp);
                        }
                        catch (IOException e) {
                            throw new ConfigurationException(e);
                        }
                        ati.setType(elem.toString());
                        ati.setComplex(true);
                    }
                }
                ati.setNillable(ReaderUtils.getBooleanAttribute((Element)elem, (String)"nillable", (boolean)false, (boolean)true));
                ati.setMaxOccurs(ReaderUtils.getIntAttribute((Element)elem, (String)"maxOccurs", (boolean)false, (int)1));
                ati.setMinOccurs(ReaderUtils.getIntAttribute((Element)elem, (String)"minOccurs", (boolean)false, (int)1));
                list.add(ati);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        featureTypeInfoDTO.setSchemaAttributes(list);
    }

    public DataDTO getData() {
        return this.data;
    }

    public GeoServerDTO getGeoServer() {
        return this.geoServer;
    }

    public WFSDTO getWfs() {
        return this.wfs;
    }

    public WMSDTO getWms() {
        return this.wms;
    }

    public static MetaDataLink getMetaDataLink(Element metadataElem) throws Exception {
        MetaDataLink mdl = new MetaDataLink();
        if (metadataElem != null) {
            String tmp = ReaderUtils.getElementText((Element)metadataElem, (boolean)false);
            if (tmp != null && tmp != "") {
                mdl.setContent(tmp);
            }
            if ((tmp = ReaderUtils.getAttribute((Element)metadataElem, (String)"about", (boolean)false)) != null && tmp != "") {
                mdl.setAbout(tmp);
            }
            if ((tmp = ReaderUtils.getAttribute((Element)metadataElem, (String)"type", (boolean)false)) != null && tmp != "") {
                mdl.setType(tmp);
            }
            if ((tmp = ReaderUtils.getAttribute((Element)metadataElem, (String)"metadataType", (boolean)false)) != null && tmp != "") {
                mdl.setMetadataType(tmp);
            }
        }
        return mdl;
    }
}

