/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.dto;

import java.net.URL;
import java.util.Arrays;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.dto.CloneLibrary;
import org.vfny.geoserver.global.dto.DataTransferObject;

public final class ServiceDTO
implements DataTransferObject {
    private boolean enabled;
    private URL onlineResource;
    private String name;
    private String title;
    private String serverAbstract;
    private String[] keywords = new String[0];
    private String fees;
    private String accessConstraints;
    private String maintainer;
    private MetaDataLink metadataLink;
    private String strategy;
    private int partialBufferSize;

    public ServiceDTO() {
    }

    public ServiceDTO(ServiceDTO dto) {
        if (dto == null) {
            throw new NullPointerException("ServiceDTO object required");
        }
        this.enabled = dto.isEnabled();
        this.name = dto.getName();
        this.title = dto.getTitle();
        this.serverAbstract = dto.getAbstract();
        this.keywords = CloneLibrary.clone(dto.getKeywords());
        this.fees = dto.getFees();
        this.accessConstraints = dto.getAccessConstraints();
        this.maintainer = dto.getMaintainer();
        this.onlineResource = dto.getOnlineResource();
        this.metadataLink = dto.getMetadataLink();
        this.strategy = dto.getStrategy();
    }

    public Object clone() {
        return new ServiceDTO(this);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ServiceDTO)) {
            return false;
        }
        ServiceDTO dto = (ServiceDTO)other;
        if (this.enabled != dto.isEnabled()) {
            return false;
        }
        if (this.name != null ? !this.name.equals(dto.name) : dto.name != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(dto.title) : dto.title != null) {
            return false;
        }
        if (this.serverAbstract != null ? !this.serverAbstract.equals(dto.getAbstract()) : dto.serverAbstract != null) {
            return false;
        }
        if (!Arrays.equals(this.keywords, dto.keywords)) {
            return false;
        }
        if (this.fees != null ? !this.fees.equals(dto.fees) : dto.fees != null) {
            return false;
        }
        if (this.accessConstraints != null ? !this.accessConstraints.equals(dto.accessConstraints) : dto.accessConstraints != null) {
            return false;
        }
        if (this.maintainer != null ? !this.maintainer.equals(dto.maintainer) : dto.maintainer != null) {
            return false;
        }
        if (this.metadataLink != null ? !this.metadataLink.equals(dto.metadataLink) : dto.metadataLink != null) {
            return false;
        }
        return !(this.strategy != null ? !this.strategy.equals(dto.strategy) : dto.strategy != null);
    }

    public int hashCode() {
        return this.enabled | (this.name != null ? this.name.hashCode() : 0) | (this.title != null ? this.title.hashCode() : 0) | (this.serverAbstract != null ? this.serverAbstract.hashCode() : 0) | (this.keywords != null ? this.keywords.hashCode() : 0) | (this.fees != null ? this.fees.hashCode() : 0) | (this.accessConstraints != null ? this.accessConstraints.hashCode() : 0) | (this.maintainer != null ? this.maintainer.hashCode() : 0) | (this.metadataLink != null ? this.metadataLink.hashCode() : 0) | (this.strategy != null ? this.strategy.hashCode() : 0);
    }

    public String getName() {
        return this.name;
    }

    public URL getOnlineResource() {
        return this.onlineResource;
    }

    public String getTitle() {
        return this.title;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOnlineResource(URL url) {
        this.onlineResource = url;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getAbstract() {
        return this.serverAbstract;
    }

    public String getAccessConstraints() {
        return this.accessConstraints;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getFees() {
        return this.fees;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public void setAbstract(String serviceAbstract) {
        this.serverAbstract = serviceAbstract;
    }

    public void setAccessConstraints(String constraints) {
        this.accessConstraints = constraints;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public void setFees(String string) {
        this.fees = string;
    }

    public void setKeywords(String[] array) {
        this.keywords = array;
    }

    public void setMaintainer(String string) {
        this.maintainer = string;
    }

    public MetaDataLink getMetadataLink() {
        return this.metadataLink;
    }

    public void setMetadataLink(MetaDataLink metadataLink) {
        this.metadataLink = metadataLink;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public int getPartialBufferSize() {
        return this.partialBufferSize;
    }

    public void setPartialBufferSize(int partialBufferSize) {
        this.partialBufferSize = partialBufferSize;
    }
}

