/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.dto;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.geotools.filter.Filter;
import org.vfny.geoserver.global.dto.CloneLibrary;
import org.vfny.geoserver.global.dto.DataTransferObject;
import org.vfny.geoserver.global.dto.EqualsLibrary;
import org.vfny.geoserver.global.dto.LegendURLDTO;

public final class FeatureTypeInfoDTO
implements DataTransferObject {
    private String dataStoreId;
    private Envelope latLongBBox;
    private int SRS;
    private List schema;
    private String schemaName;
    private String schemaBase;
    private String name;
    private String wmsPath;
    private String dirName;
    private String title;
    private String _abstract;
    private List keywords;
    private List metadataLinks;
    private int numDecimals;
    private Filter definitionQuery = null;
    private String defaultStyle;
    private LegendURLDTO legendURL;
    private File schemaFile;
    private String cacheMaxAge;
    private boolean cachingEnabled;

    public FeatureTypeInfoDTO() {
    }

    public FeatureTypeInfoDTO(FeatureTypeInfoDTO dto) {
        if (dto == null) {
            throw new NullPointerException("Non null FeatureTypeInfoDTO required");
        }
        this.dataStoreId = dto.getDataStoreId();
        this.latLongBBox = CloneLibrary.clone(dto.getLatLongBBox());
        this.SRS = dto.getSRS();
        this.schema = dto.getSchemaAttributes();
        this.name = dto.getName();
        this.wmsPath = dto.getWmsPath();
        this.title = dto.getTitle();
        this._abstract = dto.getAbstract();
        this.numDecimals = dto.getNumDecimals();
        this.definitionQuery = dto.getDefinitionQuery();
        this.legendURL = dto.getLegendURL();
        try {
            this.keywords = CloneLibrary.clone(dto.getKeywords());
        }
        catch (Exception e) {
            this.keywords = new LinkedList();
        }
        try {
            this.metadataLinks = CloneLibrary.clone(dto.getMetadataLinks());
        }
        catch (Exception e) {
            this.metadataLinks = new LinkedList();
        }
        this.defaultStyle = dto.getDefaultStyle();
        this.dirName = dto.getDirName();
        this.schemaName = dto.getSchemaName();
        this.schemaBase = dto.getSchemaBase();
        this.cachingEnabled = dto.isCachingEnabled();
        this.cacheMaxAge = dto.getCacheMaxAge();
    }

    public Object clone() {
        return new FeatureTypeInfoDTO(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FeatureTypeInfoDTO)) {
            return false;
        }
        FeatureTypeInfoDTO f = (FeatureTypeInfoDTO)obj;
        boolean r = true;
        boolean bl = r = r && this.dataStoreId == f.getDataStoreId();
        if (this.latLongBBox != null) {
            r = r && this.latLongBBox.equals((Object)f.getLatLongBBox());
        } else if (f.getLatLongBBox() != null) {
            return false;
        }
        boolean bl2 = r = r && this.SRS == f.getSRS();
        if (this.schema != null) {
            r = r && ((Object)this.schema).equals(f.getSchemaAttributes());
        } else if (f.getSchemaAttributes() != null) {
            return false;
        }
        if (this.legendURL != null) {
            r = r && this.legendURL.equals(f.getLegendURL());
        } else if (f.getLegendURL() != null) {
            return false;
        }
        r = r && this.defaultStyle == f.getDefaultStyle();
        r = r && this.name == f.getName();
        r = r && this.wmsPath == f.getWmsPath();
        r = r && this.title == f.getTitle();
        r = r && this._abstract == f.getAbstract();
        boolean bl3 = r = r && this.numDecimals == f.getNumDecimals();
        if (this.definitionQuery != null) {
            r = r && this.definitionQuery.equals(f.getDefinitionQuery());
        } else if (f.getDefinitionQuery() != null) {
            return false;
        }
        if (this.keywords != null) {
            r = r && EqualsLibrary.equals(this.keywords, f.getKeywords());
        } else if (f.getKeywords() != null) {
            return false;
        }
        if (this.metadataLinks != null) {
            r = r && EqualsLibrary.equals(this.metadataLinks, f.getMetadataLinks());
        } else if (f.getMetadataLinks() != null) {
            return false;
        }
        r = r && this.dirName == f.getDirName();
        r = r && this.schemaName == f.getSchemaName();
        r = r && this.schemaBase == f.getSchemaBase();
        r = r && this.isCachingEnabled() == f.isCachingEnabled();
        r = r && this.getCacheMaxAge() != null && this.getCacheMaxAge().equals(f.getCacheMaxAge());
        return r;
    }

    public int hashCode() {
        int r = 1;
        if (this.name != null) {
            r *= this.name.hashCode();
        }
        if (this.dataStoreId != null) {
            r *= this.dataStoreId.hashCode();
        }
        if (this.legendURL != null) {
            r *= this.legendURL.hashCode();
        }
        if (this.title != null) {
            r *= this.title.hashCode();
        }
        if (this.SRS != 0) {
            r = this.SRS % r;
        }
        if (this.cacheMaxAge != null) {
            r *= this.cacheMaxAge.hashCode();
        }
        if (this.cachingEnabled) {
            ++r;
        }
        return r;
    }

    public String getAbstract() {
        return this._abstract;
    }

    public String getDataStoreId() {
        return this.dataStoreId;
    }

    public List getKeywords() {
        return this.keywords;
    }

    public List getMetadataLinks() {
        return this.metadataLinks;
    }

    public String getKey() {
        return this.getDataStoreId() + ":::" + this.getName();
    }

    public Envelope getLatLongBBox() {
        return this.latLongBBox;
    }

    public String getName() {
        return this.name;
    }

    public int getSRS() {
        return this.SRS;
    }

    public String getTitle() {
        return this.title;
    }

    public void setAbstract(String string) {
        this._abstract = string;
    }

    public void setDataStoreId(String store) {
        this.dataStoreId = store;
    }

    public void setKeywords(List list) {
        this.keywords = list;
    }

    public void setMetadataLinks(List list) {
        this.metadataLinks = list;
    }

    public boolean addKeyword(String key) {
        if (this.keywords == null) {
            this.keywords = new LinkedList();
        }
        return this.keywords.add(key);
    }

    public boolean removeKeyword(String key) {
        return this.keywords.remove(key);
    }

    public void setLatLongBBox(Envelope envelope) {
        this.latLongBBox = envelope;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSRS(int i) {
        this.SRS = i;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getNumDecimals() {
        return this.numDecimals;
    }

    public void setNumDecimals(int i) {
        this.numDecimals = i;
    }

    public Filter getDefinitionQuery() {
        return this.definitionQuery;
    }

    public void setDefinitionQuery(Filter filter) {
        this.definitionQuery = filter;
    }

    public String getDefaultStyle() {
        if (this.defaultStyle == null || this.defaultStyle.equals("")) {
            this.defaultStyle = "normal";
        }
        return this.defaultStyle;
    }

    public void setDefaultStyle(String string) {
        this.defaultStyle = string;
    }

    public List getSchemaAttributes() {
        return this.schema;
    }

    public void setSchemaAttributes(List schemaElements) {
        this.schema = schemaElements;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setDirName(String string) {
        this.dirName = string;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public String getSchemaBase() {
        return this.schemaBase;
    }

    public void setSchemaBase(String string) {
        this.schemaBase = string;
    }

    public LegendURLDTO getLegendURL() {
        return this.legendURL;
    }

    public void setLegendURL(LegendURLDTO legendURL) {
        this.legendURL = legendURL;
    }

    public File getSchemaFile() {
        return this.schemaFile;
    }

    public void setSchemaFile(File schemaFile) {
        this.schemaFile = schemaFile;
    }

    public String toString() {
        return "[FeatureTypeInfoDTO: " + this.name + ", datastoreId: " + this.dataStoreId + ", latLongBBOX: " + this.latLongBBox + "\n  SRS: " + this.SRS + ", schema:" + this.schema + ", schemaName: " + this.schemaName + ", dirName: " + this.dirName + ", title: " + this.title + "\n  definitionQuery: " + this.definitionQuery + ", defaultStyle: " + this.defaultStyle + ", legend icon: " + this.legendURL + ", caching?: " + this.cachingEnabled + ", max-age: " + this.cacheMaxAge;
    }

    public String getWmsPath() {
        return this.wmsPath;
    }

    public void setWmsPath(String wmsPath) {
        this.wmsPath = wmsPath;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    public String getCacheMaxAge() {
        return this.cacheMaxAge;
    }

    public void setCacheMaxAge(String cacheMaxAge) {
        this.cacheMaxAge = cacheMaxAge;
    }
}

