/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.dto.NameSpaceInfoDTO;

public class NameSpaceInfo
extends GlobalLayerSupertype {
    private String prefix;
    private String uri;
    private boolean _default;
    private Data data;
    private Map meta;

    public NameSpaceInfo(Data data, NameSpaceInfoDTO ns) {
        if (ns == null) {
            throw new NullPointerException("Non null NameSpaceInfoDTO required");
        }
        if (data == null) {
            throw new NullPointerException("Non null Data required");
        }
        this.data = data;
        this.prefix = ns.getPrefix();
        this.uri = ns.getUri();
        this._default = ns.isDefault();
        this.meta = new HashMap();
    }

    public NameSpaceInfo(NameSpaceInfo ns) {
        if (ns == null) {
            throw new NullPointerException();
        }
        this.setPrefix(ns.getPrefix());
        this.setUri(ns.getUri());
        this.setDefault(ns.isDefault());
    }

    Object toDTO() {
        NameSpaceInfoDTO dto = new NameSpaceInfoDTO();
        dto.setDefault(this.isDefault());
        dto.setPrefix(this.getPrefix());
        dto.setUri(this.getUri());
        return dto;
    }

    public Object clone() {
        return new NameSpaceInfo(this);
    }

    public boolean isDefault() {
        return this._default;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUri() {
        return this.uri;
    }

    public String getURI() {
        return this.uri;
    }

    public void setDefault(boolean b) {
        this._default = b;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void setUri(String string) {
        this.uri = string;
    }

    public boolean containsMetaData(String key) {
        return this.meta.containsKey(key);
    }

    public void putMetaData(String key, Object value) {
        this.meta.put(key, value);
    }

    public Object getMetaData(String key) {
        return this.meta.get(key);
    }

    public Set getTypeNames() {
        HashSet<String> set = new HashSet<String>();
        Iterator i = this.data.getFeatureTypeInfos().values().iterator();
        while (i.hasNext()) {
            FeatureTypeInfo type = (FeatureTypeInfo)i.next();
            if (type.getNameSpace() != this) continue;
            set.add(type.getName());
        }
        return set;
    }

    public FeatureTypeInfo getFeatureTypeInfo(String typeName) {
        return this.data.getFeatureTypeInfo(typeName, this.uri);
    }

    public String toString() {
        return this.getPrefix() + ":" + this.getUri();
    }

    public boolean equals(Object object) {
        if (!(object instanceof NameSpaceInfo)) {
            return false;
        }
        NameSpaceInfo rhs = (NameSpaceInfo)object;
        return new EqualsBuilder().appendSuper(super.equals(object)).append(this._default, rhs._default).append((Object)this.uri, (Object)rhs.uri).append((Object)this.data, (Object)rhs.data).append((Object)this.prefix, (Object)rhs.prefix).append((Object)this.meta, (Object)rhs.meta).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(2042082703, 233934749).appendSuper(super.hashCode()).append(this._default).append((Object)this.uri).append((Object)this.data).append((Object)this.prefix).append((Object)this.meta).toHashCode();
    }
}

