/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.prefs.Preferences;
import org.geotools.io.LineWriter;
import org.geotools.resources.Utilities;

public class Log4JFormatter
extends Formatter {
    private static final String PREFIX = "[";
    private static final String SUFFIX = "] ";
    private static long startMillis;
    private final String lineSeparator;
    private String bodyLineSeparator;
    private final int margin;
    private final String base;
    private final StringBuffer buffer;
    private final LineWriter writer;
    static /* synthetic */ Class class$java$util$logging$ConsoleHandler;
    static /* synthetic */ Class class$java$util$logging$SimpleFormatter;
    static /* synthetic */ Class class$org$vfny$geoserver$global$Log4JFormatter$Stdout;
    static /* synthetic */ Class class$org$vfny$geoserver$global$Log4JFormatter;

    public Log4JFormatter(String base) {
        this.bodyLineSeparator = this.lineSeparator = System.getProperty("line.separator", "\n");
        this.base = base.trim();
        this.margin = Log4JFormatter.getHeaderWidth();
        startMillis = System.currentTimeMillis();
        StringWriter str = new StringWriter();
        this.writer = new LineWriter((Writer)str);
        this.buffer = str.getBuffer();
    }

    public synchronized String format(LogRecord record) {
        String recordLevel = record.getLevel().getLocalizedName();
        try {
            this.buffer.setLength(1);
            Long millis = new Long(record.getMillis() - startMillis);
            this.writer.write(millis.toString());
            this.writer.write(" ");
            this.writer.write(PREFIX);
            this.writer.write(recordLevel);
            this.writer.write(SUFFIX);
            this.writer.write(record.getSourceClassName());
            this.writer.write(" - ");
            this.writer.setLineSeparator(this.bodyLineSeparator);
            this.writer.write(this.formatMessage(record));
            this.writer.setLineSeparator(this.lineSeparator);
            this.writer.write(10);
            this.writer.flush();
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
        return this.buffer.toString();
    }

    public static void init(String base, Level filterLevel) {
        Handler handler;
        Log4JFormatter log4j = null;
        Logger logger = Logger.getLogger(base);
        if (!logger.getUseParentHandlers()) {
            logger.setLevel(filterLevel);
            if (logger.getHandlers().length > 0 && (handler = logger.getHandlers()[0]) != null) {
                handler.setLevel(filterLevel);
            }
        }
        Logger parent = logger;
        while (parent.getUseParentHandlers() && (parent = parent.getParent()) != null) {
            Handler[] handlers = parent.getHandlers();
            if (handlers == null) continue;
            for (int i = 0; i < handlers.length; ++i) {
                Formatter formatter;
                Handler handler2 = handlers[i];
                if (handler2.getClass().equals(class$java$util$logging$ConsoleHandler == null ? Log4JFormatter.class$("java.util.logging.ConsoleHandler") : class$java$util$logging$ConsoleHandler) && (formatter = handler2.getFormatter()).getClass().equals(class$java$util$logging$SimpleFormatter == null ? Log4JFormatter.class$("java.util.logging.SimpleFormatter") : class$java$util$logging$SimpleFormatter)) {
                    if (log4j == null) {
                        log4j = new Log4JFormatter(base);
                    }
                    try {
                        logger.removeHandler(handler2);
                        handler2 = new Stdout(handler2, (Formatter)log4j);
                        handler2.setLevel(filterLevel);
                    }
                    catch (UnsupportedEncodingException exception) {
                        Log4JFormatter.unexpectedException(exception);
                    }
                    catch (SecurityException exception) {
                        Log4JFormatter.unexpectedException(exception);
                    }
                }
                if (handler2.getClass().equals(class$org$vfny$geoserver$global$Log4JFormatter$Stdout == null ? Log4JFormatter.class$("org.vfny.geoserver.global.Log4JFormatter$Stdout") : class$org$vfny$geoserver$global$Log4JFormatter$Stdout)) {
                    handler2.setLevel(filterLevel);
                }
                logger.addHandler(handler2);
                logger.setLevel(filterLevel);
            }
        }
        if (0 == logger.getHandlers().length) {
            log4j = new Log4JFormatter(base);
            handler = new Stdout();
            handler.setFormatter(log4j);
            handler.setLevel(filterLevel);
            logger.addHandler(handler);
        }
        logger.setUseParentHandlers(false);
    }

    private static void unexpectedException(Exception e) {
        Utilities.unexpectedException((String)"org.geotools.resources", (String)"GeotoolsHandler", (String)"init", (Throwable)e);
    }

    private static int getHeaderWidth() {
        return Preferences.userNodeForPackage(class$org$vfny$geoserver$global$Log4JFormatter == null ? (class$org$vfny$geoserver$global$Log4JFormatter = Log4JFormatter.class$("org.vfny.geoserver.global.Log4JFormatter")) : class$org$vfny$geoserver$global$Log4JFormatter).getInt("logging.header", 15);
    }

    static void setHeaderWidth(int margin) {
        Preferences.userNodeForPackage(class$org$vfny$geoserver$global$Log4JFormatter == null ? (class$org$vfny$geoserver$global$Log4JFormatter = Log4JFormatter.class$("org.vfny.geoserver.global.Log4JFormatter")) : class$org$vfny$geoserver$global$Log4JFormatter).putInt("logging.header", margin);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Stdout
    extends StreamHandler {
        public Stdout() {
        }

        public Stdout(Handler handler, Formatter formatter) throws UnsupportedEncodingException {
            super(System.out, formatter);
            this.setErrorManager(handler.getErrorManager());
            this.setFilter(handler.getFilter());
            this.setLevel(handler.getLevel());
            this.setEncoding(handler.getEncoding());
        }

        public void publish(LogRecord record) {
            super.publish(record);
            this.flush();
        }

        public void close() {
            this.flush();
        }
    }
}

