/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import org.geoserver.GeoServerResourceLoader;
import org.vfny.geoserver.global.ConfigurationException;

public class GeoserverDataDirectory {
    private static GeoServerResourceLoader loader;
    private static boolean isTrueDataDir;

    public static File getGeoserverDataDirectory(ServletContext servContext) {
        if (loader == null) {
            File dataDir = null;
            String prop = System.getProperty("GEOSERVER_DATA_DIR");
            if (prop != null && !prop.equals("")) {
                isTrueDataDir = true;
                dataDir = new File(prop);
                loader = new GeoServerResourceLoader(dataDir);
                System.out.println("----------------------------------");
                System.out.println("- GEOSERVER_DATA_DIR: " + dataDir.getAbsolutePath());
                System.out.println("----------------------------------");
                return dataDir;
            }
            String loc = servContext.getInitParameter("GEOSERVER_DATA_DIR");
            if (loc != null) {
                isTrueDataDir = true;
                dataDir = new File(loc);
                loader = new GeoServerResourceLoader(dataDir);
                System.out.println("----------------------------------");
                System.out.println("- GEOSERVER_DATA_DIR: " + dataDir.getAbsolutePath());
                System.out.println("----------------------------------");
                return dataDir;
            }
            isTrueDataDir = false;
            String rootDir = servContext.getRealPath("/");
            dataDir = new File(rootDir);
            System.out.println("----------------------------------");
            System.out.println("- GEOSERVER_DATA_DIR: " + dataDir.getAbsolutePath());
            System.out.println("----------------------------------");
            loader = new GeoServerResourceLoader(dataDir);
            loader.addSearchLocation(new File(servContext.getRealPath("WEB-INF")));
            loader.addSearchLocation(new File(servContext.getRealPath("data")));
        }
        return loader.getBaseDirectory();
    }

    public static boolean isTrueDataDir() {
        return isTrueDataDir;
    }

    public static File findConfigDir(File root, String dirName) throws ConfigurationException {
        File configDir;
        try {
            configDir = loader.find(dirName);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        return configDir;
    }

    public static File findConfigFile(String file) throws ConfigurationException {
        try {
            return loader.find(file);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
    }

    static {
        isTrueDataDir = false;
    }
}

