/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.geotools.catalog.GeoResource;
import org.geotools.catalog.GeoResourceInfo;
import org.geotools.catalog.Resolve;
import org.geotools.catalog.ResolveChangeEvent;
import org.geotools.catalog.ResolveChangeListener;
import org.geotools.catalog.defaults.DefaultGeoResourceInfo;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.factory.FactoryConfigurationError;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.SchemaException;
import org.geotools.feature.type.GeometricAttributeType;
import org.geotools.filter.Filter;
import org.geotools.referencing.CRS;
import org.geotools.styling.Style;
import org.geotools.util.ProgressListener;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.AttributeTypeInfo;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.DataStoreInfo;
import org.vfny.geoserver.global.GeoServerFeatureSource;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.LegendURL;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;
import org.vfny.geoserver.global.dto.DataTransferObjectFactory;
import org.vfny.geoserver.global.dto.FeatureTypeInfoDTO;
import org.vfny.geoserver.global.dto.LegendURLDTO;
import org.vfny.geoserver.util.DataStoreUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class FeatureTypeInfo
extends GlobalLayerSupertype
implements GeoResource {
    private static Hashtable SRSLookup = new Hashtable();
    private static final int DEFAULT_NUM_DECIMALS = 8;
    private String dataStoreId;
    private Envelope latLongBBox;
    private int SRS;
    private List schema;
    private String schemaName;
    private String schemaBase;
    private String typeName;
    private String wmsPath;
    private String dirName;
    private String _abstract;
    private List keywords;
    private List metadataLinks;
    private int numDecimals;
    private Filter definitionQuery = null;
    private String defaultStyle;
    private String title;
    private Data data;
    private Map meta;
    private String xmlSchemaFrag;
    private FeatureType ft;
    private LegendURL legendURL;
    private File schemaFile;
    private String cacheMaxAge;
    private boolean cachingEnabled;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;
    static /* synthetic */ Class class$org$geotools$feature$FeatureType;
    static /* synthetic */ Class class$org$geotools$catalog$Service;
    static /* synthetic */ Class class$org$geotools$catalog$GeoResourceInfo;

    public FeatureTypeInfo() {
    }

    public FeatureTypeInfo(FeatureTypeInfoDTO dto, Data data) throws ConfigurationException {
        this.data = data;
        this._abstract = dto.getAbstract();
        this.dataStoreId = dto.getDataStoreId();
        this.defaultStyle = dto.getDefaultStyle();
        if (dto.getLegendURL() != null) {
            this.legendURL = new LegendURL(dto.getLegendURL());
        }
        this.definitionQuery = dto.getDefinitionQuery();
        this.dirName = dto.getDirName();
        this.keywords = dto.getKeywords();
        this.metadataLinks = dto.getMetadataLinks();
        this.latLongBBox = dto.getLatLongBBox();
        this.typeName = dto.getName();
        this.wmsPath = dto.getWmsPath();
        this.numDecimals = dto.getNumDecimals();
        List tmp = dto.getSchemaAttributes();
        this.schema = new LinkedList();
        if (tmp != null && !tmp.isEmpty()) {
            Iterator i = tmp.iterator();
            while (i.hasNext()) {
                this.schema.add(new AttributeTypeInfo((AttributeTypeInfoDTO)i.next()));
            }
        }
        this.schemaBase = dto.getSchemaBase();
        this.schemaName = dto.getSchemaName();
        this.schemaFile = dto.getSchemaFile();
        this.SRS = dto.getSRS();
        this.title = dto.getTitle();
        this.cacheMaxAge = dto.getCacheMaxAge();
        this.cachingEnabled = dto.isCachingEnabled();
    }

    Object toDTO() {
        FeatureTypeInfoDTO dto = new FeatureTypeInfoDTO();
        dto.setAbstract(this._abstract);
        dto.setDataStoreId(this.dataStoreId);
        dto.setDefaultStyle(this.defaultStyle);
        if (this.legendURL != null) {
            dto.setLegendURL((LegendURLDTO)this.legendURL.toDTO());
        }
        dto.setDefinitionQuery(this.definitionQuery);
        dto.setDirName(this.dirName);
        dto.setKeywords(this.keywords);
        dto.setMetadataLinks(this.metadataLinks);
        dto.setLatLongBBox(this.latLongBBox);
        dto.setName(this.typeName);
        dto.setWmsPath(this.wmsPath);
        dto.setNumDecimals(this.numDecimals);
        LinkedList<Object> tmp = new LinkedList<Object>();
        Iterator i = this.schema.iterator();
        while (i.hasNext()) {
            tmp.add(((AttributeTypeInfo)i.next()).toDTO());
        }
        dto.setSchemaAttributes(tmp);
        dto.setSchemaBase(this.schemaBase);
        dto.setSchemaName(this.getSchemaName());
        dto.setSRS(this.SRS);
        dto.setTitle(this.title);
        dto.setCacheMaxAge(this.cacheMaxAge);
        dto.setCachingEnabled(this.cachingEnabled);
        return dto;
    }

    public int getNumDecimals() {
        return this.numDecimals;
    }

    public DataStoreInfo getDataStoreInfo() {
        return this.data.getDataStoreInfo(this.dataStoreId);
    }

    public Style getDefaultStyle() {
        return this.data.getStyle(this.defaultStyle);
    }

    public boolean isEnabled() {
        return this.getDataStoreInfo() != null && this.getDataStoreInfo().isEnabled();
    }

    public String getPrefix() {
        return this.getDataStoreInfo().getNameSpace().getPrefix();
    }

    public NameSpaceInfo getNameSpace() {
        if (!this.isEnabled()) {
            throw new IllegalStateException("This featureType is not enabled");
        }
        return this.getDataStoreInfo().getNameSpace();
    }

    public String getName() {
        return this.getPrefix() + ":" + this.typeName;
    }

    public FeatureSource getFeatureSource() throws IOException {
        if (!this.isEnabled() || this.getDataStoreInfo().getDataStore() == null) {
            throw new IOException("featureType: " + this.getName() + " does not have a properly configured " + "datastore");
        }
        DataStore dataStore = this.data.getDataStoreInfo(this.dataStoreId).getDataStore();
        FeatureSource realSource = dataStore.getFeatureSource(this.typeName);
        if (this.schema == null || this.schema.isEmpty()) {
            return realSource;
        }
        return GeoServerFeatureSource.create(realSource, this.getFeatureType(realSource), this.getDefinitionQuery());
    }

    public Envelope getBoundingBox() throws IOException {
        DataStore dataStore = this.data.getDataStoreInfo(this.dataStoreId).getDataStore();
        FeatureSource realSource = dataStore.getFeatureSource(this.typeName);
        return DataStoreUtils.getBoundingBoxEnvelope(realSource);
    }

    public Filter getDefinitionQuery() {
        return this.definitionQuery;
    }

    public Envelope getLatLongBoundingBox() throws IOException {
        if (this.latLongBBox == null) {
            return this.getBoundingBox();
        }
        return this.latLongBBox;
    }

    public String getSRS() {
        return this.SRS + "";
    }

    private synchronized FeatureTypeInfoDTO getGeneratedDTO() throws IOException {
        return DataTransferObjectFactory.create(this.dataStoreId, this.getFeatureType());
    }

    protected String getAttribute(Element elem, String attName, boolean mandatory) throws ConfigurationException {
        Attr att = elem.getAttributeNode(attName);
        String value = null;
        if (att != null) {
            value = att.getValue();
        }
        if (mandatory) {
            if (att == null) {
                throw new ConfigurationException("element " + elem.getNodeName() + " does not contains an attribute named " + attName);
            }
            if ("".equals(value)) {
                throw new ConfigurationException("attribute " + attName + "in element " + elem.getNodeName() + " is empty");
            }
        }
        return value;
    }

    private static Envelope getLatLongBBox(String fromSrId, Envelope bbox) {
        return bbox;
    }

    public String getAbstract() {
        return this._abstract;
    }

    public List getKeywords() {
        return this.keywords;
    }

    public List getMetadataLinks() {
        return this.metadataLinks;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSchemaName() {
        if (this.schemaName == null) {
            return this.typeName + "_Type";
        }
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public String getSchemaBase() {
        return this.schemaBase;
    }

    public void setSchemaBase(String string) {
        this.schemaBase = string;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public FeatureType getFeatureType() throws IOException {
        return this.getFeatureType(this.getFeatureSource());
    }

    private FeatureType getFeatureType(FeatureSource fs) throws IOException {
        if (this.ft == null) {
            this.ft = fs.getSchema();
            URI namespace = this.ft.getNamespace();
            String[] baseNames = DataTransferObjectFactory.getRequiredBaseAttributes(this.schemaBase);
            AttributeType[] attributes = new AttributeType[this.schema.size() + baseNames.length];
            if (attributes.length > 0) {
                int count;
                int errors = 0;
                for (count = 0; count < baseNames.length; ++count) {
                    attributes[count - errors] = this.ft.getAttributeType(baseNames[count]);
                    if (attributes[count - errors] != null) continue;
                    ++errors;
                }
                if (errors != 0) {
                    AttributeType[] tmp = new AttributeType[attributes.length - errors];
                    count -= errors;
                    for (int i = 0; i < count; ++i) {
                        tmp[i] = attributes[i];
                    }
                    attributes = tmp;
                }
                Iterator i = this.schema.iterator();
                while (i.hasNext()) {
                    AttributeTypeInfo ati = (AttributeTypeInfo)i.next();
                    String attName = ati.getName();
                    attributes[count] = this.ft.getAttributeType(attName);
                    if ((class$com$vividsolutions$jts$geom$Geometry == null ? FeatureTypeInfo.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(attributes[count].getType())) {
                        GeometricAttributeType old = (GeometricAttributeType)attributes[count];
                        try {
                            attributes[count] = new GeometricAttributeType(old, this.getSRS(this.SRS));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (attributes[count] == null) {
                        throw new IOException("the FeatureType " + this.getName() + " does not contains the configured attribute " + attName + ". Check your schema configuration");
                    }
                    ++count;
                }
                try {
                    this.ft = FeatureTypeFactory.newFeatureType((AttributeType[])attributes, (String)this.typeName, (URI)namespace);
                }
                catch (SchemaException ex) {
                }
                catch (FactoryConfigurationError ex) {
                    // empty catch block
                }
            }
        }
        return this.ft;
    }

    public DataStoreInfo getDataStoreMetaData() {
        return this.data.getDataStoreInfo(this.dataStoreId);
    }

    public List getAttributeNames() {
        List attribs = this.schema;
        if (attribs.size() != 0) {
            ArrayList<String> list = new ArrayList<String>(attribs.size());
            Iterator i = attribs.iterator();
            while (i.hasNext()) {
                AttributeTypeInfo at = (AttributeTypeInfo)i.next();
                list.add(at.getName());
            }
            return list;
        }
        ArrayList<String> list = new ArrayList<String>();
        try {
            FeatureType ftype = this.getFeatureType();
            AttributeType[] types = ftype.getAttributeTypes();
            list = new ArrayList(types.length);
            for (int i = 0; i < types.length; ++i) {
                list.add(types[i].getName());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    public List getAttributes() {
        return this.schema;
    }

    public synchronized AttributeTypeInfo attributeTypeMetaData(String attributeName) {
        AttributeTypeInfo info = null;
        if (this.schema != null) {
            Iterator i = this.schema.iterator();
            while (i.hasNext()) {
                AttributeTypeInfoDTO dto = (AttributeTypeInfoDTO)i.next();
                info = new AttributeTypeInfo(dto);
            }
            DataStore dataStore = this.data.getDataStoreInfo(this.dataStoreId).getDataStore();
            try {
                FeatureType ftype = dataStore.getSchema(this.typeName);
                info.sync(ftype.getAttributeType(attributeName));
            }
            catch (IOException e) {}
        } else {
            DataStore dataStore = this.data.getDataStoreInfo(this.dataStoreId).getDataStore();
            try {
                FeatureType ftype = dataStore.getSchema(this.typeName);
                info = new AttributeTypeInfo(ftype.getAttributeType(attributeName));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return info;
    }

    public boolean containsMetaData(String key) {
        return this.meta != null && this.meta.containsKey(key);
    }

    public void putMetaData(String key, Object value) {
        if (this.meta == null) {
            this.meta = new HashMap();
        }
        this.meta.put(key, value);
    }

    public Object getMetaData(String key) {
        if (this.meta == null) {
            return null;
        }
        return this.meta.get(key);
    }

    public LegendURL getLegendURL() {
        return this.legendURL;
    }

    public File getSchemaFile() {
        return this.schemaFile;
    }

    private CoordinateReferenceSystem getSRS(int epsg) {
        CoordinateReferenceSystem result = (CoordinateReferenceSystem)SRSLookup.get(new Integer(epsg));
        if (result == null) {
            try {
                result = CRS.decode((String)("EPSG:" + epsg));
                SRSLookup.put(new Integer(epsg), result);
            }
            catch (NoSuchAuthorityCodeException e) {
                String msg = "Error looking up SRS for EPSG: " + epsg + ":" + e.getLocalizedMessage();
                GlobalLayerSupertype.LOGGER.warning(msg);
            }
            catch (FactoryException e) {
                String msg = "Error looking up SRS for EPSG: " + epsg + ":" + e.getLocalizedMessage();
                GlobalLayerSupertype.LOGGER.warning(msg);
            }
        }
        return result;
    }

    public String getDirName() {
        return this.dirName;
    }

    public String getWmsPath() {
        return this.wmsPath;
    }

    public void setWmsPath(String wmsPath) {
        this.wmsPath = wmsPath;
    }

    public String getCacheMaxAge() {
        return this.cacheMaxAge;
    }

    public void setCacheMaxAge(String cacheMaxAge) {
        this.cacheMaxAge = cacheMaxAge;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    public boolean canResolve(Class adaptee) {
        return (class$org$geotools$feature$FeatureType == null ? (class$org$geotools$feature$FeatureType = FeatureTypeInfo.class$("org.geotools.feature.FeatureType")) : class$org$geotools$feature$FeatureType).isAssignableFrom(adaptee) || (class$org$geotools$catalog$Service == null ? (class$org$geotools$catalog$Service = FeatureTypeInfo.class$("org.geotools.catalog.Service")) : class$org$geotools$catalog$Service).isAssignableFrom(adaptee) || (class$org$geotools$catalog$GeoResourceInfo == null ? (class$org$geotools$catalog$GeoResourceInfo = FeatureTypeInfo.class$("org.geotools.catalog.GeoResourceInfo")) : class$org$geotools$catalog$GeoResourceInfo).isAssignableFrom(adaptee);
    }

    public Object resolve(Class adaptee, ProgressListener monitor) throws IOException {
        if ((class$org$geotools$feature$FeatureType == null ? (class$org$geotools$feature$FeatureType = FeatureTypeInfo.class$("org.geotools.feature.FeatureType")) : class$org$geotools$feature$FeatureType).isAssignableFrom(adaptee)) {
            return this.getFeatureType();
        }
        if ((class$org$geotools$catalog$Service == null ? (class$org$geotools$catalog$Service = FeatureTypeInfo.class$("org.geotools.catalog.Service")) : class$org$geotools$catalog$Service).isAssignableFrom(adaptee)) {
            return this.getDataStoreInfo();
        }
        if ((class$org$geotools$catalog$GeoResourceInfo == null ? (class$org$geotools$catalog$GeoResourceInfo = FeatureTypeInfo.class$("org.geotools.catalog.GeoResourceInfo")) : class$org$geotools$catalog$GeoResourceInfo).isAssignableFrom(adaptee)) {
            return this.getInfo(monitor);
        }
        return null;
    }

    public GeoResourceInfo getInfo(ProgressListener monitor) throws IOException {
        return new DefaultGeoResourceInfo(this.getTitle(), this.getTypeName(), null, this.getSchemaFile() != null ? this.getSchemaFile().toURI() : null, this.getBoundingBox(), this.getSRS(this.SRS), null, null);
    }

    public Resolve parent(ProgressListener monitor) throws IOException {
        return this.getDataStoreInfo();
    }

    public List members(ProgressListener monitor) throws IOException {
        return null;
    }

    public Resolve.Status getStatus() {
        if (this.isEnabled()) {
            return Resolve.Status.CONNECTED;
        }
        return Resolve.Status.NOTCONNECTED;
    }

    public Throwable getMessage() {
        return null;
    }

    public URI getIdentifier() {
        URI uri = this.getDataStoreInfo().getIdentifier();
        try {
            return new URI(uri.getScheme(), uri.getHost(), uri.getPath(), this.getTypeName());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public void addListener(ResolveChangeListener listener) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeListener(ResolveChangeListener listener) {
    }

    public void fire(ResolveChangeEvent event) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

