/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver;

import javax.servlet.http.HttpServletRequest;
import org.vfny.geoserver.servlets.AbstractService;
import org.vfny.geoserver.util.Requests;

public abstract class Request {
    protected HttpServletRequest httpServletRequest;
    protected String service;
    protected String request = "";
    protected String version = "";
    protected AbstractService serviceRef;

    protected Request(String serviceType, String requestType, AbstractService serviceRef) {
        this.service = serviceType;
        this.request = requestType;
        this.serviceRef = serviceRef;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String requestType) {
        this.request = requestType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setServiceRef(AbstractService serviceRef) {
        this.serviceRef = serviceRef;
    }

    public AbstractService getServiceRef() {
        return this.serviceRef;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Request)) {
            return false;
        }
        Request req = (Request)o;
        boolean equals = true;
        boolean bl = (this.request == null ? req.getRequest() == null : this.request.equals(req.getRequest())) && equals ? true : (equals = false);
        boolean bl2 = (this.version == null ? req.getVersion() == null : this.version.equals(req.getVersion())) && equals ? true : (equals = false);
        equals = (this.service == null ? req.getService() == null : this.service.equals(req.getService())) && equals;
        return equals;
    }

    public int hashCode() {
        int result = 17;
        result = 23 * result + (this.request == null ? 0 : this.request.hashCode());
        result = 23 * result + (this.request == null ? 0 : this.version.hashCode());
        result = 23 * result + (this.request == null ? 0 : this.service.hashCode());
        return result;
    }

    public HttpServletRequest getHttpServletRequest() throws ClassCastException {
        return this.httpServletRequest;
    }

    public String getRootDir() {
        throw new IllegalArgumentException("getRootDir -- functionality removed - please verify that its okay with geoserver_data_dir");
    }

    public String getBaseUrl() {
        return Requests.getBaseUrl(this.getHttpServletRequest(), this.serviceRef.getGeoServer());
    }

    public String getSchemaBaseUrl() {
        return Requests.getSchemaBaseUrl(this.getHttpServletRequest(), this.serviceRef.getGeoServer());
    }

    public boolean isDispatchedRequest() {
        HttpServletRequest hsr = this.getHttpServletRequest();
        String uri = hsr.getRequestURI();
        return uri != null && ((uri = uri.toLowerCase()).endsWith("/wfs") || uri.endsWith("/wms"));
    }

    public boolean isLoggedIn() {
        return Requests.isLoggedIn(this.getHttpServletRequest());
    }

    public void setHttpServletRequest(HttpServletRequest servletRequest) {
        this.httpServletRequest = servletRequest;
    }
}

