/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.util;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionUtils {
    public static List<BooleanExpression> getBooleanExpression(ClosureExpression closureExpression) {
        if (closureExpression == null) {
            return null;
        }
        BlockStatement closureBlockStatement = (BlockStatement)closureExpression.getCode();
        List statementList = closureBlockStatement.getStatements();
        ArrayList<BooleanExpression> booleanExpressions = new ArrayList<BooleanExpression>();
        for (Statement stmt : statementList) {
            BooleanExpression tmp = null;
            if (stmt instanceof ExpressionStatement && ((ExpressionStatement)stmt).getExpression() instanceof BooleanExpression) {
                tmp = (BooleanExpression)((ExpressionStatement)stmt).getExpression();
                tmp.setNodeMetaData((Object)"statementLabel", (Object)stmt.getStatementLabel());
            } else if (stmt instanceof ExpressionStatement) {
                Expression expression = ((ExpressionStatement)stmt).getExpression();
                tmp = new BooleanExpression(expression);
                tmp.setSourcePosition((ASTNode)expression);
                tmp.setNodeMetaData((Object)"statementLabel", (Object)stmt.getStatementLabel());
            }
            booleanExpressions.add(tmp);
        }
        return booleanExpressions;
    }
}

