/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.generation;

import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.io.ReaderSource;
import org.gcontracts.annotations.meta.Precondition;
import org.gcontracts.generation.BaseGenerator;
import org.gcontracts.util.AnnotationUtils;

public class PreconditionGenerator
extends BaseGenerator {
    public PreconditionGenerator(ReaderSource source) {
        super(source);
    }

    public void generatePreconditionAssertionStatement(MethodNode method, BooleanExpression booleanExpression) {
        BooleanExpression preconditionBooleanExpression = this.addCallsToSuperMethodNodeAnnotationClosure(method.getDeclaringClass(), method, Precondition.class, booleanExpression, false);
        BlockStatement blockStatement = this.wrapAssertionBooleanExpression(method.getDeclaringClass(), method, preconditionBooleanExpression, "precondition");
        this.addPrecondition(method, blockStatement);
    }

    public void generateDefaultPreconditionStatement(ClassNode type, MethodNode methodNode) {
        boolean isAnotherPreconditionAvailable;
        boolean bl = isAnotherPreconditionAvailable = AnnotationUtils.getAnnotationNodeInHierarchyWithMetaAnnotation(type.getSuperClass(), methodNode, ClassHelper.makeWithoutCaching(Precondition.class)).size() > 0;
        if (!isAnotherPreconditionAvailable) {
            return;
        }
        BooleanExpression preconditionBooleanExpression = new BooleanExpression((Expression)ConstantExpression.FALSE);
        if ((preconditionBooleanExpression = this.addCallsToSuperMethodNodeAnnotationClosure(type, methodNode, Precondition.class, preconditionBooleanExpression, false)).getExpression() == ConstantExpression.FALSE) {
            return;
        }
        BlockStatement blockStatement = this.wrapAssertionBooleanExpression(type, methodNode, preconditionBooleanExpression, "precondition");
        this.addPrecondition(methodNode, blockStatement);
    }

    private void addPrecondition(MethodNode method, BlockStatement blockStatement) {
        BlockStatement modifiedMethodCode = new BlockStatement();
        modifiedMethodCode.addStatements(blockStatement.getStatements());
        if (method.getCode() instanceof BlockStatement) {
            BlockStatement methodBlock = (BlockStatement)method.getCode();
            for (Statement statement : methodBlock.getStatements()) {
                if (method instanceof ConstructorNode && statement instanceof ExpressionStatement && ((ExpressionStatement)statement).getExpression() instanceof ConstructorCallExpression) {
                    modifiedMethodCode.getStatements().add(0, statement);
                    continue;
                }
                modifiedMethodCode.getStatements().add(statement);
            }
        } else {
            modifiedMethodCode.addStatement(method.getCode());
        }
        method.setCode((Statement)modifiedMethodCode);
    }
}

