/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.generation;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.syntax.Token;
import org.gcontracts.annotations.meta.Postcondition;
import org.gcontracts.generation.AssertStatementCreationUtility;
import org.gcontracts.generation.BaseGenerator;
import org.gcontracts.generation.OldVariableGenerationUtility;
import org.gcontracts.util.AnnotationUtils;

public class PostconditionGenerator
extends BaseGenerator {
    public PostconditionGenerator(ReaderSource source) {
        super(source);
    }

    public void addOldVariablesMethod(ClassNode classNode) {
        OldVariableGenerationUtility.addOldVariableMethodNode(classNode);
    }

    public void generatePostconditionAssertionStatement(MethodNode method, BooleanExpression booleanExpression, boolean isConstructor) {
        BooleanExpression postconditionBooleanExpression = this.addCallsToSuperMethodNodeAnnotationClosure(method.getDeclaringClass(), method, Postcondition.class, booleanExpression, true);
        BlockStatement blockStatement = this.wrapAssertionBooleanExpression(method.getDeclaringClass(), method, postconditionBooleanExpression, "postcondition");
        this.addPostcondition(method, blockStatement);
    }

    public void generateDefaultPostconditionStatement(ClassNode type, MethodNode method) {
        boolean isAnotherPostconditionAvailable;
        boolean bl = isAnotherPostconditionAvailable = AnnotationUtils.getAnnotationNodeInHierarchyWithMetaAnnotation(type.getSuperClass(), method, ClassHelper.makeWithoutCaching(Postcondition.class)).size() > 0;
        if (!isAnotherPostconditionAvailable) {
            return;
        }
        BooleanExpression postconditionBooleanExpression = this.addCallsToSuperMethodNodeAnnotationClosure(method.getDeclaringClass(), method, Postcondition.class, new BooleanExpression((Expression)ConstantExpression.TRUE), true);
        if (postconditionBooleanExpression.getExpression() == ConstantExpression.TRUE) {
            return;
        }
        BlockStatement blockStatement = this.wrapAssertionBooleanExpression(type, method, postconditionBooleanExpression, "postcondition");
        this.addPostcondition(method, blockStatement);
    }

    private void addPostcondition(MethodNode method, BlockStatement postconditionBlockStatement) {
        BlockStatement methodCode = (BlockStatement)method.getCode();
        List statements = methodCode.getStatements();
        if (statements.size() > 0) {
            if (method.getReturnType() != ClassHelper.VOID_TYPE) {
                List<ReturnStatement> returnStatements = AssertStatementCreationUtility.getReturnStatements(method);
                for (ReturnStatement returnStatement : returnStatements) {
                    BlockStatement localPostconditionBlockStatement = new BlockStatement(new ArrayList(postconditionBlockStatement.getStatements()), new VariableScope());
                    ExpressionStatement resultVariableStatement = new ExpressionStatement((Expression)new DeclarationExpression(new VariableExpression("result"), Token.newSymbol((int)100, (int)-1, (int)-1), returnStatement.getExpression()));
                    localPostconditionBlockStatement.getStatements().add(0, resultVariableStatement);
                    AssertStatementCreationUtility.injectResultVariableReturnStatementAndAssertionCallStatement(methodCode, returnStatement, localPostconditionBlockStatement);
                }
                VariableExpression oldVariableExpression = new VariableExpression("old");
                ExpressionStatement oldVariabeStatement = new ExpressionStatement((Expression)new BinaryExpression((Expression)oldVariableExpression, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "$_gc_computeOldVariables", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)));
                BlockStatement oldVariableIfBlock = new BlockStatement();
                oldVariableIfBlock.addStatement((Statement)oldVariabeStatement);
                methodCode.getStatements().add(0, new ExpressionStatement((Expression)new DeclarationExpression(oldVariableExpression, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)ConstantExpression.NULL)));
                methodCode.getStatements().add(1, new IfStatement(new BooleanExpression((Expression)new VariableExpression("$GCONTRACTS_ENABLED")), (Statement)oldVariableIfBlock, (Statement)new BlockStatement()));
            } else if (method instanceof ConstructorNode) {
                methodCode.addStatements(postconditionBlockStatement.getStatements());
            } else {
                VariableExpression oldVariableExpression = new VariableExpression("old");
                ExpressionStatement oldVariabeStatement = new ExpressionStatement((Expression)new BinaryExpression((Expression)oldVariableExpression, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "$_gc_computeOldVariables", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)));
                BlockStatement oldVariableIfBlock = new BlockStatement();
                oldVariableIfBlock.addStatement((Statement)oldVariabeStatement);
                methodCode.getStatements().add(0, new IfStatement(new BooleanExpression((Expression)new VariableExpression("$GCONTRACTS_ENABLED")), (Statement)oldVariableIfBlock, (Statement)new BlockStatement()));
                methodCode.getStatements().add(0, new ExpressionStatement((Expression)new DeclarationExpression(oldVariableExpression, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)ConstantExpression.NULL)));
                methodCode.addStatements(postconditionBlockStatement.getStatements());
            }
        }
    }
}

