/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.generation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.syntax.Token;
import org.gcontracts.ViolationTracker;
import org.gcontracts.generation.ContractExecutionTracker;
import org.gcontracts.util.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseGenerator {
    public static final String INVARIANT_CLOSURE_PREFIX = "invariant";
    public static final String LOCK_FIELD_NAME = "$_gc_lock";
    public static final String LOCK_STATIC_FIELD_NAME = "$_gc_slock";
    protected final ReaderSource source;

    public BaseGenerator(ReaderSource source) {
        this.source = source;
    }

    public static String getInvariantMethodName(ClassNode classNode) {
        return "invariant_" + classNode.getName().replaceAll("\\.", "_");
    }

    public static MethodNode getInvariantMethodNode(ClassNode classNode) {
        return classNode.getDeclaredMethod(BaseGenerator.getInvariantMethodName(classNode), Parameter.EMPTY_ARRAY);
    }

    protected BlockStatement wrapAssertionBooleanExpression(ClassNode type, MethodNode methodNode, BooleanExpression classInvariantExpression, String assertionType) {
        ClassNode violationTrackerClassNode = ClassHelper.makeWithoutCaching(ViolationTracker.class);
        VariableExpression $_gc_result = new VariableExpression("$_gc_result", ClassHelper.boolean_TYPE);
        FieldExpression lockFieldExpression = methodNode.isStatic() ? new FieldExpression(type.getField(LOCK_STATIC_FIELD_NAME)) : new FieldExpression(type.getField(LOCK_FIELD_NAME));
        BlockStatement assertBlockStatement = new BlockStatement();
        TryCatchStatement lockTryCatchStatement = new TryCatchStatement((Statement)assertBlockStatement, (Statement)new BlockStatement(Arrays.asList(new ExpressionStatement((Expression)new MethodCallExpression((Expression)new ClassExpression(ClassHelper.make(ContractExecutionTracker.class)), "clear", (Expression)new ArgumentListExpression(Arrays.asList(new ConstantExpression((Object)type.getName()), new ConstantExpression((Object)methodNode.getTypeDescriptor()), new ConstantExpression((Object)assertionType), methodNode.isStatic() ? ConstantExpression.TRUE : ConstantExpression.FALSE)))), new ExpressionStatement((Expression)new MethodCallExpression((Expression)lockFieldExpression, "unlock", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS))), new VariableScope()));
        BlockStatement ifBlockStatement = new BlockStatement();
        assertBlockStatement.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)lockFieldExpression, "lock", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)));
        assertBlockStatement.addStatement((Statement)new IfStatement(new BooleanExpression((Expression)new MethodCallExpression((Expression)new ClassExpression(ClassHelper.make(ContractExecutionTracker.class)), "track", (Expression)new ArgumentListExpression(Arrays.asList(new ConstantExpression((Object)type.getName()), new ConstantExpression((Object)methodNode.getTypeDescriptor()), new ConstantExpression((Object)assertionType), methodNode.isStatic() ? ConstantExpression.TRUE : ConstantExpression.FALSE)))), (Statement)ifBlockStatement, (Statement)EmptyStatement.INSTANCE));
        ifBlockStatement.addStatement((Statement)new ExpressionStatement((Expression)new DeclarationExpression($_gc_result, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)ConstantExpression.FALSE)));
        ifBlockStatement.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new ClassExpression(violationTrackerClassNode), "init", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)));
        ifBlockStatement.addStatement((Statement)new TryCatchStatement((Statement)new ExpressionStatement((Expression)new BinaryExpression((Expression)$_gc_result, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)classInvariantExpression)), (Statement)EmptyStatement.INSTANCE));
        BlockStatement finallyBlockStatement = new BlockStatement();
        finallyBlockStatement.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new ClassExpression(violationTrackerClassNode), "deinit", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)));
        ifBlockStatement.addStatement((Statement)new IfStatement(new BooleanExpression((Expression)new BinaryExpression((Expression)new NotExpression((Expression)$_gc_result), Token.newSymbol((int)164, (int)-1, (int)-1), (Expression)new MethodCallExpression((Expression)new ClassExpression(violationTrackerClassNode), "violationsOccured", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS))), (Statement)new TryCatchStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new ClassExpression(violationTrackerClassNode), "rethrowFirst", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)), (Statement)finallyBlockStatement), (Statement)new BlockStatement()));
        BlockStatement blockStatement = new BlockStatement();
        blockStatement.addStatement((Statement)new IfStatement(new BooleanExpression((Expression)new VariableExpression("$GCONTRACTS_ENABLED")), (Statement)lockTryCatchStatement, (Statement)new BlockStatement()));
        return blockStatement;
    }

    protected BooleanExpression addCallsToSuperMethodNodeAnnotationClosure(ClassNode type, MethodNode methodNode, Class<? extends Annotation> annotationType, BooleanExpression booleanExpression, boolean isPostcondition) {
        List<AnnotationNode> nextContractElementAnnotations = AnnotationUtils.getAnnotationNodeInHierarchyWithMetaAnnotation(type.getSuperClass(), methodNode, ClassHelper.makeWithoutCaching(annotationType));
        if (nextContractElementAnnotations.isEmpty()) {
            return booleanExpression;
        }
        for (AnnotationNode nextContractElementAnnotation : nextContractElementAnnotations) {
            ClassExpression classExpression = (ClassExpression)nextContractElementAnnotation.getMember("value");
            if (classExpression == null) continue;
            ArgumentListExpression closureConstructorArgumentList = new ArgumentListExpression((Expression)VariableExpression.THIS_EXPRESSION, (Expression)VariableExpression.THIS_EXPRESSION);
            ArgumentListExpression callArgumentList = new ArgumentListExpression();
            for (Parameter parameter : methodNode.getParameters()) {
                callArgumentList.addExpression((Expression)new VariableExpression((Variable)parameter));
            }
            if (isPostcondition && methodNode.getReturnType() != ClassHelper.VOID_TYPE && !(methodNode instanceof ConstructorNode)) {
                callArgumentList.addExpression((Expression)new VariableExpression("result"));
            }
            if (isPostcondition && !(methodNode instanceof ConstructorNode)) {
                callArgumentList.addExpression((Expression)new VariableExpression("old"));
            }
            MethodCallExpression doCall = new MethodCallExpression((Expression)new MethodCallExpression((Expression)classExpression, "newInstance", (Expression)closureConstructorArgumentList), "call", (Expression)callArgumentList);
            BooleanExpression rightExpression = new BooleanExpression((Expression)doCall);
            booleanExpression.setSourcePosition((ASTNode)nextContractElementAnnotation);
            booleanExpression = new BooleanExpression((Expression)new BinaryExpression((Expression)booleanExpression, isPostcondition ? Token.newSymbol((int)164, (int)-1, (int)-1) : Token.newSymbol((int)162, (int)-1, (int)-1), (Expression)rightExpression));
        }
        return booleanExpression;
    }
}

